/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import weblogic.tools.ui.BooleanProperty;
import weblogic.tools.ui.ListProperty;
import weblogic.tools.ui.NumberProperty;
import weblogic.tools.ui.ObjectProperty;
import weblogic.tools.ui.StringProperty;
import weblogic.tools.ui.UIFactory;
import weblogic.utils.Debug;

public abstract class Property
implements FocusListener {
    protected boolean autoCommit = true;
    protected Object bean;
    protected PropertyDescriptor pd;
    protected JLabel label;
    private boolean required;
    private static final Object[] NO_ARGS = new Object[0];

    private static void p(String string) {
        System.err.println("[Property]: " + string);
    }

    public Property(Object object, PropertyDescriptor propertyDescriptor, String string) {
        this(object, propertyDescriptor, string, false);
    }

    public Property(Object object, PropertyDescriptor propertyDescriptor, String string, boolean bl) {
        this.bean = object;
        this.pd = propertyDescriptor;
        if (string == null) {
            string = this.pd.getName();
        }
        this.required = bl;
        this.label = bl ? UIFactory.getMandatoryLabel(string) : UIFactory.getLabel(string);
        Component component = this.getComponent();
        if (component != null) {
            component.addFocusListener(this);
        }
    }

    public abstract Component getComponent();

    protected abstract Object getCurrentUIValue();

    protected abstract void setCurrentUIValue(Object var1);

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.isAutoCommit() && focusEvent.getSource() == this.getComponent()) {
            this.uiToModel();
        }
    }

    public boolean hasSeparateLabel() {
        return true;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object object) {
        this.bean = object;
    }

    public void setTooltip(String string) {
        if (string == null) {
            return;
        }
        Component component = this.getComponent();
        if (component != null && component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.setToolTipText(string);
        }
    }

    public String getHelpAnchor() {
        JComponent jComponent;
        Object object;
        String string = null;
        Component component = this.getComponent();
        if (component != null && component instanceof JComponent && (object = (jComponent = (JComponent)component).getClientProperty("wl.helpanchor")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void setHelpAnchor(String string) {
        Component component = this.getComponent();
        if (component != null && component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("wl.helpanchor", string);
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void modelToUI() {
        this.setCurrentUIValue(this.invokeGetter());
    }

    public boolean isUIEmpty() {
        return false;
    }

    public void uiToModel() {
        this.invokeSetter(this.getCurrentUIValue());
    }

    protected static void handleITE(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable.toString());
    }

    public boolean isRequired() {
        return this.required;
    }

    protected Object invokeGetter() {
        Debug.assertion((this.bean != null ? 1 : 0) != 0);
        try {
            return this.pd.getReadMethod().invoke(this.bean, NO_ARGS);
        }
        catch (InvocationTargetException invocationTargetException) {
            Property.handleITE(invocationTargetException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
    }

    protected void invokeSetter(Object object) {
        Debug.assertion((this.bean != null ? 1 : 0) != 0);
        try {
            Object[] objectArray = new Object[1];
            if (this.pd.getPropertyType() == Integer.TYPE) {
                object = new Integer(Integer.parseInt(object.toString()));
            }
            objectArray[0] = object;
            Debug.assertion((null != this.pd.getWriteMethod() ? 1 : 0) != 0, (String)("Couldn't find a write method for " + this.pd.getReadMethod()));
            this.pd.getWriteMethod().invoke(this.bean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Property.handleITE(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
    }

    public static Property parseSpec(Class clazz, Object object, BeanInfo beanInfo, PropertyDescriptor[] propertyDescriptorArray, Object[] objectArray) {
        String[] stringArray;
        boolean bl;
        if (beanInfo == null) {
            try {
                beanInfo = Introspector.getBeanInfo(clazz);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception.toString());
            }
        }
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        }
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        String string3 = (String)objectArray[2];
        PropertyDescriptor propertyDescriptor = Property.getPD(propertyDescriptorArray, string, clazz);
        Class<?> clazz2 = propertyDescriptor.getPropertyType();
        Property property = null;
        Object object2 = objectArray[objectArray.length - 1];
        boolean bl2 = bl = object2 == Boolean.TRUE;
        if (objectArray.length > 3 && objectArray[3] != null && !(objectArray[3] instanceof Boolean)) {
            if (objectArray[3] instanceof String[]) {
                stringArray = (String[])objectArray[3];
                property = new ListProperty(object, propertyDescriptor, string2, stringArray, bl);
            } else if (objectArray[3] instanceof Object[]) {
                stringArray = (Object[])objectArray[3];
                property = new ObjectProperty(object, propertyDescriptor, string2, stringArray, bl);
            }
        } else {
            property = clazz2 == Boolean.TYPE || clazz2 == Boolean.class ? new BooleanProperty(object, propertyDescriptor, string2) : (clazz2.isPrimitive() || Number.class.isAssignableFrom(clazz2) ? new NumberProperty(object, propertyDescriptor, string2) : new StringProperty(object, propertyDescriptor, string2, bl));
        }
        if (objectArray.length > 4 && objectArray[4] != null) {
            stringArray = objectArray[4].toString();
            property.setHelpAnchor((String)stringArray);
        }
        if (property == null) {
            throw new RuntimeException("bad data for prop: '" + string + "' of " + clazz.getName());
        }
        if (string3 != null) {
            property.setTooltip(string3);
        }
        return property;
    }

    private static Class[] getAllInterfaces(Class clazz) {
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            arrayList.add(clazz2);
            Class<?>[] classArray = clazz2.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                arrayList.add(classArray[i]);
            }
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    static PropertyDescriptor getPD(PropertyDescriptor[] propertyDescriptorArray, String string, Class clazz) {
        PropertyDescriptor propertyDescriptor = null;
        Class clazz2 = clazz;
        Class[] classArray = Property.getAllInterfaces(clazz);
        for (int i = 0; i < classArray.length && propertyDescriptor == null; ++i) {
            for (int j = 0; j < propertyDescriptorArray.length; ++j) {
                if (!string.equalsIgnoreCase(propertyDescriptorArray[j].getName())) continue;
                propertyDescriptor = propertyDescriptorArray[j];
            }
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(classArray[i]);
                propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                continue;
            }
            catch (Exception exception) {
                propertyDescriptorArray = new PropertyDescriptor[]{};
            }
        }
        if (propertyDescriptor == null) {
            throw new RuntimeException("cannot find property '" + string + "' for class " + clazz.getName());
        }
        return propertyDescriptor;
    }
}

