/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import weblogic.tools.ui.BeanRowEditor;
import weblogic.tools.ui.IValidationFeedback;
import weblogic.tools.ui.NumberBox;
import weblogic.tools.ui.Property;
import weblogic.tools.ui.PropertyInfo;
import weblogic.tools.ui.PropertySet;
import weblogic.tools.ui.UIFactory;
import weblogic.tools.ui.ValidationFeedback;

public class PropertyPanel
extends BeanRowEditor
implements LayoutManager {
    PropertySet ps;
    private JComponent[] comps;
    private Insets insets = new Insets(5, 5, 5, 5);

    static void p(String string) {
        System.err.println("[PPanel]: " + string);
    }

    protected PropertyPanel() {
    }

    public PropertyPanel(PropertySet propertySet) {
        this.ps = propertySet;
        this.layoutProps();
    }

    public PropertyPanel(Class clazz, PropertyInfo[] propertyInfoArray) {
        this.ps = new PropertySet(clazz, propertyInfoArray);
        this.layoutProps();
    }

    public PropertyPanel(Object object, Class clazz, Object[][] objectArray) {
        this.ps = new PropertySet(object, clazz, objectArray);
        this.layoutProps();
    }

    public Property findPropByName(String string) {
        return this.ps.findPropByName(string);
    }

    public void setAutoCommit(boolean bl) {
        this.ps.setAutoCommit(bl);
    }

    public JComponent getFirstFocusComponent() {
        Property[] propertyArray;
        JComponent jComponent = null;
        if (this.ps != null && (propertyArray = this.ps.getProps()).length > 0) {
            jComponent = (JComponent)propertyArray[0].getComponent();
        }
        return jComponent;
    }

    public void setEditingBean(Object object) {
        this.ps.setBean(object);
    }

    public IValidationFeedback getFeedback() {
        ValidationFeedback validationFeedback = null;
        Property[] propertyArray = this.ps.getProps();
        for (int i = 0; propertyArray != null && i < propertyArray.length; ++i) {
            Property property = propertyArray[i];
            if (!property.isRequired() || !property.isUIEmpty()) continue;
            String string = '\"' + PropertyPanel.deAnnotate(property.getLabel().getText()) + "\" must be entered";
            validationFeedback = new ValidationFeedback(string, property.getComponent());
            break;
        }
        return validationFeedback;
    }

    public static String deAnnotate(String string) {
        if (string.startsWith("*")) {
            string = string.substring(1);
        }
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        return string.trim();
    }

    public void modelToUI() {
        this.ps.modelToUI();
    }

    public Object createNewBean() {
        return this.ps.createNewBean();
    }

    public void uiToModel() {
        this.ps.uiToModel();
    }

    private void layoutPropsKeyValuePanel() {
        Property[] propertyArray = this.ps.getProps();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = 0; i < propertyArray.length; ++i) {
            Property property = propertyArray[i];
            if (property.hasSeparateLabel()) {
                arrayList.add(property.getLabel());
            } else {
                arrayList.add(UIFactory.getLabel(""));
            }
            arrayList.add(propertyArray[i].getComponent());
        }
        JComponent[] jComponentArray = new JComponent[arrayList.size()];
        arrayList.toArray(jComponentArray);
    }

    private static void ppp(String string) {
        System.out.println("[PropertyPanel] " + string);
    }

    private void layoutProps() {
        this.layoutPropsKeyValuePanel();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void layoutContainer(Container container) {
        Insets insets;
        int n = container.getWidth();
        int n2 = container.getHeight();
        int n3 = this.insets.top;
        Border border = this.getBorder();
        if (border != null && (insets = border.getBorderInsets(this)) != null) {
            n3 += insets.top;
        }
        int n4 = n - this.insets.left - this.insets.right;
        for (int i = 0; i < this.comps.length; ++i) {
            Dimension dimension = this.comps[i].getPreferredSize();
            int n5 = n4;
            if (this.comps[i] instanceof JComboBox || this.comps[i] instanceof NumberBox) {
                n5 = dimension.width;
            }
            if (!(this.comps[i] instanceof JTextField)) {
                n3 += this.insets.top;
            }
            this.comps[i].setBounds(this.insets.left, n3, n5, dimension.height);
            n3 += dimension.height;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets;
        int n = 100;
        int n2 = this.insets.top;
        Border border = this.getBorder();
        if (border != null && (insets = border.getBorderInsets(this)) != null) {
            n2 += insets.top;
            n2 += insets.bottom;
        }
        for (int i = 0; i < this.comps.length; ++i) {
            Dimension dimension = this.comps[i].getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 += this.insets.top;
            n2 += dimension.height;
        }
        return new Dimension(n, n2);
    }

    public void removeLayoutComponent(Component component) {
    }

    public JComponent getComponent() {
        return this;
    }
}

