/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import weblogic.tools.ui.BooleanProperty;
import weblogic.tools.ui.ListProperty;
import weblogic.tools.ui.NumberProperty;
import weblogic.tools.ui.ObjectProperty;
import weblogic.tools.ui.Property;
import weblogic.tools.ui.PropertyInfo;
import weblogic.tools.ui.StringProperty;

public class PropertySet {
    protected Object bean;
    protected Property[] props;
    protected Class bc;

    public PropertySet(Class clazz, Object[][] objectArray) {
        this(null, clazz, objectArray);
    }

    public PropertySet(Class clazz, PropertyInfo[] propertyInfoArray) {
        this.bc = clazz;
        this.props = this.parseInfo(clazz, propertyInfoArray);
    }

    public PropertySet(Object object, Class clazz, Object[][] objectArray) {
        this.bean = object;
        this.bc = clazz;
        this.props = this.parseData(clazz, object, objectArray);
    }

    public PropertySet(Class clazz, Property[] propertyArray) {
        this.bc = clazz;
        this.props = (Property[])propertyArray.clone();
    }

    public void setAutoCommit(boolean bl) {
        for (int i = 0; i < this.props.length; ++i) {
            this.props[i].setAutoCommit(bl);
        }
    }

    public StringProperty findString(String string) {
        Property property = this.findPropByName(string);
        if (property == null) {
            throw new RuntimeException("no such property '" + string + "' on " + this.bc.getName());
        }
        return (StringProperty)property;
    }

    public Property findPropByName(String string) {
        for (int i = 0; this.props != null && i < this.props.length; ++i) {
            if (!string.equalsIgnoreCase(this.props[i].pd.getName())) continue;
            return this.props[i];
        }
        return null;
    }

    public Property[] getProps() {
        return this.props;
    }

    public void setBean(Object object) {
        this.bean = object;
        if (this.bean != null) {
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i].setBean(object);
            }
            this.modelToUI();
        }
    }

    public void modelToUI() {
        for (int i = 0; i < this.props.length; ++i) {
            this.props[i].modelToUI();
        }
    }

    public Object createNewBean() {
        if (this.bc.isInterface()) {
            throw new RuntimeException("cannot instantiate " + this.bc.getName() + " (it is an interface)");
        }
        int n = this.bc.getModifiers();
        if ((n & 1) == 0) {
            throw new RuntimeException("cannot instantiate " + this.bc.getName() + " (not public class)");
        }
        if ((n & 0x400) != 0) {
            throw new RuntimeException("cannot instantiate " + this.bc.getName() + " (it is abstract class)");
        }
        try {
            Class[] classArray = new Class[]{};
            Constructor constructor = this.bc.getDeclaredConstructor(classArray);
            if (constructor != null) {
                return constructor.newInstance(new Object[0]);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Property.handleITE(invocationTargetException);
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("cannot instantiate " + this.bc.getName() + "(it has no public default constructor)");
        }
        return null;
    }

    public void uiToModel() {
        for (int i = 0; i < this.props.length; ++i) {
            this.props[i].uiToModel();
        }
    }

    private Property[] parseInfo(Class clazz, PropertyInfo[] propertyInfoArray) {
        BeanInfo beanInfo = null;
        PropertyDescriptor[] propertyDescriptorArray = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
            propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        Property[] propertyArray = new Property[propertyInfoArray.length];
        for (int i = 0; i < propertyInfoArray.length; ++i) {
            Property property;
            PropertyInfo propertyInfo = propertyInfoArray[i];
            String string = propertyInfo.getName();
            String string2 = propertyInfo.getLabel();
            String string3 = propertyInfo.getTooltip();
            boolean bl = propertyInfo.isRequired();
            PropertyDescriptor propertyDescriptor = Property.getPD(propertyDescriptorArray, string, clazz);
            Class<?> clazz2 = propertyDescriptor.getPropertyType();
            if (propertyInfo.getConstrainedObjects() != null) {
                property = new ObjectProperty(propertyDescriptor, string2, propertyInfo.getConstrainedObjects(), bl);
                ((ObjectProperty)property).setAllowNull(propertyInfo.getAllowNullObject());
                propertyArray[i] = property;
                continue;
            }
            if (propertyInfo.getConstrainedStrings() != null) {
                property = new ListProperty(propertyDescriptor, string2, propertyInfo.getConstrainedStrings(), bl);
                ((ListProperty)property).setAllowEditing(propertyInfo.getAllowListEditing());
                ((ListProperty)property).setSelectFirstElement(propertyInfo.getSelectFirstListElement());
                propertyArray[i] = property;
                continue;
            }
            if (clazz2 == Boolean.TYPE || clazz2 == Boolean.class) {
                propertyArray[i] = new BooleanProperty(propertyDescriptor, string2);
                continue;
            }
            if (clazz2.isPrimitive() || Number.class.isAssignableFrom(clazz2)) {
                property = new NumberProperty(propertyDescriptor, string2);
                ((NumberProperty)property).setMin(propertyInfo.getNumberMin());
                ((NumberProperty)property).setMax(propertyInfo.getNumberMax());
                ((NumberProperty)property).setIncrement(propertyInfo.getNumberIncrement());
                propertyArray[i] = property;
                continue;
            }
            property = new StringProperty(propertyDescriptor, string2, bl);
            ((StringProperty)property).setEmptyIsNull(propertyInfo.isEmptyStringNull());
            propertyArray[i] = property;
        }
        return propertyArray;
    }

    private Property[] parseData(Class clazz, Object object, Object[][] objectArray) {
        PropertyInfo[] propertyInfoArray = new PropertyInfo[objectArray.length];
        for (int i = 0; i < propertyInfoArray.length; ++i) {
            propertyInfoArray[i] = PropertyInfo.fromArray(objectArray[i]);
        }
        return this.parseInfo(clazz, propertyInfoArray);
    }
}

