/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import weblogic.tools.ui.AWTUtils;
import weblogic.tools.ui.IBeanRowEditor;
import weblogic.tools.ui.IValidationFeedback;
import weblogic.tools.ui.MarathonTextFormatter;

public class RowEditorDialog
extends JDialog
implements ActionListener {
    private static final MarathonTextFormatter fmt = new MarathonTextFormatter();
    JButton ok;
    JButton cancel;
    boolean okclicked = false;
    private IBeanRowEditor editor;
    Frame owner;
    private boolean m_wasCancelled = false;
    private static final int MAX_HEIGHT = 600;
    private static final int MAX_WIDTH = 500;

    public RowEditorDialog(Frame frame, String string, boolean bl, IBeanRowEditor iBeanRowEditor) {
        super(frame, string, bl);
        this.owner = frame;
        this.editor = iBeanRowEditor;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.editor.getComponent());
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = this.makeButtonPane();
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this.getRootPane().setDefaultButton(this.ok);
        this.pack();
    }

    public void pack() {
        super.pack();
        Dimension dimension = this.editor.getComponent().getSize();
        dimension.width = (int)Math.max(dimension.getWidth(), 500.0);
        dimension.height = (int)Math.max(dimension.getHeight(), 600.0);
        this.setSize(dimension);
    }

    public IBeanRowEditor getBeanRowEditor() {
        return this.editor;
    }

    public final void editObject(Object object) {
        this.setAutoCommit(false);
        this.editor.setEditingBean(object);
        this.okclicked = false;
        this.pack();
        AWTUtils.centerOnWindow(this, this.owner);
        JComponent jComponent = this.editor.getFirstFocusComponent();
        if (jComponent != null) {
            jComponent.requestFocus();
        }
        this.setVisible(true);
    }

    public boolean wasCancelled() {
        return this.m_wasCancelled;
    }

    public void onEscPressed() {
        this.m_wasCancelled = true;
    }

    public final Object addObject() {
        Object object = this.editor.createNewBean();
        this.editObject(object);
        return this.okclicked ? object : null;
    }

    private JPanel makeButtonPane() {
        JPanel jPanel = new JPanel();
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.ok, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)this.cancel, gridBagConstraints);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.m_wasCancelled = false;
            IValidationFeedback iValidationFeedback = this.editor.getFeedback();
            if (iValidationFeedback != null) {
                this.showError(iValidationFeedback);
                return;
            }
            this.editor.uiToModel();
            this.okclicked = true;
        } else if (actionEvent.getSource() == this.cancel) {
            this.m_wasCancelled = true;
        }
        this.setAutoCommit(true);
        this.setVisible(false);
    }

    private void showError(IValidationFeedback iValidationFeedback) {
        Component component = iValidationFeedback.getFocusComponent();
        JOptionPane.showMessageDialog(this, iValidationFeedback.getMessage(), fmt.getIncompleteSettings(), 0);
        if (component != null) {
            component.requestFocus();
        }
    }

    private void setAutoCommit(boolean bl) {
        this.editor.setAutoCommit(bl);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n != 112) {
            return;
        }
        Component component = SwingUtilities.findFocusOwner(this);
        Object var4_4 = null;
    }

    private static void ppp(String string) {
        System.out.println("[RowEditorDialog] " + string);
    }
}

