/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private Thread thread;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object object) {
        this.value = object;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread thread2 = this.threadVar.get();
        if (thread2 != null) {
            thread2.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread thread2;
        while ((thread2 = this.threadVar.get()) != null) {
            try {
                thread2.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable runnable = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(runnable);
            }
        };
        Thread thread2 = new Thread(runnable2);
        this.threadVar = new ThreadVar(thread2);
    }

    public void start() {
        Thread thread2 = this.threadVar.get();
        if (thread2 != null) {
            thread2.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread2) {
            this.thread = thread2;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

