/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import weblogic.tools.ui.MarathonTextFormatter;
import weblogic.tools.ui.NumberBox;
import weblogic.tools.ui.SortedComboBox;
import weblogic.tools.ui.Util;

public class UIFactory {
    public static int STD_DIALOG_WIDTH = 300;
    public static int STD_DIALOG_HEIGHT = 125;
    private static MarathonTextFormatter m_fmt = new MarathonTextFormatter();
    private static Action copyAction;
    private static Action pasteAction;
    private static Action cutAction;
    private static Class clazz;
    private static ImageIcon emptyIcon;
    private static Action clearAction;
    private static Action[] editableComponentActions;
    private static Action[] nonEditableComponentActions;
    private static int comboBoxMinWidth;
    private static Image m_busyImage;
    private static ImageIcon m_busyIcon;
    String[] m_funBusyImages = new String[]{"/weblogic/marathon/resources/images/animations/itchy.gif", "/weblogic/marathon/resources/images/animations/hellokty.gif", "/weblogic/marathon/resources/images/animations/womanwrench.gif", "/weblogic/marathon/resources/images/animations/stimpy.gif"};
    private boolean m_funImages = true;
    public static final int STD_COMP_BUFFER_VALUE = 11;

    public static ImageIcon getIcon(String string) {
        URL uRL;
        ImageIcon imageIcon = null;
        if (string != null && (uRL = clazz.getResource(string)) != null) {
            imageIcon = new ImageIcon(uRL);
        }
        if (imageIcon == null) {
            imageIcon = emptyIcon;
        }
        return imageIcon;
    }

    public static JFrame getFrame(String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.setSize(500, 300);
        return jFrame;
    }

    public static Action getCutAction() {
        return cutAction;
    }

    public static Action getCopyAction() {
        return copyAction;
    }

    public static Action getPasteAction() {
        return pasteAction;
    }

    public static JTextArea getTextArea(boolean bl) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(bl);
        return (JTextArea)UIFactory.setupListeners(jTextArea, bl);
    }

    private static JTextComponent setupListeners(JTextComponent jTextComponent, boolean bl) {
        return jTextComponent;
    }

    public static JTextArea getTextArea() {
        return UIFactory.getTextArea(true);
    }

    public static JTextField getTextField() {
        return UIFactory.getTextField(true);
    }

    public static JTextField getTextField(int n) {
        return UIFactory.getTextField(true, n);
    }

    public static JTextField getTextField(boolean bl, int n) {
        return (JTextField)UIFactory.setupListeners(new JTextField(n), bl);
    }

    public static JTextField getTextField(boolean bl) {
        return (JTextField)UIFactory.setupListeners(new JTextField(), bl);
    }

    public static JTextField getPasswordField() {
        return new JPasswordField();
    }

    public static NumberBox getIntegerField() {
        return new NumberBox();
    }

    public static JRadioButton getRadioButton() {
        return new JRadioButton();
    }

    public static JRadioButton getRadioButton(String string) {
        return new JRadioButton(string);
    }

    public static JCheckBox getCheckBox() {
        return new JCheckBox();
    }

    public static JToggleButton getToggleButton(String string) {
        return new JToggleButton(string);
    }

    public static JButton getButton(String string) {
        return new JButton(string);
    }

    public static JButton getChooser() {
        return new JButton(m_fmt.getBrowseEllipsis());
    }

    public static JTextField getTextField(String string) {
        JTextField jTextField = UIFactory.getTextField(true);
        jTextField.setText(string);
        jTextField = (JTextField)UIFactory.setupListeners(jTextField, true);
        return jTextField;
    }

    public static JLabel getLabel(String string) {
        JLabel jLabel = new JLabel(string);
        return jLabel;
    }

    public static JLabel getMandatoryLabel(String string) {
        JLabel jLabel = new JLabel(UIFactory.formatMandatory(string));
        return jLabel;
    }

    public static JLabel getMandatoryLabel(String string, int n) {
        JLabel jLabel = new JLabel(UIFactory.formatMandatory(string), n);
        return jLabel;
    }

    public static JLabel getLabel(String string, int n) {
        JLabel jLabel = new JLabel(string, n);
        return jLabel;
    }

    public static JCheckBox getCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox(string);
        return jCheckBox;
    }

    public static JComboBox getSortedComboBox() {
        SortedComboBox sortedComboBox = new SortedComboBox();
        Component component = sortedComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).setColumns(40);
        }
        return sortedComboBox;
    }

    public static JComboBox getComboBox() {
        return UIFactory.getComboBox(new String[0]);
    }

    public static JComboBox getComboBox(Object[] objectArray) {
        JComboBox jComboBox = new JComboBox(objectArray){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = super.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                return dimension;
            }
        };
        Component component = jComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).setColumns(40);
        }
        Dimension dimension = jComboBox.getMinimumSize();
        dimension.width = Math.max(dimension.width, UIFactory.getComboBoxMinWidth(jComboBox));
        jComboBox.setMinimumSize(dimension);
        jComboBox.setEditable(true);
        return jComboBox;
    }

    private static synchronized int getComboBoxMinWidth(JComboBox jComboBox) {
        if (comboBoxMinWidth != -1) {
            return comboBoxMinWidth;
        }
        Font font = jComboBox.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        comboBoxMinWidth = fontMetrics.stringWidth("abcdefghij");
        return comboBoxMinWidth;
    }

    public static JList getList() {
        return new JList(new DefaultListModel());
    }

    public static JTable getTable() {
        return new JTable();
    }

    public static Image getBusyImage() {
        if (null == m_busyImage) {
            m_busyImage = Util.loadImage("/weblogic/marathon/resources/images/animations/validate_animation.gif");
        }
        return m_busyImage;
    }

    public static ImageIcon getBusyIcon() {
        if (null == m_busyIcon) {
            m_busyIcon = new ImageIcon(UIFactory.getBusyImage());
        }
        return m_busyIcon;
    }

    public static JDialog getBusyDialog(Component component, String string, String string2) {
        JDialog jDialog = null;
        JOptionPane jOptionPane = new JOptionPane(string, 1, -1, UIFactory.getBusyIcon());
        jDialog = jOptionPane.createDialog(component, string2);
        jDialog.setModal(false);
        return jDialog;
    }

    public static GridBagConstraints getBasicGridBagConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        return gridBagConstraints;
    }

    public static GridBagConstraints getSimpleGridBagConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 5;
        gridBagConstraints.insets = new Insets(n, n, n, n);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        return gridBagConstraints;
    }

    public static GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.insets = new Insets(n, n, n, n);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        return gridBagConstraints;
    }

    public static String formatMandatory(String string) {
        return "* " + string;
    }

    private static String formatNormal(String string) {
        return string;
    }

    private static void ppp(String string) {
        System.out.println("[UIFactory] " + string);
    }

    static {
        clearAction = new AbstractAction("Clear"){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                Component component = null;
                if (object instanceof Component) {
                    component = (Component)object;
                    while (component != null) {
                        if (component instanceof JTextComponent) {
                            ((JTextComponent)component).setText("");
                            break;
                        }
                        if (component instanceof JPopupMenu) {
                            component = ((JPopupMenu)component).getInvoker();
                            continue;
                        }
                        component = component.getParent();
                    }
                }
            }
        };
        clazz = new UIFactory().getClass();
        emptyIcon = UIFactory.getIcon("/weblogic/tools/ui/images/emptyIcon.gif");
        ImageIcon imageIcon = UIFactory.getIcon("/weblogic/marathon/resources/images/toolbar/copy.gif");
        copyAction = new DefaultEditorKit.CopyAction();
        copyAction.putValue("Name", m_fmt.getCopy());
        copyAction.putValue("SmallIcon", imageIcon);
        imageIcon = UIFactory.getIcon("/weblogic/marathon/resources/images/toolbar/cut.gif");
        cutAction = new DefaultEditorKit.CutAction();
        cutAction.putValue("Name", m_fmt.getCut());
        cutAction.putValue("SmallIcon", imageIcon);
        imageIcon = UIFactory.getIcon("/weblogic/marathon/resources/images/toolbar/paste.gif");
        pasteAction = new DefaultEditorKit.PasteAction();
        pasteAction.putValue("Name", m_fmt.getPaste());
        pasteAction.putValue("SmallIcon", imageIcon);
        Action[] actionArray = new Action[]{cutAction, copyAction, pasteAction};
        editableComponentActions = actionArray;
        Action[] actionArray2 = new Action[]{copyAction, clearAction};
        nonEditableComponentActions = actionArray2;
        comboBoxMinWidth = -1;
        m_busyImage = null;
        m_busyIcon = null;
    }
}

