/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import weblogic.Home;
import weblogic.tools.ui.NumberBox;

public class Util {
    private static final boolean debug = false;
    private static int PATH_DISPLAY_THRESHOLD_LEN = 40;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;

    public static void centerWindow(Window window, Window window2) {
        Point point = window2.getLocation();
        Point point2 = new Point();
        Dimension dimension = window2.getSize();
        Dimension dimension2 = window.getSize();
        point2.x = point.x + dimension.width / 2 - dimension2.width / 2;
        point2.y = point.y + dimension.height / 2 - dimension2.height / 2;
        if (point2.x < 0) {
            point2.x = point.x;
        }
        if (point2.y < 0) {
            point2.y = point.y;
        }
        window.setLocation(point2);
    }

    public static void centerWindow(Window window) {
        Point point = new Point();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        point.x = dimension.width / 2 - dimension2.width / 2;
        point.y = dimension.height / 2 - dimension2.height / 2;
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        window.setLocation(point);
    }

    public static void frontAndCenter(Window window) {
        Util.centerWindow(window);
    }

    public static void frontAndCenter(Window window, Window window2) {
        Util.centerWindow(window, window2);
    }

    public static String[] splitCompletely(String string, String string2, boolean bl) {
        return Util.splitCompletely(new StringTokenizer(string, string2, bl));
    }

    public static String[] splitCompletely(String string, String string2) {
        return Util.splitCompletely(new StringTokenizer(string, string2));
    }

    public static String[] splitCompletely(String string) {
        return Util.splitCompletely(new StringTokenizer(string));
    }

    private static String[] splitCompletely(StringTokenizer stringTokenizer) {
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static void initLookAndFeel(String string) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (string != null) {
            try {
                if (string.equals("java")) {
                    UIManager.setLookAndFeel("javax.swing.jlf.JLFLookAndFeel");
                } else if (string.equals("basic")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.basic.BasicLookAndFeel");
                } else if (string.equals("metal")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                } else if (string.equals("motif")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                } else if (string.startsWith("win")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                } else {
                    UIManager.setLookAndFeel(string);
                }
                return;
            }
            catch (Exception exception) {
                string = null;
            }
        }
        try {
            String string2 = System.getProperty("os.name");
            if (string2 != null && ((string2 = string2.toLowerCase()).indexOf("digital unix") >= 0 || string2.indexOf("linux") >= 0 || string2.indexOf("solaris") >= 0)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    public static Image loadImage(ClassLoader classLoader, String string) {
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return Util.loadImage(string);
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            return toolkit.createImage((ImageProducer)uRL.getContent());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Image loadImage(String string) {
        try {
            URL uRL = Util.class.getResource(string);
            if (uRL == null) {
                uRL = Util.class.getResource("/weblogic/graphics/" + string);
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            return toolkit.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URL getResourceURL(String string) {
        URL uRL = null;
        int n = string.lastIndexOf(35);
        if (n >= 0) {
            String string2 = string.substring(n + 1);
            uRL = Util.class.getResource(string = string.substring(0, n));
            if (uRL != null) {
                try {
                    uRL = new URL(uRL, '#' + string2);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else {
            uRL = Util.class.getResource(string);
            if (uRL == null) {
                uRL = Util.class.getResource("/weblogic/graphics/" + string);
            }
        }
        return uRL;
    }

    public static String getResourceString(String string, ResourceBundle resourceBundle) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            String string2 = "Missing string resource(" + string + ")";
            System.out.println(string2);
            return string2;
        }
    }

    public static char getResourceChar(String string, ResourceBundle resourceBundle) {
        try {
            return resourceBundle.getString(string).charAt(0);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            return '\u0000';
        }
    }

    public static void setTextFieldEnabled(JTextField jTextField, boolean bl) {
        jTextField.setEnabled(bl);
        jTextField.repaint();
    }

    public static void setLabelEnabled(JLabel jLabel, boolean bl) {
        jLabel.setEnabled(bl);
        jLabel.repaint();
    }

    public static void setPanelEnabled(JPanel jPanel, boolean bl) {
        Component[] componentArray = jPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof JPanel) {
                Util.setPanelEnabled((JPanel)componentArray[i], bl);
            }
            if (componentArray[i] instanceof JTextField) {
                Util.setTextFieldEnabled((JTextField)componentArray[i], bl);
                continue;
            }
            if (componentArray[i] instanceof JLabel) {
                Util.setLabelEnabled((JLabel)componentArray[i], bl);
                continue;
            }
            componentArray[i].setEnabled(bl);
            componentArray[i].repaint();
        }
    }

    public static JFrame getComponentFrame(Component component) {
        return (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, component);
    }

    public static Window getComponentWindow(Component component) {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, component);
    }

    public static String getTypeName(Class clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
                stringBuffer.append(clazz2.getName());
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("[]");
                }
                return stringBuffer.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clazz.getName();
    }

    public static String format(String string, Object[] objectArray) {
        return MessageFormat.format(string, objectArray);
    }

    public static File getFile(String string) {
        File file = new File(string);
        try {
            return new File(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public static String getPath(File file) {
        if (file != null) {
            try {
                return file.getCanonicalPath();
            }
            catch (Exception exception) {
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    public static String getPathLeaf(String string) {
        if (string.indexOf(File.separatorChar) != -1) {
            string = string.replace(File.separatorChar, '/');
        }
        return string.substring(string.lastIndexOf(47) + 1);
    }

    public static String getPathParent(String string) {
        if (string.indexOf(File.separatorChar) != -1) {
            string = string.replace(File.separatorChar, '/');
        }
        return string.substring(0, string.lastIndexOf(47) + 1);
    }

    public static boolean mkdirs(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null directory file");
        }
        if (!file.exists()) {
            String string;
            String string2 = Util.getPath(file);
            int n = string2.length();
            if (n > PATH_DISPLAY_THRESHOLD_LEN) {
                string2 = "..." + string2.substring(n - PATH_DISPLAY_THRESHOLD_LEN);
            }
            if (Util.confirm(null, "Create directory?", string = "The directory\n" + string2 + "\ndoes not exist. Create it?")) {
                return file.mkdirs();
            }
        }
        return true;
    }

    public static boolean confirm(Component component, String string, String string2) {
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(component, string2, string, 0, 3, null, objectArray, objectArray[1]);
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                throw new Error("Boolean logic fails us!");
            }
        }
        return bl;
    }

    public static int confirmWithCancel(Component component, String string, String string2) {
        Object[] objectArray = new Object[]{"Yes", "No", "Cancel"};
        return JOptionPane.showOptionDialog(component, string2, string, 1, 3, null, objectArray, objectArray[0]);
    }

    public static void copyFile(InputStream inputStream, File file) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        while ((n = inputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        bufferedOutputStream.close();
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        Util.copyFile(bufferedInputStream, file2);
    }

    public static URL toURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    public static void gatherFiles(File file, Hashtable hashtable) {
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2.isDirectory()) {
                    Util.gatherFiles(file2, hashtable);
                    continue;
                }
                hashtable.put(file2.getPath(), file2);
            }
        }
    }

    public static void clearFiles(File file) {
        String[] stringArray;
        if (file != null && file.isDirectory() && file.exists() && (stringArray = file.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                file2.delete();
            }
        }
    }

    public static String getFileURL(String string) {
        String string2 = Home.getPath();
        string2 = string2.replace(File.separatorChar, '/');
        return string2 + "/classes" + string;
    }

    private static void focusOnFirstWidget(JComponent jComponent) {
        if (null != jComponent) {
            Component component = null;
            JComponent[] jComponentArray = Util.findAllFocusableComponents(jComponent);
            for (int i = 0; i < jComponentArray.length; ++i) {
                JComponent jComponent2 = jComponentArray[i];
                if (i == 0) {
                    component = jComponent2;
                    continue;
                }
                Util.ppp("THIS:" + ((Component)jComponent2).getX() + " " + ((Component)jComponent2).getY());
                Util.ppp("FIRST:" + component.getX() + " " + component.getY());
                if (((Component)jComponent2).getX() >= component.getX() || ((Component)jComponent2).getY() >= component.getY()) continue;
                Util.ppp("NEW FIRST COMP AT " + ((Component)jComponent2).getX() + " " + ((Component)jComponent2).getY());
                component = jComponent2;
            }
            if (null != component) {
                component.requestFocus();
            }
        }
    }

    private static JComponent[] findAllFocusableComponents(Component component) {
        ArrayList arrayList = new ArrayList();
        if (component instanceof JComponent) {
            Util.findAllFocusableComponents((JComponent)component, arrayList);
        }
        return arrayList.toArray(new JComponent[0]);
    }

    private static void findAllFocusableComponents(Component component, List list) {
        if (component instanceof JComponent) {
            Component[] componentArray = ((JComponent)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (Util.isInputWidget(componentArray[i])) {
                    list.add(componentArray[i]);
                    continue;
                }
                ArrayList arrayList = new ArrayList();
                Util.findAllFocusableComponents(componentArray[i], arrayList);
                for (Object e : arrayList) {
                    list.add(e);
                }
            }
        }
    }

    private static boolean isInputWidget(Component component) {
        return component instanceof JComboBox || component instanceof JTextComponent || component instanceof JToggleButton || component instanceof NumberBox;
    }

    private static void ppp(String string) {
        System.out.println("[Util] " + string);
    }
}

