/*
 * Decompiled with CFR 0.152.
 */
package weblogic.tools.ui.progress;

import java.util.Arrays;
import java.util.Vector;
import weblogic.tools.ui.progress.ProgressEvent;
import weblogic.tools.ui.progress.ProgressListener;
import weblogic.tools.ui.progress.ProgressProducer;
import weblogic.utils.Debug;

public class ProgressDispatcher
implements ProgressListener {
    protected ProgressListener[] listeners;
    protected ProgressEvent event = new ProgressEvent();
    private ProgressProducer progressProducer;

    public void updateProgress(ProgressEvent progressEvent) {
        this.update(progressEvent);
    }

    public void update(String string) {
        this.update(string, 1);
    }

    public void update(String string, int n) {
        this.event.setEventInfo(string, n);
        this.update(this.event);
    }

    public void addProgressListener(ProgressListener progressListener) {
        Debug.assertion((progressListener != null ? 1 : 0) != 0);
        Vector<Object> vector = new Vector<Object>();
        if (this.listeners != null) {
            vector.addAll(Arrays.asList((Object[])this.listeners));
        }
        vector.add(progressListener);
        this.listeners = new ProgressListener[vector.size()];
        vector.copyInto(this.listeners);
    }

    private void update(ProgressEvent progressEvent) {
        if (null != this.listeners) {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].updateProgress(progressEvent);
            }
        }
    }

    public void setProgressProducer(ProgressProducer progressProducer) {
        this.progressProducer = progressProducer;
    }
}

