/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction;

import javax.naming.Context;
import javax.transaction.UserTransaction;
import javax.transaction.xa.Xid;
import weblogic.kernel.Kernel;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.ClientTxHelper;
import weblogic.transaction.InterposedTransactionManager;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.XIDFactory;
import weblogic.transaction.internal.TransactionManagerImpl;

public class TxHelper
extends ClientTxHelper {
    public static Transaction getTransaction() {
        return (Transaction)TransactionHelper.getTransactionHelper().getTransaction();
    }

    public static UserTransaction getUserTransaction() {
        return TransactionHelper.getTransactionHelper().getUserTransaction();
    }

    public static ClientTransactionManager getClientTransactionManager() {
        return TransactionHelper.getTransactionHelper().getTransactionManager();
    }

    public static String getTransactionId() {
        Xid xid;
        Transaction transaction;
        if (TransactionManagerImpl.isInitialized() && (transaction = TxHelper.getTransaction()) != null && (xid = transaction.getXID()) != null) {
            return xid.toString();
        }
        return null;
    }

    public static InterposedTransactionManager getServerInterposedTransactionManager() {
        if (Kernel.isServer()) {
            return TransactionManagerImpl.getTransactionManager();
        }
        return null;
    }

    public static InterposedTransactionManager getClientInterposedTransactionManager(Context context, String string) {
        try {
            return (InterposedTransactionManager)context.lookup("weblogic.transaction.coordinators." + string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String status2String(int n) {
        switch (n) {
            case 0: {
                return "Active";
            }
            case 3: {
                return "Committed";
            }
            case 8: {
                return "Committing";
            }
            case 1: {
                return "Marked Rollback";
            }
            case 6: {
                return "No Transaction";
            }
            case 2: {
                return "Prepared";
            }
            case 7: {
                return "Preparing";
            }
            case 4: {
                return "Rolledback";
            }
            case 9: {
                return "Rolling Back";
            }
            case 5: {
                return "Unknown";
            }
        }
        return "Unknown";
    }

    public static Xid createXid(int n, byte[] byArray, byte[] byArray2) {
        return XIDFactory.createXID((int)n, (byte[])byArray, (byte[])byArray2);
    }

    public static Xid createXid(byte[] byArray, byte[] byArray2) {
        return XIDFactory.createXID((byte[])byArray, (byte[])byArray2);
    }

    public static String xidToString(Xid xid, boolean bl) {
        return XIDFactory.xidToString((Xid)xid, (boolean)bl);
    }
}

