/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TransactionManagerImpl;
import weblogic.transaction.internal.TxDebug;

public final class ClientInitiatedTxShutdownService
extends AbstractServerService {
    private static int state = 0;
    private static final Object stateLock = new String("LifecycleState");
    private static final Object suspendLock = new String("LifecycleSuspend");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop() throws ServiceFailureException {
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("SUSPENDING ...");
        }
        state = 4;
        ServerTransactionManagerImpl serverTransactionManagerImpl = ClientInitiatedTxShutdownService.getTM();
        Object object = suspendLock;
        // MONITORENTER : object
        try {
            block18: {
                try {
                    if (!serverTransactionManagerImpl.isTxMapEmpty()) {
                        TXLogger.logPendingTxDuringShutdown();
                        suspendLock.wait(ClientInitiatedTxShutdownService.getTM().getTransactionTimeout() * 1000);
                        state = 3;
                        break block18;
                    }
                    state = 3;
                }
                catch (InterruptedException interruptedException) {
                    Object var5_4 = null;
                    Object object4 = stateLock;
                    // MONITORENTER : object4
                    if (state != 3) {
                        if (!TxDebug.JTALifecycle.isDebugEnabled()) throw new ServiceFailureException("ClientInitiatedTransactionService suspend failed");
                        TxDebug.JTALifecycle.debug("suspendFailed");
                        throw new ServiceFailureException("ClientInitiatedTransactionService suspend failed");
                    }
                    if (TxDebug.JTALifecycle.isDebugEnabled()) {
                        TxDebug.JTALifecycle.debug("suspendSuccessfullyCompleted");
                    }
                    // MONITOREXIT : object4
                }
            }
            Object var5_3 = null;
            Object object2 = stateLock;
            // MONITORENTER : object2
            if (state != 3) {
                if (!TxDebug.JTALifecycle.isDebugEnabled()) throw new ServiceFailureException("ClientInitiatedTransactionService suspend failed");
                TxDebug.JTALifecycle.debug("suspendFailed");
                throw new ServiceFailureException("ClientInitiatedTransactionService suspend failed");
            }
            if (TxDebug.JTALifecycle.isDebugEnabled()) {
                TxDebug.JTALifecycle.debug("suspendSuccessfullyCompleted");
            }
            // MONITOREXIT : object2
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Object object3 = stateLock;
            // MONITORENTER : object3
            if (state != 3) {
                if (!TxDebug.JTALifecycle.isDebugEnabled()) throw new ServiceFailureException("ClientInitiatedTransactionService suspend failed");
                TxDebug.JTALifecycle.debug("suspendFailed");
                throw new ServiceFailureException("ClientInitiatedTransactionService suspend failed");
            }
            if (TxDebug.JTALifecycle.isDebugEnabled()) {
                TxDebug.JTALifecycle.debug("suspendSuccessfullyCompleted");
                throw throwable;
            }
            // MONITOREXIT : object3
            throw throwable;
        }
        // MONITOREXIT : object
        if (!TxDebug.JTALifecycle.isDebugEnabled()) return;
        TxDebug.JTALifecycle.debug("SUSPEND DONE");
    }

    public void halt() throws ServiceFailureException {
        state = 3;
    }

    public void start() throws ServiceFailureException {
        state = 2;
    }

    static boolean isSuspending() {
        return state == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void suspendDone() {
        Object object = suspendLock;
        synchronized (object) {
            if (state == 4) {
                state = 3;
            }
            suspendLock.notify();
        }
    }

    private static ServerTransactionManagerImpl getTM() {
        return (ServerTransactionManagerImpl)TransactionManagerImpl.getTransactionManager();
    }

    public static boolean isTxMapEmpty() {
        return ClientInitiatedTxShutdownService.getTM().isTxMapEmpty();
    }

    public static int getTxTimeoutMillis() {
        return ClientInitiatedTxShutdownService.getTM().getTransactionTimeout() * 1000;
    }
}

