/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.management.runtime.JTATransaction;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.cluster.ThreadPreferredHost;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.internal.CoordinatorDescriptor;
import weblogic.transaction.internal.CoordinatorDescriptorManager;
import weblogic.transaction.internal.JTARecoveryRuntime;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.TransactionHelperImpl;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TransactionManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientPlatformHelperImpl
extends PlatformHelper {
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    Channel findAdminChannel(ServerIdentity serverIdentity) {
        return null;
    }

    boolean isJNDIEnabled() {
        return true;
    }

    String getRootName() {
        return "weblogic.transaction";
    }

    Context getInitialContext(String string) throws NamingException {
        return this.getInitialContext(string, true);
    }

    Context getInitialContext(String string, boolean bl) throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string != null) {
            hashtable.put("java.naming.provider.url", string);
        }
        hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        return new InitialContext(hashtable);
    }

    boolean extendCoordinatorURL(String string) {
        return false;
    }

    private static final boolean ignoreProtocol(String string, String string2) {
        String string3 = ClientPlatformHelperImpl.getExtendedProtocol(string2);
        return string.equalsIgnoreCase("iiop") || string.equalsIgnoreCase("tgiop") || string3 != null;
    }

    private static final String getServerName(String string) {
        int n = string.indexOf(43);
        return n == -1 ? null : string.substring(0, n);
    }

    String getDomainName(String string) {
        int n = string.indexOf(43);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(43, n + 1);
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf(43, n2 + 1);
        if (n3 == -1) {
            return null;
        }
        return string.substring(n2 + 1, n3);
    }

    private static final String getProtocol(String string) {
        int n = string.indexOf(43);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(43, n + 1);
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf(43, n2 + 1);
        if (n3 == -1) {
            return null;
        }
        int n4 = string.indexOf(43, n3 + 1);
        if (n4 == -1) {
            return null;
        }
        return string.substring(n3 + 1, n4);
    }

    private static final String getExtendedProtocol(String string) {
        int n = string.indexOf(43);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(43, n + 1);
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf(43, n2 + 1);
        if (n3 == -1) {
            return null;
        }
        int n4 = string.indexOf(43, n3 + 1);
        if (n4 == -1) {
            return null;
        }
        int n5 = string.indexOf(43, n4 + 1);
        if (n5 == -1) {
            return null;
        }
        return string.substring(n4 + 1, n5);
    }

    private static final String getHostPort(String string) {
        int n = string.indexOf(43);
        int n2 = string.indexOf(43, n + 1);
        if (n2 > n) {
            return string.substring(n + 1, n2);
        }
        return string.substring(n + 1);
    }

    private static final String getHost(String string) {
        String string2 = ClientPlatformHelperImpl.getHostPort(string);
        int n = string2.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string2.substring(0, n);
    }

    private static final String getAdminProtocol(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    String getAdminPort(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(58, n + 1);
        return string.substring(n2 + 1);
    }

    boolean openPrimaryStore(boolean bl) {
        return false;
    }

    public void setPrimaryStore(PersistentStore persistentStore) {
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        persistentStoreManager.setDefaultStore(persistentStore);
    }

    PersistentStore getPrimaryStore() {
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        PersistentStore persistentStore = persistentStoreManager.getDefaultStore();
        return persistentStore;
    }

    public PersistentStore getStore(String string, String string2) throws PersistentStoreException {
        return null;
    }

    void closeStore(PersistentStore persistentStore) throws PersistentStoreException {
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        persistentStoreManager.closeFileStore(persistentStore.getName());
    }

    int getQOSAdmin() {
        return 0;
    }

    boolean isLocalAdminChannelEnabled() {
        return false;
    }

    String findLocalAdminChannelURL(String string) {
        return null;
    }

    String findLocalSSLURL(String string) {
        return null;
    }

    public boolean isSSLURL(String string) {
        return ClientPlatformHelperImpl.getProtocol(string).equalsIgnoreCase("t3s") || ClientPlatformHelperImpl.getProtocol(string).equalsIgnoreCase("https");
    }

    boolean isCheckpointLLR() {
        return false;
    }

    void dumpTLOG(String string, String string2, boolean bl) throws PersistentStoreException {
    }

    void dumpJDBCTLOG(String string, String string2, String string3, String string4) throws PersistentStoreException {
    }

    boolean isTransactionServiceRunning() {
        return false;
    }

    boolean isServerRunning() {
        return false;
    }

    String getDomainName() {
        return null;
    }

    void doTimerLifecycleHousekeeping() {
    }

    JTARecoveryRuntime getJTARecoveryRuntime(String string) {
        return null;
    }

    void scheduleFailBack(String string) {
    }

    JTATransaction createJTATransaction(TransactionImpl transactionImpl) {
        return null;
    }

    TransactionHelper getTransactionHelper() {
        return new TransactionHelperImpl();
    }

    boolean sendRequest(Object object) {
        EndPoint endPoint = (EndPoint)object;
        TransactionImpl transactionImpl = (TransactionImpl)ClientPlatformHelperImpl.getTM().getTransaction();
        if (endPoint != null && endPoint.getHostID() instanceof ServerIdentity) {
            ServerIdentity serverIdentity = (ServerIdentity)endPoint.getHostID();
            transactionImpl.setPreferredHost((HostID)serverIdentity);
            return transactionImpl.setCoordinatorDescriptor(serverIdentity, endPoint.getRemoteChannel());
        }
        return false;
    }

    void sendRequestServer(Object object) {
    }

    private static TransactionManagerImpl getTM() {
        return TransactionManagerImpl.getTransactionManager();
    }

    public CoordinatorDescriptorManager getCoordinatorDescriptorManager() {
        return null;
    }

    public void associateThreadPreferredHost(TransactionImpl transactionImpl, TransactionManagerImpl.TxThreadProperty txThreadProperty) {
        if (transactionImpl != null) {
            if (!txThreadProperty.preferredHostSetForTx) {
                txThreadProperty.preTxPreferredHost = ThreadPreferredHost.get();
                txThreadProperty.preferredHostSetForTx = true;
            }
            transactionImpl.setActiveThread(Thread.currentThread());
            ThreadPreferredHost.set((HostID)transactionImpl.getPreferredHost());
        } else if (txThreadProperty.preferredHostSetForTx) {
            ThreadPreferredHost.set((HostID)txThreadProperty.preTxPreferredHost);
            txThreadProperty.preferredHostSetForTx = false;
            txThreadProperty.preTxPreferredHost = null;
        }
    }

    DisconnectMonitor getDisconnectMonitor() {
        return DisconnectMonitorListImpl.getDisconnectMonitor();
    }

    AuthenticatedSubject getRemoteSubject(String string) throws IOException, RemoteException {
        return null;
    }

    final boolean isInCluster() {
        return false;
    }

    Collection<String> getActiveServersInCluster() {
        return null;
    }

    CoordinatorDescriptor findServerInClusterByLocalJNDI(String string, Collection collection) {
        Collection<String> collection2 = this.getActiveServersInCluster();
        return null;
    }

    boolean isServer() {
        return false;
    }

    void registerRMITransactionInterceptor(Interceptor interceptor) {
        InterceptorManager.getManager().setTransactionInterceptor(interceptor);
    }

    boolean isCDSEnabled() {
        return false;
    }

    boolean isDomainExcluded(String string) {
        return false;
    }

    int getInteropMode() {
        return 0;
    }

    public ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public AuthenticatedSubject getCurrentSubject() {
        return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)this.getKernelID());
    }

    private AuthenticatedSubject getKernelID() {
        return kernelID;
    }
}

