/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.t3.srvr.T3Srvr;
import weblogic.transaction.TransactionSystemException;
import weblogic.transaction.internal.AbortRequestedException;
import weblogic.transaction.internal.Constants;
import weblogic.transaction.internal.Coordinator3;
import weblogic.transaction.internal.CoordinatorDescriptor;
import weblogic.transaction.internal.CoordinatorOneway2;
import weblogic.transaction.internal.CoordinatorService;
import weblogic.transaction.internal.JNDIAdvertiser;
import weblogic.transaction.internal.PropagationContext;
import weblogic.transaction.internal.ReceiveSecureAction;
import weblogic.transaction.internal.SecureAction;
import weblogic.transaction.internal.ServerCoordinatorDescriptor;
import weblogic.transaction.internal.ServerTransactionImpl;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.SubCoordinatorImpl;
import weblogic.transaction.internal.SubCoordinatorOneway;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TransactionManagerImpl;
import weblogic.transaction.internal.TransactionService;
import weblogic.transaction.internal.TxDebug;
import weblogic.transaction.internal.XAResourceHelper;

class CoordinatorImpl
extends SubCoordinatorImpl
implements Coordinator3,
CoordinatorOneway2,
Constants,
CoordinatorService {
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    CoordinatorImpl() {
    }

    public void commit(PropagationContext propagationContext) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        EndPoint endPoint;
        PeerInfo peerInfo = null;
        try {
            endPoint = ServerHelper.getClientEndPoint();
            if (endPoint != null && endPoint instanceof PeerInfoable) {
                peerInfo = ((PeerInfoable)endPoint).getPeerInfo();
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug("co.commit  is the call coming from a server: " + peerInfo.isServer());
        }
        if (peerInfo != null && peerInfo.isServer() && ReceiveSecureAction.stranger(this.getHostID(), "co.commit")) {
            TXLogger.logUserNotAuthorizedForCommit((String)this.getUserName());
            return;
        }
        if (!TransactionService.isRunning()) {
            throw new SystemException("The server is being suspended or shut down.  No new transaction commit requests will be accepted.");
        }
        try {
            endPoint = (ServerTransactionImpl)propagationContext.getTransaction();
        }
        catch (TransactionSystemException transactionSystemException) {
            throw new SystemException(transactionSystemException.getMessage());
        }
        if (endPoint == null) {
            throw new RollbackException("This transaction does not exist on the coordinating server.  It was probably rolled back and forgotten.");
        }
        if (!endPoint.isImportedTransaction()) {
            endPoint.setOwnerTransactionManager((TransactionManagerImpl)this.getTM());
            endPoint.commit();
        } else {
            try {
                endPoint.internalCommit(true);
            }
            catch (AbortRequestedException abortRequestedException) {
            }
            catch (XAException xAException) {
                // empty catch block
            }
        }
    }

    public void ackPrePrepare(PropagationContext propagationContext) {
        ServerTransactionImpl serverTransactionImpl;
        if (ReceiveSecureAction.stranger(this.getHostID(), "ackPrePrepare")) {
            TXLogger.logUserNotAuthorizedForAckPrePrepare((String)this.getUserName());
            return;
        }
        try {
            serverTransactionImpl = (ServerTransactionImpl)propagationContext.getTransaction();
        }
        catch (TransactionSystemException transactionSystemException) {
            return;
        }
        if (serverTransactionImpl == null) {
            return;
        }
        serverTransactionImpl.ackPrePrepare();
    }

    public void ackPrepare(Xid xid, String string, int n) {
        block4: {
            if (ReceiveSecureAction.stranger(this.getHostID(), "ackPrepare")) {
                TXLogger.logUserNotAuthorizedForAckPrepare((String)this.getUserName());
                return;
            }
            try {
                ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
                if (serverTransactionImpl == null) {
                    return;
                }
                serverTransactionImpl.ackPrepare(string, n);
            }
            catch (Throwable throwable) {
                if (!TxDebug.JTA2PC.isDebugEnabled()) break block4;
                TxDebug.JTA2PC.debug("ackPrepare FAILED", throwable);
            }
        }
    }

    public void rollback(PropagationContext propagationContext) throws IllegalStateException, SystemException {
        EndPoint endPoint;
        PeerInfo peerInfo = null;
        try {
            endPoint = ServerHelper.getClientEndPoint();
            if (endPoint != null && endPoint instanceof PeerInfoable) {
                peerInfo = ((PeerInfoable)endPoint).getPeerInfo();
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        if (peerInfo != null && peerInfo.isServer() && ReceiveSecureAction.stranger(this.getHostID(), "co.rollback")) {
            TXLogger.logUserNotAuthorizedForRollback((String)this.getUserName());
            return;
        }
        try {
            endPoint = (ServerTransactionImpl)propagationContext.getTransaction();
        }
        catch (TransactionSystemException transactionSystemException) {
            throw new SystemException(transactionSystemException.getMessage());
        }
        if (endPoint != null) {
            if (!endPoint.isImportedTransaction()) {
                endPoint.rollback();
            } else {
                endPoint.internalRollback();
            }
        }
    }

    public void checkStatus(Xid[] xidArray, String string) {
        block9: {
            CoordinatorDescriptor coordinatorDescriptor;
            SubCoordinatorOneway subCoordinatorOneway;
            int n;
            if (T3Srvr.getT3Srvr().getRunState() != 2) {
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.JTA2PC.debug("CO checkStatus: return because server is not in Running state, for SC=" + string);
                }
                return;
            }
            if (ReceiveSecureAction.stranger(this.getHostID(), "checkStatus")) {
                TXLogger.logUserNotAuthorizedForCheckStatus((String)this.getUserName());
                return;
            }
            ServerTransactionImpl serverTransactionImpl = null;
            ArrayList<Xid> arrayList = null;
            int n2 = n = xidArray == null ? 0 : xidArray.length;
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                TxDebug.JTA2PC.debug("CO checkStatus: for SC=" + string + " " + n + " XIDs");
            }
            for (int i = 0; i < n; ++i) {
                serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xidArray[i]);
                if (serverTransactionImpl != null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Xid>(1);
                }
                arrayList.add(xidArray[i]);
            }
            if (arrayList != null && (subCoordinatorOneway = JNDIAdvertiser.getSubCoordinator((CoordinatorDescriptor)(coordinatorDescriptor = ServerCoordinatorDescriptor.getOrCreate((String)string)), (TransactionImpl)serverTransactionImpl)) != null) {
                Xid[] xidArray2 = new Xid[arrayList.size()];
                try {
                    SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new StartRollbackAction(subCoordinatorOneway, arrayList.toArray(xidArray2)), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"sc.startRollback");
                }
                catch (Exception exception) {
                    if (!TxDebug.JTA2PC.isDebugEnabled()) break block9;
                    TxDebug.JTA2PC.debug("CO get sc.startRollback failure: ", (Throwable)exception);
                }
            }
        }
    }

    public void ackCommit(Xid xid, String string) {
        if (ReceiveSecureAction.stranger(this.getHostID(), "ackCommit")) {
            TXLogger.logUserNotAuthorizedForAckCommit((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (serverTransactionImpl == null) {
            return;
        }
        serverTransactionImpl.ackCommit(string);
    }

    public void ackCommit(Xid xid, String string, String[] stringArray) {
        if (ReceiveSecureAction.stranger(this.getHostID(), "ackCommit")) {
            TXLogger.logUserNotAuthorizedForAckCommit((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (serverTransactionImpl == null) {
            return;
        }
        serverTransactionImpl.ackCommit(string, stringArray);
    }

    public void nakCommit(Xid xid, String string, short s, String string2) {
        if (ReceiveSecureAction.stranger(this.getHostID(), "nakCommit")) {
            TXLogger.logUserNotAuthorizedForNakCommit((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (serverTransactionImpl == null) {
            return;
        }
        serverTransactionImpl.nakCommit(string, s, string2);
    }

    public void nakCommit(Xid xid, String string, short s, String string2, String[] stringArray, String[] stringArray2) {
        if (ReceiveSecureAction.stranger(this.getHostID(), "nakCommit")) {
            TXLogger.logUserNotAuthorizedForNakCommit((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (serverTransactionImpl == null) {
            return;
        }
        serverTransactionImpl.nakCommit(string, s, string2, stringArray, stringArray2);
    }

    public void startRollback(PropagationContext propagationContext) throws RemoteException {
        if (ReceiveSecureAction.stranger(this.getHostID(), "startRollback")) {
            TXLogger.logUserNotAuthorizedForStartRollback((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)propagationContext.getTransaction();
        if (serverTransactionImpl != null) {
            try {
                serverTransactionImpl.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void ackRollback(Xid xid, String string) {
        if (ReceiveSecureAction.stranger(this.getHostID(), "ackRollback")) {
            TXLogger.logUserNotAuthorizedForAckRollback((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (serverTransactionImpl == null) {
            return;
        }
        serverTransactionImpl.ackRollback(string);
    }

    public void ackRollback(Xid xid, String string, String[] stringArray) {
        if (ReceiveSecureAction.stranger(this.getHostID(), "ackRollback")) {
            TXLogger.logUserNotAuthorizedForAckRollback((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (serverTransactionImpl == null) {
            return;
        }
        serverTransactionImpl.ackRollback(string, stringArray);
    }

    public void nakRollback(Xid xid, String string, short s, String string2) {
        if (ReceiveSecureAction.stranger(this.getHostID(), "nakRollback")) {
            TXLogger.logUserNotAuthorizedForNakRollback((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (serverTransactionImpl == null) {
            return;
        }
        serverTransactionImpl.nakRollback(string, s, string2);
    }

    public void nakRollback(Xid xid, String string, short s, String string2, String[] stringArray, String[] stringArray2) {
        if (ReceiveSecureAction.stranger(this.getHostID(), "nakRollback")) {
            TXLogger.logUserNotAuthorizedForNakRollback((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (serverTransactionImpl == null) {
            return;
        }
        serverTransactionImpl.nakRollback(string, s, string2, stringArray, stringArray2);
    }

    public Map getProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        hashMap.put("propagationContextVersion", new Integer(PropagationContext.getVersion()));
        hashMap.put("coordinatorURL", this.getTM().getLocalCoordinatorURL());
        String string = ManagementService.getRuntimeAccess(kernelID).getServerName();
        hashMap.put("serverName", string);
        return hashMap;
    }

    public void xaPrepare(PropagationContext propagationContext) throws XAException {
        ServerTransactionImpl serverTransactionImpl = null;
        try {
            serverTransactionImpl = (ServerTransactionImpl)propagationContext.getTransaction();
        }
        catch (TransactionSystemException transactionSystemException) {
            XAResourceHelper.throwXAException((int)-3, (String)"Cannot prepare imported transaction.", (Throwable)transactionSystemException);
        }
        if (serverTransactionImpl != null) {
            this.getTM().getXAResource().prepare(serverTransactionImpl.getForeignXid());
        }
    }

    public void xaCommit(Xid xid) throws XAException {
        if (!TransactionService.isRunning()) {
            XAResourceHelper.throwXAException((int)-3, (String)"The server is being suspend or shut down.  No new transaction commit requests will be accepted.");
        }
        this.getTM().getXAResource().commit(xid, false);
    }

    public void xaRollback(Xid xid) throws XAException {
        this.getTM().getXAResource().rollback(xid);
    }

    public Xid[] xaRecover() throws XAException {
        return this.getTM().getXAResource().recover(0x1800000);
    }

    public void xaForget(Xid xid) {
        if (TxDebug.JTAGateway.isDebugEnabled()) {
            TxDebug.JTAGateway.debug("Coordinator.forget(foreignXid=" + XAResourceHelper.xidToString((Xid)xid) + ")");
        }
        try {
            this.getTM().getXAResource().forget(xid);
        }
        catch (XAException xAException) {
            // empty catch block
        }
    }

    public void forceGlobalRollback(Xid xid) throws SystemException, RemoteException {
        EndPoint endPoint;
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug("SC.forceGlobalRollback: " + xid);
        }
        PeerInfo peerInfo = null;
        try {
            endPoint = ServerHelper.getClientEndPoint();
            if (endPoint != null && endPoint instanceof PeerInfoable) {
                peerInfo = ((PeerInfoable)endPoint).getPeerInfo();
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        if (peerInfo != null && peerInfo.isServer()) {
            if (ReceiveSecureAction.stranger(this.getHostID(), "forceGlobalRollback")) {
                TXLogger.logUserNotAuthorizedForForceGlobalRollback((String)this.getUserName());
                return;
            }
        } else {
            return;
        }
        endPoint = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (endPoint == null) {
            TXLogger.logForceGlobalRollbackNoTx((String)xid.toString());
            return;
        }
        endPoint.forceGlobalRollback();
    }

    public void forceGlobalCommit(Xid xid) throws SystemException, RemoteException {
        EndPoint endPoint;
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug("SC.forceGlobalCommit: " + xid);
        }
        PeerInfo peerInfo = null;
        try {
            endPoint = ServerHelper.getClientEndPoint();
            if (endPoint != null && endPoint instanceof PeerInfoable) {
                peerInfo = ((PeerInfoable)endPoint).getPeerInfo();
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        if (peerInfo != null && peerInfo.isServer()) {
            if (ReceiveSecureAction.stranger(this.getHostID(), "forceGlobalCommit")) {
                TXLogger.logUserNotAuthorizedForForceGlobalCommit((String)this.getUserName());
                return;
            }
        } else {
            return;
        }
        endPoint = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (endPoint == null) {
            TXLogger.logForceGlobalCommitNoTx((String)xid.toString());
            return;
        }
        endPoint.forceGlobalCommit();
    }

    public Object invokeCoordinatorService(String string, Object object) throws RemoteException, SystemException {
        ServerTransactionManagerImpl serverTransactionManagerImpl = this.getTM();
        return serverTransactionManagerImpl.invokeCoordinatorService(string, object);
    }

    protected HostID getHostID() {
        try {
            EndPoint endPoint = ServerHelper.getClientEndPoint();
            HostID hostID = endPoint.getHostID();
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("RMI call coming from = " + ((ServerIdentity)hostID).getDomainName());
            }
            return hostID;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getUserName() {
        return SubjectUtils.getUsername((AuthenticatedSubject)SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelID));
    }

    private class StartRollbackAction
    implements PrivilegedExceptionAction {
        private SubCoordinatorOneway sc;
        private Xid[] xids;

        StartRollbackAction(SubCoordinatorOneway subCoordinatorOneway, Xid[] xidArray) {
            this.sc = subCoordinatorOneway;
            this.xids = xidArray;
        }

        public Object run() throws Exception {
            this.sc.startRollback(this.xids);
            return null;
        }
    }
}

