/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.health.HealthState;
import weblogic.transaction.internal.DiagnosticImageTimeoutException;
import weblogic.transaction.internal.JTAImageSource;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.xml.stax.util.XMLPrettyPrinter;

public class JTADiagnosticImageSource
implements JTAImageSource {
    private ServerTransactionManagerImpl tm;
    private boolean timedOut;

    JTADiagnosticImageSource(ServerTransactionManagerImpl serverTransactionManagerImpl) {
        this.tm = serverTransactionManagerImpl;
    }

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        try {
            XMLPrettyPrinter xMLPrettyPrinter = new XMLPrettyPrinter((Writer)new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8")), 2);
            xMLPrettyPrinter.writeStartDocument();
            try {
                this.tm.dump((JTAImageSource)this, (XMLStreamWriter)xMLPrettyPrinter);
            }
            catch (DiagnosticImageTimeoutException diagnosticImageTimeoutException) {
                this.dumpTimeoutComment((XMLStreamWriter)xMLPrettyPrinter);
                return;
            }
            xMLPrettyPrinter.writeEndDocument();
            xMLPrettyPrinter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ImageSourceCreationException("JTA image creation failed.", (Throwable)xMLStreamException);
        }
        catch (IOException iOException) {
            throw new ImageSourceCreationException("JTA image creation failed.", (Throwable)iOException);
        }
    }

    public static void dumpHealthStateElement(XMLStreamWriter xMLStreamWriter, HealthState healthState) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("Health");
        xMLStreamWriter.writeAttribute("state", HealthState.mapToString(healthState.getState()));
        String[] stringArray = healthState.getReasonCode();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                xMLStreamWriter.writeStartElement("Reason");
                xMLStreamWriter.writeCharacters(stringArray[i]);
                xMLStreamWriter.writeEndElement();
            }
        }
        xMLStreamWriter.writeEndElement();
    }

    public void timeoutImageCreation() {
        this.timedOut = true;
    }

    public void checkTimeout() throws DiagnosticImageTimeoutException {
        if (this.timedOut) {
            throw new DiagnosticImageTimeoutException();
        }
    }

    public void dumpTimeoutComment(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeComment("Diagnostic image creation timed out, aborting image dump");
    }
}

