/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.security.AccessController;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.JTARecoveryRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.internal.JTARecoveryRuntime;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.TransactionRecoveryService;

public class JTARecoveryRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements JTARecoveryRuntimeMBean,
JTARecoveryRuntime {
    private TransactionRecoveryService trs;
    private int initialTotalCount = -1;
    private int finalCompletionCount = -1;
    private static AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public JTARecoveryRuntimeMBeanImpl(TransactionRecoveryService transactionRecoveryService) throws ManagementException {
        super(transactionRecoveryService.getServerName(), (RuntimeMBean)ManagementService.getRuntimeAccess(kernelID).getServerRuntime().getJTARuntime(), true, "RecoveryRuntimeMBeans");
        this.trs = transactionRecoveryService;
    }

    public void reset(int n) {
        this.initialTotalCount = n;
        this.finalCompletionCount = -1;
    }

    public void setFinalTransactionCompletionCount(int n) {
        this.finalCompletionCount = n;
    }

    public boolean isActive() {
        return this.trs.isActive();
    }

    public int getInitialRecoveredTransactionTotalCount() {
        return this.initialTotalCount;
    }

    public int getRecoveredTransactionCompletionPercent() {
        int n = this.finalCompletionCount;
        if (n == -1) {
            n = JTARecoveryRuntimeMBeanImpl.getTM().getRecoveredTransactionCompletionCount(this.trs.getServerName());
        }
        if (n == -1) {
            n = this.finalCompletionCount;
        }
        if (n == -1) {
            return -1;
        }
        double d = (double)n / (double)this.initialTotalCount;
        return (int)(d * 100.0);
    }

    private static ServerTransactionManagerImpl getTM() {
        return (ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager();
    }
}

