/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.xa.Xid;
import weblogic.health.HealthFeedback;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TransactionLogJDBCStoreMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.JTARecoveryRuntimeMBean;
import weblogic.management.runtime.JTARuntimeMBean;
import weblogic.management.runtime.JTATransaction;
import weblogic.management.runtime.NonXAResourceRuntimeMBean;
import weblogic.management.runtime.PersistentStoreRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.TransactionNameRuntimeMBean;
import weblogic.management.runtime.TransactionResourceRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.admin.PersistentStoreRuntimeMBeanImpl;
import weblogic.transaction.Transaction;
import weblogic.transaction.internal.Constants;
import weblogic.transaction.internal.HealthEvent;
import weblogic.transaction.internal.JTAHealthListener;
import weblogic.transaction.internal.JTARuntime;
import weblogic.transaction.internal.JTATransactionImpl;
import weblogic.transaction.internal.JTATransactionStatisticsImpl;
import weblogic.transaction.internal.NonXAResourceRuntime;
import weblogic.transaction.internal.NonXAResourceRuntimeImpl;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.ServerTransactionImpl;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.TXExceptionLogger;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TransactionNameRuntimeImpl;
import weblogic.transaction.internal.TransactionRecoveryService;
import weblogic.transaction.internal.TransactionResourceRuntime;
import weblogic.transaction.internal.TransactionResourceRuntimeImpl;
import weblogic.transaction.internal.TxDebug;
import weblogic.transaction.internal.XidImpl;

public final class JTARuntimeImpl
extends JTATransactionStatisticsImpl
implements Constants,
JTARuntimeMBean,
JTAHealthListener,
JTARuntime {
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final long serialVersionUID = -3773752601197689481L;
    public static final String OVERFLOW_NAME = "weblogic.transaction.statistics.namedOverflow";
    private long namedInstanceCounter;
    private HashMap namedStats = new HashMap();
    private TransactionNameRuntimeImpl namedOverflow = null;
    private ServerTransactionManagerImpl tm;
    private ArrayList registeredResources = new ArrayList(5);
    private ArrayList registeredNonXAResources = new ArrayList(5);
    private Health health = new Health();
    private HealthFeedback jdbcStoreHealthFeedback;
    private Health jdbcStoreHealth = new Health();
    private boolean isJDBCStoreHealthRegistered;
    private boolean isAutomaticMigrationMode = true;
    private static final String HEALTH_JTA_SUBSYSTEM_NAME = "JTA";
    private static final String HEALTH_JTA_JDBCSTORE_SUBSYSTEM_NAME = "JTA_JDBCSTORE";
    private volatile Set txNameRuntimes = new HashSet();
    private Set txResourceRuntimes = new HashSet();
    private Set nonXAResourceRuntimes = new HashSet();
    private PersistentStoreRuntimeMBeanImpl persistentStoreRuntimeMBean;

    public JTARuntimeImpl(String string, ServerTransactionManagerImpl serverTransactionManagerImpl) throws ManagementException {
        super(string, ManagementService.getRuntimeAccess(kernelID).getServerRuntime());
        ManagementService.getRuntimeAccess(kernelID).getServerRuntime().setJTARuntime(this);
        this.tm = serverTransactionManagerImpl;
    }

    JTARuntimeImpl(String string, ServerTransactionManagerImpl serverTransactionManagerImpl, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string, runtimeMBean);
        this.tm = serverTransactionManagerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tallyCompletion(Transaction transaction) {
        super.tallyCompletion(transaction);
        String string = transaction.getName();
        TransactionNameRuntimeImpl transactionNameRuntimeImpl = null;
        if (string != null) {
            HashMap hashMap = this.namedStats;
            synchronized (hashMap) {
                transactionNameRuntimeImpl = (TransactionNameRuntimeImpl)this.namedStats.get(string);
                if (transactionNameRuntimeImpl == null) {
                    if (this.namedStats.size() >= this.tm.getMaxUniqueNameStatistics()) {
                        if (this.namedOverflow == null) {
                            try {
                                this.namedOverflow = (TransactionNameRuntimeImpl)SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new CreateNamedMBeanAction(OVERFLOW_NAME, this.namedInstanceCounter++, this));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        transactionNameRuntimeImpl = this.namedOverflow;
                    } else {
                        try {
                            transactionNameRuntimeImpl = (TransactionNameRuntimeImpl)SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new CreateNamedMBeanAction(string, this.namedInstanceCounter++, this));
                            this.namedStats.put(string, transactionNameRuntimeImpl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (transactionNameRuntimeImpl != null) {
                transactionNameRuntimeImpl.tallyCompletion(transaction);
            }
        }
    }

    public TransactionNameRuntimeMBean[] getTransactionNameRuntimeMBeans() throws RemoteException {
        return this.txNameRuntimes.toArray(new TransactionNameRuntimeMBean[this.txNameRuntimes.size()]);
    }

    public boolean addTransactionNameRuntimeMBean(TransactionNameRuntimeMBean transactionNameRuntimeMBean) {
        return this.txNameRuntimes.add(transactionNameRuntimeMBean);
    }

    public boolean removeTransactionNameRuntimeMBean(TransactionNameRuntimeMBean transactionNameRuntimeMBean) {
        return this.txNameRuntimes.remove(transactionNameRuntimeMBean);
    }

    public TransactionResourceRuntimeMBean[] getTransactionResourceRuntimeMBeans() throws RemoteException {
        int n = this.txResourceRuntimes.size();
        return this.txResourceRuntimes.toArray(new TransactionResourceRuntimeMBean[n]);
    }

    public boolean addTransactionResourceRuntimeMBean(TransactionResourceRuntimeMBean transactionResourceRuntimeMBean) {
        return this.txResourceRuntimes.add(transactionResourceRuntimeMBean);
    }

    public boolean removeTransactionResourceRuntimeMBean(TransactionResourceRuntimeMBean transactionResourceRuntimeMBean) {
        return this.txResourceRuntimes.remove(transactionResourceRuntimeMBean);
    }

    public NonXAResourceRuntimeMBean[] getNonXAResourceRuntimeMBeans() throws RemoteException {
        int n = this.nonXAResourceRuntimes.size();
        return this.nonXAResourceRuntimes.toArray(new NonXAResourceRuntimeMBean[n]);
    }

    public boolean addNonXAResourceRuntimeMBean(NonXAResourceRuntimeMBean nonXAResourceRuntimeMBean) {
        return this.nonXAResourceRuntimes.add(nonXAResourceRuntimeMBean);
    }

    public boolean removeNonXAResourceRuntimeMBean(NonXAResourceRuntimeMBean nonXAResourceRuntimeMBean) {
        return this.nonXAResourceRuntimes.remove(nonXAResourceRuntimeMBean);
    }

    public JTATransaction[] getJTATransactions() {
        return this.getTransactionsOlderThan(new Integer(0));
    }

    public JTATransaction[] getTransactionsOlderThan(Integer n) {
        JTATransaction[] jTATransactionArray;
        ArrayList<JTATransactionImpl> arrayList = new ArrayList<JTATransactionImpl>();
        Iterator iterator = this.tm.getTransactions();
        if (iterator == null) {
            return new JTATransaction[0];
        }
        while (iterator.hasNext()) {
            ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)iterator.next();
            if (serverTransactionImpl.getMillisSinceBegin() < (long)(n * 1000)) continue;
            arrayList.add(new JTATransactionImpl(serverTransactionImpl));
        }
        if (arrayList.size() > 0) {
            arrayList.trimToSize();
            jTATransactionArray = new JTATransaction[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                jTATransactionArray[i] = (JTATransaction)arrayList.get(i);
            }
        } else {
            jTATransactionArray = new JTATransaction[]{};
        }
        return jTATransactionArray;
    }

    public String[] getRegisteredResourceNames() {
        return this.registeredResources.toArray(new String[this.registeredResources.size()]);
    }

    public String[] getRegisteredNonXAResourceNames() {
        return this.registeredNonXAResources.toArray(new String[this.registeredNonXAResources.size()]);
    }

    public int getActiveTransactionsTotalCount() {
        return this.tm == null ? 0 : this.tm.getNumTransactions();
    }

    public JTARecoveryRuntimeMBean[] getRecoveryRuntimeMBeans() {
        return TransactionRecoveryService.getAllRuntimeMBeans();
    }

    public JTARecoveryRuntimeMBean getRecoveryRuntimeMBean(String string) {
        return (JTARecoveryRuntimeMBean)TransactionRecoveryService.getRuntimeMBean(string);
    }

    public HealthState getHealthState() {
        return this.health.getState();
    }

    public TransactionResourceRuntime registerResource(String string) throws Exception {
        return (TransactionResourceRuntime)SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new CreateResourceMBeanAction(this, string, this.registeredResources));
    }

    public void unregisterResource(TransactionResourceRuntime transactionResourceRuntime) throws Exception {
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new UnregisterResourceMBeanAction(this, (TransactionResourceRuntimeMBean)transactionResourceRuntime, this.registeredResources));
        this.healthEvent(new HealthEvent(7, transactionResourceRuntime.getResourceName(), "Resource " + transactionResourceRuntime.getResourceName() + " has been unregistered"));
    }

    public NonXAResourceRuntime registerNonXAResource(String string) throws Exception {
        return (NonXAResourceRuntime)SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new CreateNonXAResourceMBeanAction(this, string, this.registeredNonXAResources));
    }

    public void unregisterNonXAResource(NonXAResourceRuntime nonXAResourceRuntime) throws Exception {
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new UnregisterNonXAResourceMBeanAction(this, (NonXAResourceRuntimeMBean)nonXAResourceRuntime, this.registeredNonXAResources));
    }

    public void healthEvent(HealthEvent healthEvent) {
        this.health.healthEvent(healthEvent);
    }

    public void forceLocalRollback(Xid xid) throws RemoteException {
        TXLogger.logForceLocalRollbackInvoked((String)xid.toString());
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.tm.getTransaction(xid);
        if (serverTransactionImpl == null) {
            TXLogger.logForceLocalRollbackNoTx((String)xid.toString());
            throw new RemoteException("forceLocalRollback invoked on unknown transaction '" + xid + "'");
        }
        try {
            serverTransactionImpl.forceLocalRollback();
        }
        catch (Exception exception) {
            TXLogger.logForceLocalRollbackFailed((String)xid.toString(), (Throwable)exception);
            throw new RemoteException("Unable to perform local rollback", exception);
        }
    }

    public void forceGlobalRollback(Xid xid) throws RemoteException {
        TXLogger.logForceGlobalRollbackInvoked((String)xid.toString());
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.tm.getTransaction(xid);
        if (serverTransactionImpl == null) {
            TXLogger.logForceGlobalRollbackNoTx((String)xid.toString());
            throw new RemoteException("forceLocalRollback invoked on unknown transaction '" + xid + "'");
        }
        try {
            serverTransactionImpl.forceGlobalRollback();
        }
        catch (Exception exception) {
            TXLogger.logForceGlobalRollbackFailed((String)xid.toString(), (Throwable)exception);
            throw new RemoteException("Unable to perform global rollback", exception);
        }
    }

    public void forceLocalCommit(Xid xid) throws RemoteException {
        TXLogger.logForceLocalCommitInvoked((String)xid.toString());
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.tm.getTransaction(xid);
        if (serverTransactionImpl == null) {
            TXLogger.logForceLocalCommitNoTx((String)xid.toString());
            throw new RemoteException("forceLocalCommit invoked on unknown transaction '" + xid + "'");
        }
        try {
            serverTransactionImpl.forceLocalCommit();
        }
        catch (Exception exception) {
            TXLogger.logForceLocalCommitFailed((String)xid.toString(), (Throwable)exception);
            throw new RemoteException("Unable to perform local commit", exception);
        }
    }

    public void forceGlobalCommit(Xid xid) throws RemoteException {
        TXLogger.logForceGlobalCommitInvoked((String)xid.toString());
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.tm.getTransaction(xid);
        if (serverTransactionImpl == null) {
            TXLogger.logForceGlobalCommitNoTx((String)xid.toString());
            throw new RemoteException("forceLocalCommit invoked on unknown transaction '" + xid + "'");
        }
        try {
            serverTransactionImpl.forceGlobalCommit();
        }
        catch (Exception exception) {
            TXLogger.logForceGlobalCommitFailed((String)xid.toString(), (Throwable)exception);
            throw new RemoteException("Unable to perform global commit", exception);
        }
    }

    public JTATransaction getJTATransaction(String string) throws RemoteException {
        XidImpl xidImpl = XidImpl.create((String)string);
        if (xidImpl == null) {
            return null;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.tm.getTransaction((Xid)xidImpl);
        if (serverTransactionImpl == null) {
            return null;
        }
        return new JTATransactionImpl(serverTransactionImpl);
    }

    void registerWithHealthService() {
        if (TxDebug.JTAHealth.isDebugEnabled()) {
            TxDebug.JTAHealth.debug("Registering JTARuntimeMBean with Health Monitoring Service");
        }
        HealthMonitorService.register(HEALTH_JTA_SUBSYSTEM_NAME, this, true);
        if (this.isJDBCTLogEnabled()) {
            TxDebug.JTAHealth.debug("Registering JTA JDBC Store with Health Monitoring Service");
            HealthMonitorService.register(HEALTH_JTA_JDBCSTORE_SUBSYSTEM_NAME, this.getOrCreateJDBCStoreHealthState(), false);
            this.health.setJDBCStoreHealth(this.jdbcStoreHealth);
            this.isJDBCStoreHealthRegistered = true;
        }
    }

    void unregisterFromHealthService() {
        if (TxDebug.JTAHealth.isDebugEnabled()) {
            TxDebug.JTAHealth.debug("Unregistering JTARuntimeMBean from Health Monitoring Service");
        }
        HealthMonitorService.unregister(HEALTH_JTA_SUBSYSTEM_NAME);
        if (this.isJDBCStoreHealthRegistered) {
            if (TxDebug.JTAHealth.isDebugEnabled()) {
                TxDebug.JTAHealth.debug("Unregistering JTA JDBC Store from Health Monitoring Service");
            }
            HealthMonitorService.unregister(HEALTH_JTA_JDBCSTORE_SUBSYSTEM_NAME);
        }
    }

    private HealthFeedback getOrCreateJDBCStoreHealthState() {
        if (this.jdbcStoreHealthFeedback == null) {
            this.jdbcStoreHealth = new Health();
            this.jdbcStoreHealthFeedback = new HealthFeedback(){

                public HealthState getHealthState() {
                    return JTARuntimeImpl.this.jdbcStoreHealth.getState();
                }
            };
        }
        return this.jdbcStoreHealthFeedback;
    }

    public PersistentStoreRuntimeMBean getTransactionLogStoreRuntimeMBean() {
        ServerRuntimeMBean serverRuntimeMBean = (ServerRuntimeMBean)this.parent;
        String string = serverRuntimeMBean.getName();
        return this.isJDBCTLogEnabled() ? this.getJDBCPersistentStoreRuntimeMBean() : serverRuntimeMBean.lookupPersistentStoreRuntime("_WLS_" + string);
    }

    private PersistentStoreRuntimeMBean getJDBCPersistentStoreRuntimeMBean() {
        try {
            if (this.persistentStoreRuntimeMBean == null) {
                this.persistentStoreRuntimeMBean = new PersistentStoreRuntimeMBeanImpl(PlatformHelper.getPlatformHelper().getPrimaryStore());
            }
            return this.persistentStoreRuntimeMBean;
        }
        catch (ManagementException managementException) {
            managementException.printStackTrace();
            return null;
        }
    }

    private boolean isJDBCTLogEnabled() {
        TransactionLogJDBCStoreMBean transactionLogJDBCStoreMBean;
        ServerMBean serverMBean;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelID);
        if (runtimeAccess != null && (serverMBean = ManagementService.getRuntimeAccess(kernelID).getServer()) != null && (transactionLogJDBCStoreMBean = serverMBean.getTransactionLogJDBCStore()) != null) {
            return transactionLogJDBCStoreMBean.isEnabled();
        }
        return false;
    }

    private boolean checkAutomaticMigrationMode() {
        this.isAutomaticMigrationMode = ManagementService.getRuntimeAccess(kernelID) == null ? false : TransactionRecoveryService.isAutomaticMigrationMode();
        return this.isAutomaticMigrationMode;
    }

    public boolean isAutomaticMigrationMode() {
        return this.isAutomaticMigrationMode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("{");
        stringBuffer.append(super.toString());
        if (this.namedStats != null) {
            HashMap hashMap = (HashMap)this.namedStats.clone();
            for (TransactionNameRuntimeImpl transactionNameRuntimeImpl : hashMap.values()) {
                stringBuffer.append("\n");
                stringBuffer.append(transactionNameRuntimeImpl.toString());
            }
            stringBuffer.append("\n");
            stringBuffer.append(this.namedOverflow);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String getHealthStateString() {
        return HealthState.mapToString(this.health.getState().getState());
    }

    public String[] getHealthStateReasonCodes() {
        return this.health.getState().getReasonCode();
    }

    private class UnregisterNonXAResourceMBeanAction
    implements PrivilegedExceptionAction {
        private JTARuntimeImpl jtaRuntime;
        private NonXAResourceRuntimeMBean mbean;
        private ArrayList registeredNonXAResources;

        UnregisterNonXAResourceMBeanAction(JTARuntimeImpl jTARuntimeImpl2, NonXAResourceRuntimeMBean nonXAResourceRuntimeMBean, ArrayList arrayList) {
            this.jtaRuntime = jTARuntimeImpl2;
            this.mbean = nonXAResourceRuntimeMBean;
            this.registeredNonXAResources = arrayList;
        }

        public Object run() throws Exception {
            String string = this.mbean.getNonXAResourceName();
            this.registeredNonXAResources.remove(string);
            String[] stringArray = this.registeredNonXAResources.toArray(new String[this.registeredNonXAResources.size()]);
            this.registeredNonXAResources.remove(string);
            this.jtaRuntime.removeNonXAResourceRuntimeMBean(this.mbean);
            ((NonXAResourceRuntimeImpl)this.mbean).unregister();
            String[] stringArray2 = this.registeredNonXAResources.toArray(new String[this.registeredNonXAResources.size()]);
            JTARuntimeImpl.this._postSet("RegisteredNonXAResourceNames", stringArray, stringArray2);
            return null;
        }
    }

    private class CreateNonXAResourceMBeanAction
    implements PrivilegedExceptionAction {
        private JTARuntimeImpl jtaRuntime;
        private String name;
        private ArrayList registeredNonXAResources;

        CreateNonXAResourceMBeanAction(JTARuntimeImpl jTARuntimeImpl2, String string, ArrayList arrayList) {
            this.jtaRuntime = jTARuntimeImpl2;
            this.name = string;
            this.registeredNonXAResources = arrayList;
        }

        public Object run() throws Exception {
            NonXAResourceRuntimeImpl nonXAResourceRuntimeImpl = new NonXAResourceRuntimeImpl(this.name, this.jtaRuntime);
            String[] stringArray = this.registeredNonXAResources.toArray(new String[this.registeredNonXAResources.size()]);
            this.registeredNonXAResources.add(this.name);
            String[] stringArray2 = this.registeredNonXAResources.toArray(new String[this.registeredNonXAResources.size()]);
            JTARuntimeImpl.this._postSet("RegisteredNonXAResourceNames", stringArray, stringArray2);
            return nonXAResourceRuntimeImpl;
        }
    }

    private class UnregisterResourceMBeanAction
    implements PrivilegedExceptionAction {
        private JTARuntimeImpl jtaRuntime;
        private TransactionResourceRuntimeMBean mbean;
        private ArrayList registeredResources;

        UnregisterResourceMBeanAction(JTARuntimeImpl jTARuntimeImpl2, TransactionResourceRuntimeMBean transactionResourceRuntimeMBean, ArrayList arrayList) {
            this.jtaRuntime = jTARuntimeImpl2;
            this.mbean = transactionResourceRuntimeMBean;
            this.registeredResources = arrayList;
        }

        public Object run() throws Exception {
            this.jtaRuntime.removeTransactionResourceRuntimeMBean(this.mbean);
            ((TransactionResourceRuntimeImpl)this.mbean).unregister();
            String string = this.mbean.getResourceName();
            String[] stringArray = this.registeredResources.toArray(new String[this.registeredResources.size()]);
            this.registeredResources.remove(string);
            String[] stringArray2 = this.registeredResources.toArray(new String[this.registeredResources.size()]);
            JTARuntimeImpl.this._postSet("RegisteredResourceNames", stringArray, stringArray2);
            return null;
        }
    }

    private class CreateResourceMBeanAction
    implements PrivilegedExceptionAction {
        private JTARuntimeImpl jtaRuntime;
        private String name;
        private ArrayList registeredResources;

        CreateResourceMBeanAction(JTARuntimeImpl jTARuntimeImpl2, String string, ArrayList arrayList) {
            this.jtaRuntime = jTARuntimeImpl2;
            this.name = string;
            this.registeredResources = arrayList;
        }

        public Object run() throws Exception {
            TransactionResourceRuntimeImpl transactionResourceRuntimeImpl = new TransactionResourceRuntimeImpl(this.name, this.jtaRuntime);
            String[] stringArray = this.registeredResources.toArray(new String[this.registeredResources.size()]);
            this.registeredResources.add(this.name);
            String[] stringArray2 = this.registeredResources.toArray(new String[this.registeredResources.size()]);
            JTARuntimeImpl.this._postSet("RegisteredResourceNames", stringArray, stringArray2);
            return transactionResourceRuntimeImpl;
        }
    }

    private static class CreateNamedMBeanAction
    implements PrivilegedExceptionAction {
        private String name;
        private long instanceCounter;
        private JTARuntimeImpl jtaRuntime;

        CreateNamedMBeanAction(String string, long l, JTARuntimeImpl jTARuntimeImpl) {
            this.name = string;
            this.instanceCounter = l;
            this.jtaRuntime = jTARuntimeImpl;
        }

        public Object run() throws Exception {
            return new TransactionNameRuntimeImpl(this.name, this.instanceCounter, this.jtaRuntime);
        }
    }

    class Health {
        private HealthEvent tlogEvent;
        private HealthEvent txmapEvent;
        private HashMap resourceEvents = new HashMap();
        private HealthState state = new HealthState(0);
        private Health jdbcStoreHealth;

        Health() {
        }

        void setJDBCStoreHealth(Health health) {
            this.jdbcStoreHealth = health;
        }

        void healthEvent(HealthEvent healthEvent) {
            this.healthEvent(healthEvent, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void healthEvent(HealthEvent healthEvent, boolean bl) {
            if (healthEvent == null) {
                return;
            }
            Health health = this;
            synchronized (health) {
                if (!bl && ("JDBCSTORE_FAILURE".equals(healthEvent.getName()) || "JDBCSTORE_RECOVERED".equals(healthEvent.getName()))) {
                    if (this.jdbcStoreHealth != null) {
                        this.jdbcStoreHealth.healthEvent(healthEvent, true);
                    }
                    return;
                }
                switch (healthEvent.getType()) {
                    case 1: {
                        if (TxDebug.JTAHealth.isDebugEnabled()) {
                            TxDebug.JTAHealth.debug("JTA Health: health event TLOG_FAILURE");
                        }
                        this.tlogEvent = healthEvent;
                        this.updateState();
                        break;
                    }
                    case 2: {
                        if (TxDebug.JTAHealth.isDebugEnabled()) {
                            TxDebug.JTAHealth.debug("JTA Health: health event TLOG_OK");
                        }
                        if (this.tlogEvent == null) break;
                        this.tlogEvent = null;
                        this.updateState();
                        break;
                    }
                    case 3: {
                        if (TxDebug.JTAHealth.isDebugEnabled()) {
                            TxDebug.JTAHealth.debug("JTA Health: health event TXMAP_FULL");
                        }
                        if (this.txmapEvent == null) {
                            this.txmapEvent = healthEvent;
                        }
                        this.updateState();
                        break;
                    }
                    case 4: {
                        if (TxDebug.JTAHealth.isDebugEnabled()) {
                            TxDebug.JTAHealth.debug("JTA Health: health event TXMAP_OK");
                        }
                        if (this.txmapEvent == null) break;
                        this.txmapEvent = null;
                        this.updateState();
                        break;
                    }
                    case 5: {
                        if (TxDebug.JTAHealth.isDebugEnabled()) {
                            TxDebug.JTAHealth.debug("JTA Health: health event RESOURCE_UNHEALTHY (" + healthEvent.getName() + ")");
                        }
                        this.resourceEvents.put(healthEvent.getName(), healthEvent);
                        this.updateState();
                        break;
                    }
                    case 6: {
                        if (TxDebug.JTAHealth.isDebugEnabled()) {
                            TxDebug.JTAHealth.debug("JTA Health: health event RESOURCE_HEALTHY (" + healthEvent.getName() + ")");
                        }
                        if (this.resourceEvents.remove(healthEvent.getName()) == null) break;
                        this.updateState();
                        break;
                    }
                    case 7: {
                        if (TxDebug.JTAHealth.isDebugEnabled()) {
                            TxDebug.JTAHealth.debug("JTA Health: health event RESOURCE_UNREGISTERED (" + healthEvent.getName() + ")");
                        }
                        if (this.resourceEvents.remove(healthEvent.getName()) == null) break;
                        this.updateState();
                        break;
                    }
                    default: {
                        if (!TxDebug.JTAHealth.isDebugEnabled()) break;
                        TxDebug.JTAHealth.debug("JTA Health: unknown event type: " + healthEvent.getType());
                    }
                }
                if (!bl && this.state.getState() == 3 && JTARuntimeImpl.this.checkAutomaticMigrationMode()) {
                    TXExceptionLogger.logJTAFailedAndForceShutdown();
                    HealthMonitorService.subsystemFailedForceShutdown(JTARuntimeImpl.HEALTH_JTA_SUBSYSTEM_NAME, TXExceptionLogger.logJTAFailedAndForceShutdownLoggable().getMessage());
                }
            }
        }

        void updateState() {
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.tlogEvent != null && this.tlogEvent.getType() == 1) {
                n = 3;
                arrayList.add(this.tlogEvent.getDescription());
            }
            if (this.txmapEvent != null && this.txmapEvent.getType() == 3) {
                long l = System.currentTimeMillis() - this.txmapEvent.getTimestamp();
                if (l > JTARuntimeImpl.this.tm.getMaxTransactionsHealthIntervalMillis()) {
                    if (n != 3 && n != 4) {
                        n = 4;
                    }
                    arrayList.add(this.txmapEvent.getDescription() + " (" + "full for " + l + " ms which is longer than the " + "failure threshold of " + JTARuntimeImpl.this.tm.getMaxTransactionsHealthIntervalMillis() + " ms)");
                } else {
                    if (n == 0) {
                        n = 1;
                    }
                    arrayList.add(this.txmapEvent.getDescription());
                }
            }
            if (this.resourceEvents.size() > 0) {
                if (n == 0) {
                    n = 1;
                }
                for (Object object : this.resourceEvents.values()) {
                    arrayList.add(object.getDescription());
                }
            }
            HealthState healthState = this.state;
            this.state = new HealthState(n, arrayList.toArray(new String[arrayList.size()]));
            JTARuntimeImpl.this._postSet("HealthState", healthState, this.state);
            if (TxDebug.JTAHealth.isDebugEnabled()) {
                TxDebug.JTAHealth.debug("JTA Health: new state = " + this.state);
            }
            if (this.state.getState() != healthState.getState() || this.state.getReasonCode().length != healthState.getReasonCode().length) {
                Object object;
                object = new StringBuffer();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (i > 0) {
                        ((StringBuffer)object).append("; ");
                    }
                    ((StringBuffer)object).append(arrayList.get(i));
                }
                switch (this.state.getState()) {
                    case 0: {
                        TXLogger.logHealthOK((String)HealthState.mapToString(healthState.getState()), (String)HealthState.mapToString(this.state.getState()));
                        break;
                    }
                    case 1: 
                    case 4: {
                        TXLogger.logHealthWarning((String)HealthState.mapToString(healthState.getState()), (String)HealthState.mapToString(this.state.getState()), (String)((StringBuffer)object).toString());
                        break;
                    }
                    case 3: {
                        TXLogger.logHealthError((String)HealthState.mapToString(healthState.getState()), (String)HealthState.mapToString(this.state.getState()), (String)((StringBuffer)object).toString());
                    }
                }
            }
        }

        HealthState getState() {
            return this.state;
        }
    }
}

