/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.io.Serializable;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.xa.Xid;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.JTATransaction;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.internal.ServerTransactionImpl;

public final class JTATransactionImpl
implements JTATransaction,
Serializable {
    private static final long serialVersionUID = -7339816685706551825L;
    private String name;
    private Xid xid;
    private String status;
    private int statusCode;
    private Map userProperties;
    private int secondsActive;
    private String[] servers;
    private Map resourceNamesAndStatus;
    private String coordinatorURL;
    private Map serversAndStatus;
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    JTATransactionImpl(ServerTransactionImpl serverTransactionImpl) {
        this.name = serverTransactionImpl.getName();
        this.xid = serverTransactionImpl.getXID();
        this.status = serverTransactionImpl.getStatusAsString();
        this.statusCode = serverTransactionImpl.getStatus();
        this.userProperties = serverTransactionImpl.getProperties();
        this.secondsActive = (int)(serverTransactionImpl.getMillisSinceBegin() / 1000L);
        String[] stringArray = serverTransactionImpl.getSCNames();
        if (stringArray == null) {
            this.servers = new String[1];
            this.servers[0] = ManagementService.getRuntimeAccess(kernelID).getServer().getName();
        } else {
            this.servers = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.servers[i] = stringArray[i];
            }
        }
        this.resourceNamesAndStatus = serverTransactionImpl.getResourceNamesAndState();
        this.coordinatorURL = serverTransactionImpl.getCoordinatorURL();
        this.serversAndStatus = serverTransactionImpl.getServersAndState();
    }

    public String getName() {
        return this.name;
    }

    public Xid getXid() {
        return this.xid;
    }

    public String getStatus() {
        return this.status;
    }

    public Map getUserProperties() {
        return this.userProperties;
    }

    public int getSecondsActiveCurrentCount() {
        return this.secondsActive;
    }

    public String[] getServers() {
        return this.servers;
    }

    public Map getResourceNamesAndStatus() {
        return this.resourceNamesAndStatus;
    }

    public String getCoordinatorURL() {
        return this.coordinatorURL;
    }

    public Map getServersAndStatus() {
        return this.serversAndStatus;
    }

    public String toString() {
        Map.Entry entry;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(": ");
        stringBuffer.append("name=" + this.name);
        stringBuffer.append(", ");
        stringBuffer.append("xid=" + this.xid.toString());
        stringBuffer.append(", ");
        stringBuffer.append("status=" + this.status);
        stringBuffer.append(", ");
        stringBuffer.append("userProperties=");
        if (this.userProperties != null) {
            stringBuffer.append(this.userProperties.toString());
        }
        stringBuffer.append(", ");
        stringBuffer.append("secondsActive=" + this.secondsActive);
        stringBuffer.append(", ");
        stringBuffer.append("servers=");
        for (int i = 0; i < this.servers.length; ++i) {
            stringBuffer.append(this.servers[i]);
            if (i >= this.servers.length - 1) continue;
            stringBuffer.append("+");
        }
        stringBuffer.append(", ");
        stringBuffer.append("resourceNamesAndStatus=");
        Iterator iterator = this.resourceNamesAndStatus.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            stringBuffer.append((String)entry.getKey());
            stringBuffer.append("/");
            stringBuffer.append((String)entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("+");
        }
        stringBuffer.append(", ");
        stringBuffer.append("coordinatorURL=" + this.coordinatorURL);
        stringBuffer.append(", ");
        stringBuffer.append("serversAndStatus=");
        iterator = this.serversAndStatus.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            stringBuffer.append((String)entry.getKey());
            stringBuffer.append("/");
            stringBuffer.append((String)entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("+");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

