/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import weblogic.management.MBeanCreationException;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JTATransactionStatisticsRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.transaction.Transaction;
import weblogic.transaction.internal.AppSetRollbackOnlyException;
import weblogic.transaction.internal.Constants;
import weblogic.transaction.internal.JTAStatisticsImpl;
import weblogic.transaction.internal.TimedOutException;
import weblogic.transaction.internal.TransactionImpl;

public abstract class JTATransactionStatisticsImpl
extends JTAStatisticsImpl
implements Constants,
JTATransactionStatisticsRuntimeMBean {
    private static final long serialVersionUID = 7547754151703772920L;
    protected long transactionCommittedTotalCount;
    protected long transactionNoResourcesCommittedTotalCount;
    protected long transactionOneResourceOnePhaseCommittedTotalCount;
    protected long transactionReadOnlyOnePhaseCommittedTotalCount;
    protected long transactionTwoPhaseCommittedTotalCount;
    protected long transactionLLRCommittedTotalCount;
    protected long transactionRolledBackTimeoutTotalCount;
    protected long transactionRolledBackResourceTotalCount;
    protected long transactionRolledBackAppTotalCount;
    protected long transactionRolledBackSystemTotalCount;
    protected long transactionAbandonedTotalCount;
    protected long transactionHeuristicsTotalCount;
    protected long millisecondsActiveTotalCount;

    public JTATransactionStatisticsImpl(String string, RuntimeMBean runtimeMBean) throws MBeanCreationException, ManagementException {
        super(string, runtimeMBean);
    }

    void tallyRollbackReason(Throwable throwable) {
        if (throwable == null) {
            ++this.transactionRolledBackAppTotalCount;
        } else if (throwable instanceof XAException) {
            ++this.transactionRolledBackResourceTotalCount;
        } else if (throwable instanceof TimedOutException) {
            ++this.transactionRolledBackTimeoutTotalCount;
        } else if (throwable instanceof SystemException) {
            ++this.transactionRolledBackSystemTotalCount;
        } else {
            this.transactionRolledBackAppTotalCount = throwable instanceof AppSetRollbackOnlyException ? ++this.transactionRolledBackAppTotalCount : ++this.transactionRolledBackAppTotalCount;
        }
    }

    void tallyCompletion(Transaction transaction) {
        TransactionImpl transactionImpl = (TransactionImpl)transaction;
        if (transactionImpl.getHeuristicErrorMessage() != null) {
            ++this.transactionHeuristicsTotalCount;
        }
        try {
            if (transactionImpl.isAbandoned()) {
                ++this.transactionAbandonedTotalCount;
                return;
            }
            switch (transaction.getStatus()) {
                case 3: {
                    ++this.transactionCommittedTotalCount;
                    this.tallySecondsActive((Transaction)transactionImpl);
                    this.tallyCommitType(transactionImpl);
                    break;
                }
                case 4: 
                case 9: {
                    Throwable throwable = transactionImpl.getRollbackReason();
                    this.tallyRollbackReason(throwable);
                }
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    public long getTransactionTotalCount() {
        return this.getTransactionCommittedTotalCount() + this.getTransactionRolledBackTotalCount() + this.getTransactionAbandonedTotalCount();
    }

    public long getTransactionCommittedTotalCount() {
        return this.transactionCommittedTotalCount;
    }

    public long getTransactionNoResourcesCommittedTotalCount() {
        return this.transactionNoResourcesCommittedTotalCount;
    }

    public long getTransactionOneResourceOnePhaseCommittedTotalCount() {
        return this.transactionOneResourceOnePhaseCommittedTotalCount;
    }

    public long getTransactionReadOnlyOnePhaseCommittedTotalCount() {
        return this.transactionReadOnlyOnePhaseCommittedTotalCount;
    }

    public long getTransactionTwoPhaseCommittedTotalCount() {
        return this.transactionTwoPhaseCommittedTotalCount;
    }

    public long getTransactionLLRCommittedTotalCount() {
        return this.transactionLLRCommittedTotalCount;
    }

    public long getTransactionRolledBackTotalCount() {
        return this.getTransactionRolledBackAppTotalCount() + this.getTransactionRolledBackResourceTotalCount() + this.getTransactionRolledBackTimeoutTotalCount() + this.getTransactionRolledBackSystemTotalCount();
    }

    public long getTransactionRolledBackTimeoutTotalCount() {
        return this.transactionRolledBackTimeoutTotalCount;
    }

    public long getTransactionRolledBackResourceTotalCount() {
        return this.transactionRolledBackResourceTotalCount;
    }

    public long getTransactionRolledBackAppTotalCount() {
        return this.transactionRolledBackAppTotalCount;
    }

    public long getTransactionRolledBackSystemTotalCount() {
        return this.transactionRolledBackSystemTotalCount;
    }

    public long getTransactionAbandonedTotalCount() {
        return this.transactionAbandonedTotalCount;
    }

    public long getTransactionHeuristicsTotalCount() {
        return this.transactionHeuristicsTotalCount;
    }

    public long getSecondsActiveTotalCount() {
        return this.millisecondsActiveTotalCount / 1000L;
    }

    protected void tallySecondsActive(Transaction transaction) {
        try {
            if (transaction.getStatus() != 3) {
                return;
            }
        }
        catch (SystemException systemException) {
            return;
        }
        this.millisecondsActiveTotalCount += transaction.getMillisSinceBegin();
    }

    protected void tallyCommitType(TransactionImpl transactionImpl) {
        if (transactionImpl.isNoResourceInTx) {
            ++this.transactionNoResourcesCommittedTotalCount;
        } else if (transactionImpl.onePhase) {
            if (transactionImpl.isOnlyOneResourceInTx) {
                ++this.transactionOneResourceOnePhaseCommittedTotalCount;
            } else {
                ++this.transactionReadOnlyOnePhaseCommittedTotalCount;
            }
        } else if (transactionImpl.isLLR) {
            ++this.transactionLLRCommittedTotalCount;
        } else {
            ++this.transactionTwoPhaseCommittedTotalCount;
        }
    }

    public int getAverageCommitTimeSeconds() {
        if (this.transactionCommittedTotalCount == 0L) {
            return 0;
        }
        return (int)(this.millisecondsActiveTotalCount / this.transactionCommittedTotalCount);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("{");
        stringBuffer.append(super.toString());
        stringBuffer.append(",");
        stringBuffer.append("transactionRolledBackTimeoutTotalCount=").append(this.getTransactionRolledBackTimeoutTotalCount());
        stringBuffer.append(", ");
        stringBuffer.append("transactionRolledBackResourceTotalCount=").append(this.getTransactionRolledBackResourceTotalCount());
        stringBuffer.append(", ");
        stringBuffer.append("transactionRolledBackAppTotalCount=").append(this.getTransactionRolledBackAppTotalCount());
        stringBuffer.append(", ");
        stringBuffer.append("transactionRolledBackSystemTotalCount=").append(this.getTransactionRolledBackSystemTotalCount());
        stringBuffer.append(", ");
        stringBuffer.append("transactionAbandonedTotalCount=").append(this.getTransactionAbandonedTotalCount());
        stringBuffer.append(", ");
        stringBuffer.append("millisecondsActiveTotalCount=").append(this.millisecondsActiveTotalCount);
        stringBuffer.append(", ");
        stringBuffer.append("averageCommitTimeSeconds=").append(this.getAverageCommitTimeSeconds());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

