/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.security.AccessController;
import weblogic.management.MBeanCreationException;
import weblogic.management.ManagementException;
import weblogic.management.runtime.NonXAResourceRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.internal.JTARuntimeImpl;
import weblogic.transaction.internal.JTAStatisticsImpl;
import weblogic.transaction.internal.NonXAResourceRuntime;
import weblogic.transaction.internal.ServerResourceInfo;
import weblogic.transaction.nonxa.NonXAException;

public final class NonXAResourceRuntimeImpl
extends JTAStatisticsImpl
implements NonXAResourceRuntimeMBean,
NonXAResourceRuntime {
    private String nonXAResourceName;
    long transactionCommittedTotalCount;
    long transactionRolledBackTotalCount;
    long transactionHeuristicsTotalCount;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public NonXAResourceRuntimeImpl(String string, JTARuntimeImpl jTARuntimeImpl) throws MBeanCreationException, ManagementException {
        super(string, jTARuntimeImpl);
        jTARuntimeImpl.addNonXAResourceRuntimeMBean(this);
        this.nonXAResourceName = string;
    }

    public String getNonXAResourceName() {
        return this.nonXAResourceName;
    }

    public long getTransactionTotalCount() {
        return this.getTransactionCommittedTotalCount() + this.getTransactionRolledBackTotalCount();
    }

    public long getTransactionCommittedTotalCount() {
        return this.transactionCommittedTotalCount;
    }

    public long getTransactionRolledBackTotalCount() {
        return this.transactionRolledBackTotalCount;
    }

    public long getTransactionHeuristicsTotalCount() {
        return 0L;
    }

    public void tallyCompletion(ServerResourceInfo serverResourceInfo, NonXAException nonXAException) {
        if (serverResourceInfo.isCommitted()) {
            ++this.transactionCommittedTotalCount;
        } else if (serverResourceInfo.isRolledBack()) {
            ++this.transactionRolledBackTotalCount;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("NonXAResourceRuntimeMBean {");
        stringBuffer.append("nonXAResourceName=").append(this.nonXAResourceName);
        stringBuffer.append(",");
        stringBuffer.append(super.toString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

