/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterService;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JDBCDriverParamsBean;
import weblogic.jdbc.utils.BasicDataSource;
import weblogic.jndi.Environment;
import weblogic.kernel.KernelStatus;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TransactionLogJDBCStoreMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceClient;
import weblogic.management.runtime.JTATransaction;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.cluster.ThreadPreferredHost;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.store.StoreWritePolicy;
import weblogic.store.admin.FileAdminHandler;
import weblogic.store.admin.JDBCAdminHandler;
import weblogic.store.admin.RuntimeHandlerImpl;
import weblogic.store.internal.PersistentStoreImpl;
import weblogic.store.io.PersistentStoreIO;
import weblogic.store.io.file.FileStoreIO;
import weblogic.store.io.jdbc.JDBCStoreIO;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.t3.srvr.T3Srvr;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.internal.ClientInitiatedTxShutdownService;
import weblogic.transaction.internal.ClientTransactionManagerImpl;
import weblogic.transaction.internal.CoordinatorDescriptorManager;
import weblogic.transaction.internal.JTARecoveryRuntime;
import weblogic.transaction.internal.JTATransactionImpl;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.ProtocolService;
import weblogic.transaction.internal.ProtocolServiceImpl;
import weblogic.transaction.internal.ServerCoordinatorDescriptor;
import weblogic.transaction.internal.ServerCoordinatorDescriptorManager;
import weblogic.transaction.internal.ServerCoordinatorDescriptorManagerImpl;
import weblogic.transaction.internal.ServerTransactionImpl;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.StoreTransactionLoggerImpl;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TransactionHelperImpl;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TransactionManagerImpl;
import weblogic.transaction.internal.TransactionRecoveryService;
import weblogic.transaction.internal.TransactionService;
import weblogic.transaction.internal.TxDebug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformHelperImpl
extends PlatformHelper {
    private static ServerCoordinatorDescriptorManager scdm = new ServerCoordinatorDescriptorManagerImpl();
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private PersistentStore persistentStore;
    JDBCTLogServerMBeanIF m_JDBCTLogServerMBeanIF;

    Channel findAdminChannel(ServerIdentity serverIdentity) {
        ProtocolService protocolService = new ProtocolServiceImpl().getProtocolService();
        return protocolService.findServerChannel(serverIdentity, ProtocolService.PROTOCOL_ADMIN);
    }

    boolean isJNDIEnabled() {
        return true;
    }

    String getRootName() {
        return "weblogic.transaction";
    }

    Context getInitialContext(String string) throws NamingException {
        return this.getInitialContext(string, true);
    }

    Context getInitialContext(String string, boolean bl) throws NamingException {
        Environment environment = new Environment();
        if (string != null) {
            environment.setProviderUrl(string);
        }
        environment.setCreateIntermediateContexts(true);
        environment.setReplicateBindings(bl);
        environment.setInitialContextFactory("weblogic.jndi.WLInitialContextFactory");
        return environment.getInitialContext();
    }

    boolean extendCoordinatorURL(String string) {
        String string2 = PlatformHelperImpl.getProtocol(string);
        if (string2 == null) {
            string2 = "t3";
        }
        int n = ((ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager()).getInteropMode();
        return !PlatformHelperImpl.ignoreProtocol(string2, string) && n == 0 && this.isLocalAdminChannelEnabled();
    }

    private static final boolean ignoreProtocol(String string, String string2) {
        String string3 = PlatformHelperImpl.getExtendedProtocol(string2);
        return string.equalsIgnoreCase("iiop") || string.equalsIgnoreCase("tgiop") || string3 != null;
    }

    private static final SecurityConfigurationMBean getSecurityConfigurationMBean() {
        return ManagementService.getRuntimeAccess(kernelID).getDomain().getSecurityConfiguration();
    }

    boolean isCDSEnabled() {
        return PlatformHelperImpl.getSecurityConfigurationMBean().isCrossDomainSecurityEnabled();
    }

    boolean isDomainExcluded(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = PlatformHelperImpl.getSecurityConfigurationMBean().getExcludedDomainNames();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static final String getServerName(String string) {
        int n = string.indexOf(43);
        return n == -1 ? null : string.substring(0, n);
    }

    String getDomainName(String string) {
        int n = string.indexOf(43);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(43, n + 1);
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf(43, n2 + 1);
        if (n3 == -1) {
            return null;
        }
        return string.substring(n2 + 1, n3);
    }

    private static final String getProtocol(String string) {
        int n = string.indexOf(43);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(43, n + 1);
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf(43, n2 + 1);
        if (n3 == -1) {
            return null;
        }
        int n4 = string.indexOf(43, n3 + 1);
        if (n4 == -1) {
            return null;
        }
        return string.substring(n3 + 1, n4);
    }

    private static final String getExtendedProtocol(String string) {
        int n = string.indexOf(43);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(43, n + 1);
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf(43, n2 + 1);
        if (n3 == -1) {
            return null;
        }
        int n4 = string.indexOf(43, n3 + 1);
        if (n4 == -1) {
            return null;
        }
        int n5 = string.indexOf(43, n4 + 1);
        if (n5 == -1) {
            return null;
        }
        return string.substring(n4 + 1, n5);
    }

    private static final String getHostPort(String string) {
        int n = string.indexOf(43);
        int n2 = string.indexOf(43, n + 1);
        if (n2 > n) {
            return string.substring(n + 1, n2);
        }
        return string.substring(n + 1);
    }

    private static final String getHost(String string) {
        String string2 = PlatformHelperImpl.getHostPort(string);
        int n = string2.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string2.substring(0, n);
    }

    private static final String getAdminProtocol(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    String getAdminPort(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(58, n + 1);
        return string.substring(n2 + 1);
    }

    public boolean isSSLURL(String string) {
        String string2 = PlatformHelperImpl.getProtocol(string);
        return string2 != null && (string2.equalsIgnoreCase("t3s") || string2.equalsIgnoreCase("https"));
    }

    public void setPrimaryStore(PersistentStore persistentStore) {
        this.persistentStore = persistentStore;
    }

    PersistentStore getPrimaryStore() {
        if (this.persistentStore == null) {
            this.openPrimaryStore(false);
        }
        return this.persistentStore;
    }

    boolean openPrimaryStore(boolean bl) {
        TransactionManagerImpl transactionManagerImpl;
        if (bl) {
            try {
                this.closeStore(this.persistentStore);
            }
            catch (Exception exception) {
                TXLogger.logFailedSetPrimaryStoreRetry((Throwable)exception);
            }
        }
        if ((transactionManagerImpl = PlatformHelperImpl.getTM()).getJdbcTLogEnabled()) {
            JDBCTLogServerMBeanIF jDBCTLogServerMBeanIF = this.getJDBCTLogServerMBeanIF();
            try {
                this.persistentStore = this.getPrimaryStoreProvidedServerMBean(jDBCTLogServerMBeanIF.getName(), jDBCTLogServerMBeanIF, transactionManagerImpl.getJdbcTLogMaxRetrySecondsBeforeTXException());
            }
            catch (PersistentStoreException persistentStoreException) {
                TXLogger.logFailedSetPrimaryStore((Throwable)persistentStoreException);
                return false;
            }
        } else {
            this.persistentStore = PersistentStoreManager.getManager().getDefaultStore();
        }
        return this.persistentStore == null ? false : bl;
    }

    void setJDBCTLogServerMBeanIF(JDBCTLogServerMBeanIF jDBCTLogServerMBeanIF) {
        this.m_JDBCTLogServerMBeanIF = jDBCTLogServerMBeanIF;
    }

    JDBCTLogServerMBeanIF getJDBCTLogServerMBeanIF() {
        if (this.m_JDBCTLogServerMBeanIF != null) {
            return this.m_JDBCTLogServerMBeanIF;
        }
        return new JDBCTLogServerMBeanIF(){
            ServerMBean server = ManagementService.getRuntimeAccess(PlatformHelperImpl.access$000()).getServer();

            public TransactionLogJDBCStoreMBean getTransactionLogJDBCStore() {
                return this.server.getTransactionLogJDBCStore();
            }

            public String getName() {
                return this.server.getName();
            }
        };
    }

    private PersistentStore getPrimaryStoreProvidedServerMBean(String string, JDBCTLogServerMBeanIF jDBCTLogServerMBeanIF, int n) throws PersistentStoreException {
        TransactionLogJDBCStoreMBean transactionLogJDBCStoreMBean = jDBCTLogServerMBeanIF.getTransactionLogJDBCStore();
        RuntimeHandlerImpl runtimeHandlerImpl = null;
        if (this.isServer()) {
            runtimeHandlerImpl = new RuntimeHandlerImpl();
        }
        PersistentStoreXA persistentStoreXA = JDBCAdminHandler.makeStore(string + "JTA_JDBCTLOGStore", null, transactionLogJDBCStoreMBean, null, runtimeHandlerImpl);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("MaxRetrySeconds", n);
        persistentStoreXA.open(hashMap);
        return persistentStoreXA;
    }

    public PersistentStore getStore(String string, String string2) throws PersistentStoreException {
        final ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelID).getDomain().lookupServer(string);
        boolean bl = serverMBean.getTransactionLogJDBCStore().isEnabled();
        if (bl) {
            JDBCTLogServerMBeanIF jDBCTLogServerMBeanIF = new JDBCTLogServerMBeanIF(){

                public TransactionLogJDBCStoreMBean getTransactionLogJDBCStore() {
                    return serverMBean.getTransactionLogJDBCStore();
                }

                public String getName() {
                    return serverMBean.getName();
                }
            };
            return this.getPrimaryStoreProvidedServerMBean(string, jDBCTLogServerMBeanIF, serverMBean.getTransactionLogJDBCStore().getMaxRetrySecondsBeforeTXException());
        }
        FileAdminHandler fileAdminHandler = new FileAdminHandler();
        try {
            fileAdminHandler.createMigratedDefaultStore(serverMBean, false);
        }
        catch (DeploymentException deploymentException) {
            throw new PersistentStoreException((Throwable)((Object)deploymentException));
        }
        PersistentStoreXA persistentStoreXA = fileAdminHandler.getStore();
        return persistentStoreXA;
    }

    void closeStore(PersistentStore persistentStore) throws PersistentStoreException {
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        persistentStoreManager.closeFileStore(persistentStore.getName());
        try {
            persistentStore.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int getQOSAdmin() {
        return 103;
    }

    boolean isLocalAdminChannelEnabled() {
        ProtocolService protocolService = new ProtocolServiceImpl().getProtocolService();
        return protocolService.isLocalAdminChannelEnabled();
    }

    String findLocalAdminChannelURL(String string) {
        String string2 = PlatformHelperImpl.getServerName(string);
        try {
            return new ProtocolServiceImpl().getProtocolService().findAdministrationURL(string2);
        }
        catch (Exception exception) {
            TXLogger.logDowngradeAdminURL((Throwable)exception);
            return null;
        }
    }

    String findLocalSSLURL(String string) {
        String string2 = PlatformHelperImpl.getServerName(string);
        String string3 = this.getDomainName(string);
        String string4 = PlatformHelperImpl.getHost(string);
        try {
            ProtocolService protocolService = new ProtocolServiceImpl().getProtocolService();
            String string5 = protocolService.findURL(string2, protocolService.getDefaultSecureProtocol());
            if (string5 == null) {
                TXLogger.logDowngradeSSLURL((Throwable)new Exception("SSL Port can not be obtained"));
                return null;
            }
            String string6 = this.getAdminPort(string5);
            String string7 = PlatformHelperImpl.getAdminProtocol(string5);
            return string2 + "+" + string4 + ":" + string6 + "+" + string3 + "+" + string7 + "+";
        }
        catch (Exception exception) {
            TXLogger.logDowngradeSSLURL((Throwable)exception);
            return null;
        }
    }

    boolean isCheckpointLLR() {
        return false;
    }

    void dumpTLOG(String string, String string2, boolean bl) throws PersistentStoreException {
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        String string3 = "_WLS_" + string2;
        FileStoreIO fileStoreIO = new FileStoreIO(string3, string);
        PersistentStoreImpl persistentStoreImpl = new PersistentStoreImpl(string2, (PersistentStoreIO)fileStoreIO, null);
        HashMap<String, StoreWritePolicy> hashMap = new HashMap<String, StoreWritePolicy>();
        hashMap.put("SynchronousWritePolicy", StoreWritePolicy.CACHE_FLUSH);
        persistentStoreImpl.open(hashMap);
        persistentStoreManager.setDefaultStore((PersistentStore)persistentStoreImpl);
        StoreTransactionLoggerImpl storeTransactionLoggerImpl = new StoreTransactionLoggerImpl(System.out, !bl);
        if (bl) {
            long l = storeTransactionLoggerImpl.delete();
            System.out.println("Deleted " + l + " tlog entries");
        }
    }

    void dumpJDBCTLOG(String string, String string2, String string3, String string4) throws PersistentStoreException {
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        PersistentStoreImpl persistentStoreImpl = null;
        String string5 = null;
        String string6 = string + "JTA_JDBCTLOGStore";
        String string7 = string2 + "/config/config.xml";
        DomainMBean domainMBean = null;
        System.setProperty("weblogic.RootDirectory", string2);
        try {
            domainMBean = ManagementServiceClient.getClientAccess().getDomain(string7, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JDBCSystemResourceMBean jDBCSystemResourceMBean = domainMBean.lookupJDBCSystemResource(string3);
        if (jDBCSystemResourceMBean == null) {
            throw new PersistentStoreException("DataSourceName " + string3 + " NotFound");
        }
        JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
        JDBCDriverParamsBean jDBCDriverParamsBean = jDBCDataSourceBean.getJDBCDriverParams();
        string5 = jDBCDriverParamsBean.getPassword();
        BasicDataSource basicDataSource = null;
        try {
            basicDataSource = new BasicDataSource(jDBCDataSourceBean, string5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 20;
        int n2 = 20;
        int n3 = 20;
        JDBCStoreIO jDBCStoreIO = new JDBCStoreIO(string6, (DataSource)basicDataSource, string4, "", n, n2, n3);
        persistentStoreImpl = new PersistentStoreImpl(string6, (PersistentStoreIO)jDBCStoreIO, null);
        HashMap<String, StoreWritePolicy> hashMap = new HashMap<String, StoreWritePolicy>();
        persistentStoreImpl.open(hashMap);
        hashMap.put("SynchronousWritePolicy", StoreWritePolicy.CACHE_FLUSH);
        persistentStoreManager.setDefaultStore((PersistentStore)persistentStoreImpl);
        StoreTransactionLoggerImpl storeTransactionLoggerImpl = new StoreTransactionLoggerImpl(System.out, true);
    }

    boolean isTransactionServiceRunning() {
        return TransactionService.isRunning();
    }

    boolean isServerRunning() {
        return T3Srvr.getT3Srvr().getRunState() == 2;
    }

    String getDomainName() {
        return ManagementService.getRuntimeAccess(kernelID).getDomainName();
    }

    void doTimerLifecycleHousekeeping() {
        if (!this.isTransactionServiceRunning() && PlatformHelperImpl.getTM().getNumTransactions() == 0) {
            if (ClientInitiatedTxShutdownService.isSuspending()) {
                ClientInitiatedTxShutdownService.suspendDone();
            }
            if (TransactionService.isSuspending()) {
                ((ServerTransactionManagerImpl)PlatformHelperImpl.getTM()).checkpoint();
                TransactionService.suspendDone();
            }
        }
    }

    JTARecoveryRuntime getJTARecoveryRuntime(String string) {
        return TransactionRecoveryService.getRuntimeMBean(string);
    }

    void scheduleFailBack(String string) {
        TransactionRecoveryService.scheduleFailBack(string);
    }

    JTATransaction createJTATransaction(TransactionImpl transactionImpl) {
        return new JTATransactionImpl((ServerTransactionImpl)transactionImpl);
    }

    TransactionHelper getTransactionHelper() {
        return new TransactionHelperImpl();
    }

    boolean sendRequest(Object object) {
        EndPoint endPoint = (EndPoint)object;
        TransactionImpl transactionImpl = (TransactionImpl)PlatformHelperImpl.getTM().getTransaction();
        if (endPoint != null && endPoint.getHostID() instanceof ServerIdentity) {
            ServerIdentity serverIdentity = (ServerIdentity)endPoint.getHostID();
            transactionImpl.setPreferredHost((HostID)serverIdentity);
            return transactionImpl.setCoordinatorDescriptor(serverIdentity, endPoint.getRemoteChannel());
        }
        return false;
    }

    void sendRequestServer(Object object) {
    }

    private static TransactionManagerImpl getTM() {
        return TransactionManagerImpl.getTransactionManager();
    }

    public CoordinatorDescriptorManager getCoordinatorDescriptorManager() {
        return scdm;
    }

    public void associateThreadPreferredHost(TransactionImpl transactionImpl, TransactionManagerImpl.TxThreadProperty txThreadProperty) {
        if (transactionImpl != null) {
            if (!txThreadProperty.preferredHostSetForTx) {
                txThreadProperty.preTxPreferredHost = ThreadPreferredHost.get();
                txThreadProperty.preferredHostSetForTx = true;
            }
            transactionImpl.setActiveThread(Thread.currentThread());
            ThreadPreferredHost.set((HostID)transactionImpl.getPreferredHost());
        } else if (txThreadProperty.preferredHostSetForTx) {
            ThreadPreferredHost.set((HostID)txThreadProperty.preTxPreferredHost);
            txThreadProperty.preferredHostSetForTx = false;
            txThreadProperty.preTxPreferredHost = null;
        }
    }

    DisconnectMonitor getDisconnectMonitor() {
        return DisconnectMonitorListImpl.getDisconnectMonitor();
    }

    AuthenticatedSubject getRemoteSubject(String string) throws IOException, RemoteException {
        AuthenticatedSubject authenticatedSubject = null;
        authenticatedSubject = RemoteDomainSecurityHelper.getSubject(string);
        return authenticatedSubject;
    }

    final boolean isInCluster() {
        return ManagementService.getRuntimeAccess(kernelID).getServer().getCluster() != null;
    }

    Collection<String> getActiveServersInCluster() {
        if (!this.isInCluster()) {
            return null;
        }
        ClusterService clusterService = ClusterService.getClusterService();
        Collection collection = clusterService.getRemoteMembers();
        Iterator iterator = collection.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ClusterMemberInfo)) continue;
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)e;
            String string = clusterMemberInfo.serverName();
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerCoordinatorDescriptor findServerInClusterByLocalJNDI(String string, Collection collection) {
        Collection<String> collection2 = this.getActiveServersInCluster();
        if (collection2 == null) {
            return null;
        }
        collection2.removeAll(collection);
        if (collection2.isEmpty()) {
            return null;
        }
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Iterator<String> iterator = collection2.iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                String string2 = iterator.next();
                Object object = null;
                try {
                    ServerCoordinatorDescriptor serverCoordinatorDescriptor;
                    block26: {
                        try {
                            object = initialContext.lookup("weblogic.transaction.resources." + string2 + "." + string);
                            if (!TxDebug.JTA2PC.isDebugEnabled()) break block26;
                            TxDebug.txdebug((DebugLogger)TxDebug.JTA2PC, (TransactionImpl)((TransactionImpl)TransactionHelper.getTransactionHelper().getTransaction()), (String)("findResourceInCluster: check local JNDI: found XA resource " + string + " on  " + string2));
                        }
                        catch (NamingException namingException) {
                            try {
                                object = initialContext.lookup("weblogic.transaction.nonxaresources." + string2 + "." + string);
                                if (!TxDebug.JTA2PC.isDebugEnabled()) break block26;
                                TxDebug.txdebug((DebugLogger)TxDebug.JTA2PC, (TransactionImpl)((TransactionImpl)TransactionHelper.getTransactionHelper().getTransaction()), (String)("findResourceInCluster: check local JNDI: found non-XA resource " + string + " on  " + string2));
                            }
                            catch (NamingException namingException2) {
                                continue;
                            }
                        }
                    }
                    ClientTransactionManagerImpl clientTransactionManagerImpl = (ClientTransactionManagerImpl)initialContext.lookup("weblogic.transaction.coordinators." + string2);
                    String string3 = clientTransactionManagerImpl.getCoordinatorURL();
                    ServerCoordinatorDescriptor serverCoordinatorDescriptor2 = serverCoordinatorDescriptor = ((ServerCoordinatorDescriptorManager)this.getCoordinatorDescriptorManager()).getOrCreate(string3);
                    return serverCoordinatorDescriptor2;
                }
                catch (Exception exception) {
                    try {
                        continue;
                    }
                    catch (NamingException namingException) {
                        string2 = null;
                        return string2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                break;
            }
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.txdebug((DebugLogger)TxDebug.JTA2PC, (TransactionImpl)((TransactionImpl)TransactionHelper.getTransactionHelper().getTransaction()), (String)("findResourceInCluster: check local JNDI: cannot find resource " + string + " on any server in cluster"));
        }
        return null;
    }

    boolean isServer() {
        return KernelStatus.isServer();
    }

    void registerRMITransactionInterceptor(Interceptor interceptor) {
        InterceptorManager.getManager().setTransactionInterceptor(interceptor);
    }

    int getInteropMode() {
        return ((ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager()).getInteropMode();
    }

    public ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public AuthenticatedSubject getCurrentSubject() {
        return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)this.getKernelID());
    }

    private AuthenticatedSubject getKernelID() {
        return kernelID;
    }

    static /* synthetic */ AuthenticatedSubject access$000() {
        return kernelID;
    }

    public static interface JDBCTLogServerMBeanIF {
        public TransactionLogJDBCStoreMBean getTransactionLogJDBCStore();

        public String getName();
    }
}

