/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.TXExceptionLogger;
import weblogic.transaction.internal.TransactionManagerImpl;

public final class PostLoggingResourceService
extends AbstractServerService {
    private static int state = 0;

    public void stop() throws ServiceFailureException {
        state = 4;
    }

    public void halt() throws ServiceFailureException {
        state = 3;
    }

    public void start() throws ServiceFailureException {
        ServerTransactionManagerImpl serverTransactionManagerImpl = (ServerTransactionManagerImpl)TransactionManagerImpl.getTransactionManager();
        Throwable throwable = serverTransactionManagerImpl.getLLRBootException();
        if (throwable != null) {
            ServiceFailureException serviceFailureException = new ServiceFailureException(TXExceptionLogger.logFailedLLRRecoverLoggable((String)throwable.toString()).getMessage());
            serviceFailureException.initCause(serverTransactionManagerImpl.getLLRBootException());
            throw serviceFailureException;
        }
        Throwable throwable2 = serverTransactionManagerImpl.getPrimaryStoreBootException();
        if (throwable2 != null) {
            ServiceFailureException serviceFailureException = new ServiceFailureException(TXExceptionLogger.logFailedPrimaryStoreRecoverLoggable((String)throwable2.toString()).getMessage());
            serviceFailureException.initCause(serverTransactionManagerImpl.getPrimaryStoreBootException());
            throw serviceFailureException;
        }
        state = 2;
    }

    static boolean isSuspending() {
        return state == 4;
    }

    static void suspendDone() {
        if (state == 4) {
            state = 3;
        }
    }
}

