/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.TxDebug;

final class ReceiveSecureAction {
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    ReceiveSecureAction() {
    }

    static final boolean stranger(HostID hostID, String string) {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelID);
        int n = RemoteDomainSecurityHelper.acceptRemoteDomainCall(hostID, authenticatedSubject);
        if (n == 1) {
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("SecureAction.stranger  Subject used on received call: " + SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject) + " for action :" + string + " AUTHENTICATION FAILED ");
            }
            return true;
        }
        if (n == 0) {
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("SecureAction.stranger  Subject used on received call: " + SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject) + " for action: " + string + " AUTHENTICATION SUCCESSFUL ");
            }
            return false;
        }
        if (n == 2) {
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("SecureAction.stranger  Subject used on received call: " + SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject) + " for action: " + string + " AUTHENTICATION UNDETERMINABLE " + " use SecurityInteropMode");
            }
            int n2 = ((ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager()).getInteropMode();
            if (authenticatedSubject != null && !SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject)) {
                if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
                    return false;
                }
                if (n2 == 2) {
                    return SecurityServiceManager.isTrustedServerIdentity((AuthenticatedSubject)authenticatedSubject);
                }
                PeerInfo peerInfo = null;
                try {
                    EndPoint endPoint = ServerHelper.getClientEndPoint();
                    if (endPoint != null && endPoint instanceof PeerInfoable) {
                        peerInfo = ((PeerInfoable)endPoint).getPeerInfo();
                    }
                }
                catch (ServerNotActiveException serverNotActiveException) {
                    return true;
                }
                if (peerInfo == null) {
                    return true;
                }
                if (peerInfo.getMajor() == 6 && "system".equals(SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject))) {
                    return false;
                }
            } else {
                return n2 != 1 && kernelID.getQOS() == 103;
            }
        }
        return true;
    }
}

