/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.Remote;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.TransactionLoggable;
import weblogic.transaction.TransactionLogger;
import weblogic.transaction.internal.CoordinatorDescriptor;
import weblogic.transaction.internal.CoordinatorImpl;
import weblogic.transaction.internal.JNDIAdvertiser;
import weblogic.transaction.internal.NonXAResourceDescriptor;
import weblogic.transaction.internal.NotificationBroadcaster;
import weblogic.transaction.internal.NotificationListener;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.ProtocolServiceImpl;
import weblogic.transaction.internal.ResourceDescriptor;
import weblogic.transaction.internal.SecureAction;
import weblogic.transaction.internal.ServerCheckpoint;
import weblogic.transaction.internal.ServerCoordinatorDescriptor;
import weblogic.transaction.internal.ServerCoordinatorDescriptorManager;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.SubCoordinator3;
import weblogic.transaction.internal.SubCoordinatorInfo;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TxDebug;
import weblogic.transaction.internal.XAResourceDescriptor;
import weblogic.utils.collections.ArraySet;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public class ServerCoordinatorDescriptorManagerImpl
implements ServerCoordinatorDescriptorManager {
    private static final int SERVER_REFRESH_INTERVAL_MILLIS = 5000;
    private static final CacheLock cacheLock = new CacheLock();
    private static final HashMap xaResourceToServers = new HashMap();
    private static final HashMap nonXAResourceToServers = new HashMap();
    private static final HashMap activeServers = new HashMap();
    private static final HashMap lostServers = new HashMap();
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private int purgeFromCheckpointIntervalSeconds;
    private boolean serverCheckpointNeeded = false;
    private ServerCheckpoint latestServerCheckpoint = null;

    public ServerCoordinatorDescriptor getLocalCoordinatorDescriptor() {
        return SCDMaker.SELF;
    }

    public void setLocalCoordinatorDescriptor(CoordinatorDescriptor coordinatorDescriptor) {
    }

    public String getLocalCoordinatorURL() {
        if (this.getLocalCoordinatorDescriptor() == null) {
            return null;
        }
        return this.getLocalCoordinatorDescriptor().getCoordinatorURL();
    }

    public ServerCoordinatorDescriptor getOrCreate(String string) {
        if (string == null) {
            return null;
        }
        return this.getOrCreate(string, null);
    }

    public ServerCoordinatorDescriptor getOrCreateForMigration(String string) {
        try {
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelID).getDomain().lookupServer(string);
            String string2 = ServerCoordinatorDescriptorManagerImpl.getCoordinatorURL(serverMBean);
            return this.getOrCreate(string2);
        }
        catch (Exception exception) {
            if (TxDebug.JTAMigration.isDebugEnabled()) {
                TxDebug.JTAMigration.debug("ServerCoordinatorDescriptor.getOrCreateForMigration(server=" + string + ") failed", (Throwable)exception);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllCheckpointServers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        CacheLock cacheLock = ServerCoordinatorDescriptorManagerImpl.cacheLock;
        synchronized (cacheLock) {
            ServerCoordinatorDescriptor serverCoordinatorDescriptor;
            Object object;
            Collection collection = activeServers.values();
            if (collection != null) {
                object = collection.iterator();
                while (object.hasNext()) {
                    serverCoordinatorDescriptor = (ServerCoordinatorDescriptor)object.next();
                    if (!serverCoordinatorDescriptor.includeInCheckpoint()) continue;
                    arrayList.add(serverCoordinatorDescriptor.getCoordinatorURL());
                }
            }
            if ((object = lostServers.values()) != null) {
                serverCoordinatorDescriptor = object.iterator();
                while (serverCoordinatorDescriptor.hasNext()) {
                    ServerCoordinatorDescriptor serverCoordinatorDescriptor2 = (ServerCoordinatorDescriptor)serverCoordinatorDescriptor.next();
                    if (!serverCoordinatorDescriptor2.includeInCheckpoint()) continue;
                    arrayList.add(serverCoordinatorDescriptor2.getCoordinatorURL());
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLatestServerCheckpoint(TransactionLogger transactionLogger, ServerCheckpoint serverCheckpoint) {
        ServerCheckpoint serverCheckpoint2;
        long l = ServerCoordinatorDescriptorManagerImpl.getTM().getRuntime().getTransactionTotalCount();
        CacheLock cacheLock = ServerCoordinatorDescriptorManagerImpl.cacheLock;
        synchronized (cacheLock) {
            serverCheckpoint2 = this.latestServerCheckpoint;
            this.latestServerCheckpoint = serverCheckpoint;
        }
        if (serverCheckpoint2 != null) {
            transactionLogger.release((TransactionLoggable)serverCheckpoint2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointIfNecessary() {
        CacheLock cacheLock = ServerCoordinatorDescriptorManagerImpl.cacheLock;
        synchronized (cacheLock) {
            if (!this.serverCheckpointNeeded) {
                return;
            }
            this.serverCheckpointNeeded = false;
        }
        this.checkpointServers();
    }

    public ServerCoordinatorDescriptor[] getServers(String string) {
        ServerCoordinatorDescriptor[] serverCoordinatorDescriptorArray = ServerCoordinatorDescriptorManagerImpl.getServersHostingXAResource(string);
        if (serverCoordinatorDescriptorArray != null) {
            return serverCoordinatorDescriptorArray;
        }
        serverCoordinatorDescriptorArray = ServerCoordinatorDescriptorManagerImpl.getServersHostingNonXAResource(string);
        if (serverCoordinatorDescriptorArray != null) {
            return serverCoordinatorDescriptorArray;
        }
        return null;
    }

    public void checkpointServers() {
        ServerCheckpoint serverCheckpoint = new ServerCheckpoint();
        serverCheckpoint.blockingStore(ServerCoordinatorDescriptorManagerImpl.getTM().getTransactionLogger());
    }

    public void setServerCheckpointNeeded(boolean bl) {
        this.serverCheckpointNeeded = bl;
    }

    public void setPurgeFromCheckpointIntervalSeconds(int n) {
        this.purgeFromCheckpointIntervalSeconds = n;
        if (TxDebug.JTARecovery.isDebugEnabled()) {
            TxDebug.JTARecovery.debug("ServerCoordinatorDescriptor.setPurgeFromCheckpointIntervalSecs:" + n);
        }
    }

    public int getPurgeFromCheckpointIntervalSeconds() {
        return this.purgeFromCheckpointIntervalSeconds;
    }

    public void updateXAResources(String string, String[] stringArray) {
        ServerCoordinatorDescriptor serverCoordinatorDescriptor = this.getOrCreate(string);
        if (serverCoordinatorDescriptor != null) {
            ServerCoordinatorDescriptorManagerImpl.updateSCDXAResources(serverCoordinatorDescriptor, ServerCoordinatorDescriptorManagerImpl.nameArray2XAResourceDescriptorSet(stringArray));
        }
    }

    public void updateNonXAResources(String string, String[] stringArray) {
        ServerCoordinatorDescriptor serverCoordinatorDescriptor = this.getOrCreate(string);
        if (serverCoordinatorDescriptor != null) {
            ServerCoordinatorDescriptorManagerImpl.updateSCDNonXAResources(serverCoordinatorDescriptor, ServerCoordinatorDescriptorManagerImpl.nameArray2NonXAResourceDescriptorSet(stringArray));
        }
    }

    private static void updateSCDXAResources(ServerCoordinatorDescriptor serverCoordinatorDescriptor, Set set) {
        Set set2 = serverCoordinatorDescriptor.getXAResources();
        serverCoordinatorDescriptor.updateXAResources(set);
        ServerCoordinatorDescriptorManagerImpl.updateCache(set2, set, serverCoordinatorDescriptor);
    }

    private static void updateSCDNonXAResources(ServerCoordinatorDescriptor serverCoordinatorDescriptor, Set set) {
        Set set2 = serverCoordinatorDescriptor.getNonXAResources();
        serverCoordinatorDescriptor.updateNonXAResources(set);
        ServerCoordinatorDescriptorManagerImpl.updateCache(set2, set, serverCoordinatorDescriptor);
    }

    private static final void updateCache(Set set, Set set2, ServerCoordinatorDescriptor serverCoordinatorDescriptor) {
        Object object;
        Object object2;
        Object object32;
        Set set3 = ServerCoordinatorDescriptorManagerImpl.complementOfXInY(set, set2);
        for (Object object32 : set3) {
            object32.addSC((CoordinatorDescriptor)serverCoordinatorDescriptor);
            object2 = object32.getName();
            if (object32 instanceof XAResourceDescriptor) {
                object = (Set)xaResourceToServers.get(object2);
                if (object == null) {
                    object = new ArraySet();
                    xaResourceToServers.put(object2, object);
                }
                object.add(serverCoordinatorDescriptor);
                if (!TxDebug.JTANaming.isDebugEnabled()) continue;
                TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.updateCache() XA resource " + (String)object2 + " now registered with " + serverCoordinatorDescriptor);
                continue;
            }
            object = (Set)nonXAResourceToServers.get(object2);
            if (object == null) {
                object = new ArraySet();
                nonXAResourceToServers.put(object2, object);
            }
            object.add(serverCoordinatorDescriptor);
            if (!TxDebug.JTANaming.isDebugEnabled()) continue;
            TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.updateCache() non-XA resource " + (String)object2 + " now registered with " + serverCoordinatorDescriptor);
        }
        object32 = ServerCoordinatorDescriptorManagerImpl.complementOfXInY(set2, set);
        object2 = object32.iterator();
        while (object2.hasNext()) {
            Set set4;
            object = (ResourceDescriptor)object2.next();
            object.removeSC((CoordinatorDescriptor)serverCoordinatorDescriptor);
            String string = object.getName();
            if (object instanceof XAResourceDescriptor) {
                set4 = (Set)xaResourceToServers.get(string);
                if (set4 == null) continue;
                set4.remove(serverCoordinatorDescriptor);
                if (set4.size() != 0 || !TxDebug.JTANaming.isDebugEnabled()) continue;
                TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.updateCache() XA resource " + string + " no longer registered with " + serverCoordinatorDescriptor);
                continue;
            }
            set4 = (Set)nonXAResourceToServers.get(string);
            if (set4 == null) continue;
            set4.remove(serverCoordinatorDescriptor);
            if (set4.size() != 0 || !TxDebug.JTANaming.isDebugEnabled()) continue;
            TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.updateCache() non-XA resource " + string + " no longer registered with " + serverCoordinatorDescriptor);
        }
    }

    private static final Set complementOfXInY(Set set, Set set2) {
        ArraySet arraySet = new ArraySet();
        if (set2 == null) {
            return arraySet;
        }
        if (set == null) {
            return set2;
        }
        for (Object e : set2) {
            if (set.contains(e)) continue;
            arraySet.add(e);
        }
        return arraySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ServerCoordinatorDescriptor getOrCreate(String string, ServerMBean serverMBean) {
        if (string == null) {
            return null;
        }
        String string2 = CoordinatorDescriptor.getServerID((String)string);
        if (string2 == null) {
            return null;
        }
        if (this.isLocalServer(string2)) {
            return this.getLocalCoordinatorDescriptor();
        }
        CacheLock cacheLock = ServerCoordinatorDescriptorManagerImpl.cacheLock;
        synchronized (cacheLock) {
            if (!this.isKnownServer(string2)) {
                if (TxDebug.JTANaming.isDebugEnabled()) {
                    TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.getOrCreate(" + string + ")");
                }
                if (TxDebug.JTANamingStackTrace.isDebugEnabled()) {
                    TxDebug.debugStack((DebugLogger)TxDebug.JTANaming, (String)("ServerCoordinatorDescriptor.getOrCreate(" + string + ")"));
                }
                ServerCoordinatorDescriptor serverCoordinatorDescriptor = new ServerCoordinatorDescriptor(string);
                CacheLock cacheLock2 = ServerCoordinatorDescriptorManagerImpl.cacheLock;
                synchronized (cacheLock2) {
                    lostServers.put(string2, serverCoordinatorDescriptor);
                }
                this.scheduleRefresh(serverCoordinatorDescriptor);
                return serverCoordinatorDescriptor;
            }
            ServerCoordinatorDescriptor serverCoordinatorDescriptor = (ServerCoordinatorDescriptor)activeServers.get(string2);
            if (serverCoordinatorDescriptor != null) {
                return serverCoordinatorDescriptor;
            }
            serverCoordinatorDescriptor = (ServerCoordinatorDescriptor)lostServers.get(string2);
            if (serverCoordinatorDescriptor != null) {
                this.scheduleRefresh(serverCoordinatorDescriptor);
                return serverCoordinatorDescriptor;
            }
        }
        if (TxDebug.JTANaming.isDebugEnabled()) {
            TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.getOrCreate(): known server but not active or lost");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isKnownServer(String string) {
        CacheLock cacheLock = ServerCoordinatorDescriptorManagerImpl.cacheLock;
        synchronized (cacheLock) {
            if (activeServers.get(string) != null) {
                return true;
            }
            if (lostServers.get(string) != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ServerCoordinatorDescriptor[] getServersHostingXAResource(String string) {
        CacheLock cacheLock = ServerCoordinatorDescriptorManagerImpl.cacheLock;
        synchronized (cacheLock) {
            Set set = (Set)xaResourceToServers.get(string);
            if (set == null || set.size() == 0) {
                return null;
            }
            return set.toArray(new ServerCoordinatorDescriptor[set.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerCoordinatorDescriptor[] getServersHostingNonXAResource(String string) {
        CacheLock cacheLock = ServerCoordinatorDescriptorManagerImpl.cacheLock;
        synchronized (cacheLock) {
            Set set = (Set)nonXAResourceToServers.get(string);
            if (set == null || set.size() == 0) {
                return null;
            }
            return set.toArray(new ServerCoordinatorDescriptor[set.size()]);
        }
    }

    private static final String getHost(ServerMBean serverMBean) throws Exception {
        String string = serverMBean.getListenAddress();
        if (string == null || string.equalsIgnoreCase("localhost") || string.equals("127.0.0.1")) {
            throw new Exception("Unable to get runtime listen address.Server " + serverMBean.getName() + " configured with localhost");
        }
        return string;
    }

    private static String getCoordinatorURL(String string, String string2) throws URISyntaxException {
        Object object;
        String string3 = null;
        try {
            object = new ProtocolServiceImpl().getProtocolService();
            string3 = ((ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager()).getInteropMode() == 1 || PlatformHelper.getPlatformHelper().isCDSEnabled() ? object.findURL(string2, object.getDefaultProtocol()) : object.findAdministrationURL(string2);
            if (string3 == null) {
                string3 = object.findURL(string2, object.getDefaultSecureProtocol());
            }
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        object = new URI(string3);
        String string4 = ((URI)object).getScheme();
        int n = ((URI)object).getPort();
        String string5 = ((URI)object).getHost();
        return CoordinatorDescriptor.getCoordinatorURL((String)(string5 + ":" + n), (String)string, (String)string2, (String)string4);
    }

    private static String getCoordinatorURL(ServerMBean serverMBean) throws Exception {
        String string;
        int n;
        String string2;
        Object object;
        if (serverMBean == null) {
            return null;
        }
        String string3 = serverMBean.getName();
        if (string3 == null) {
            throw new Exception("Unable to obtain the server name");
        }
        try {
            object = new ProtocolServiceImpl().getProtocolService();
            String string4 = ((ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager()).getInteropMode() == 1 || PlatformHelper.getPlatformHelper().isCDSEnabled() ? object.findURL(string3, object.getDefaultProtocol()) : object.findAdministrationURL(string3);
            if (string4 == null) {
                string4 = object.findURL(string3, object.getDefaultSecureProtocol());
            }
            URI uRI = new URI(string4);
            string2 = uRI.getScheme();
            n = uRI.getPort();
            string = uRI.getHost();
        }
        catch (UnknownHostException unknownHostException) {
            string = ServerCoordinatorDescriptorManagerImpl.getHost(serverMBean);
            if (serverMBean.isListenPortEnabled()) {
                n = serverMBean.getListenPort();
                string2 = serverMBean.getDefaultProtocol();
            }
            SSLMBean sSLMBean = serverMBean.getSSL();
            if (sSLMBean == null) {
                throw new Exception("Unable to obtain the SSL listen port of the server: no sslMBean");
            }
            if (!sSLMBean.isEnabled()) {
                throw new Exception("SSL listen port is not configured on the server");
            }
            n = sSLMBean.getListenPort();
            string2 = serverMBean.getDefaultSecureProtocol();
        }
        object = ManagementService.getRuntimeAccess(kernelID).getDomainName();
        if (TxDebug.JTANaming.isDebugEnabled()) {
            TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.getCoordinatorURL() " + string + ":" + n + "+" + (String)object + "+" + string3 + "+" + string2);
        }
        return CoordinatorDescriptor.getCoordinatorURL((String)(string + ":" + n), (String)object, (String)string3, (String)string2);
    }

    private final boolean isLocalServer(String string) {
        String string2;
        try {
            string2 = this.getLocalCoordinatorURL();
        }
        catch (Exception exception) {
            return false;
        }
        String string3 = CoordinatorDescriptor.getServerID((String)string2);
        return string3 != null && string3.equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleRefresh(ServerCoordinatorDescriptor serverCoordinatorDescriptor) {
        if (TxDebug.JTANaming.isDebugEnabled()) {
            TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.scheduleRefresh(" + serverCoordinatorDescriptor.getCoordinatorURL() + ")");
        }
        ServerCoordinatorDescriptorManagerImpl serverCoordinatorDescriptorManagerImpl = this;
        synchronized (serverCoordinatorDescriptorManagerImpl) {
            if (serverCoordinatorDescriptor.isRefreshScheduled() || serverCoordinatorDescriptor.isRefreshInProgress()) {
                if (TxDebug.JTANaming.isDebugEnabled()) {
                    TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.scheduleRefresh(" + serverCoordinatorDescriptor.getCoordinatorURL() + "): lookup in progress");
                }
                return;
            }
            long l = System.currentTimeMillis() - serverCoordinatorDescriptor.getLastRefreshTime();
            if (l < 5000L) {
                if (TxDebug.JTANaming.isDebugEnabled()) {
                    TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.scheduleRefresh(): timeSinceLastRefresh = " + l + " is less than server refresh interval of " + 5000);
                }
                return;
            }
            serverCoordinatorDescriptor.setRefreshScheduled(true);
        }
        serverCoordinatorDescriptorManagerImpl = serverCoordinatorDescriptor;
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new WorkAdapter((ServerCoordinatorDescriptor)serverCoordinatorDescriptorManagerImpl){
            final /* synthetic */ ServerCoordinatorDescriptor val$fcd;
            {
                this.val$fcd = serverCoordinatorDescriptor;
            }

            public void run() {
                try {
                    String string = this.val$fcd.getCoordinatorURL();
                    SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new RefreshServerAction(this.val$fcd), (String)ServerCoordinatorDescriptor.getServerURL((String)string), (String)"refreshServer");
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    private static final Set nameArray2XAResourceDescriptorSet(Object[] objectArray) {
        ArraySet arraySet = new ArraySet();
        for (int i = 0; i < objectArray.length; ++i) {
            arraySet.add((Object)XAResourceDescriptor.getOrCreate((String)((String)objectArray[i])));
        }
        return arraySet;
    }

    private static final Set nameArray2NonXAResourceDescriptorSet(Object[] objectArray) {
        ArraySet arraySet = new ArraySet();
        for (int i = 0; i < objectArray.length; ++i) {
            arraySet.add((Object)NonXAResourceDescriptor.getOrCreate((String)((String)objectArray[i])));
        }
        return arraySet;
    }

    private final boolean inLocalDomain(CoordinatorDescriptor coordinatorDescriptor) {
        return ServerCoordinatorDescriptorManagerImpl.getLocalDomain().equals(coordinatorDescriptor.getDomainName());
    }

    private static final String getLocalDomain() {
        return ManagementService.getRuntimeAccess(kernelID).getDomain().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void lostServer(String string) {
        block6: {
            try {
                CacheLock cacheLock = ServerCoordinatorDescriptorManagerImpl.cacheLock;
                synchronized (cacheLock) {
                    ServerCoordinatorDescriptor serverCoordinatorDescriptor = (ServerCoordinatorDescriptor)activeServers.remove(string);
                    if (serverCoordinatorDescriptor == null) {
                        return;
                    }
                    lostServers.put(string, serverCoordinatorDescriptor);
                    ServerCoordinatorDescriptorManagerImpl.updateSCDXAResources(serverCoordinatorDescriptor, (Set)new ArraySet());
                    ServerCoordinatorDescriptorManagerImpl.updateSCDNonXAResources(serverCoordinatorDescriptor, (Set)new ArraySet());
                }
            }
            catch (Exception exception) {
                if (!TxDebug.JTANaming.isDebugEnabled()) break block6;
                TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.lostServer() ", (Throwable)exception);
            }
        }
    }

    private static final ServerTransactionManagerImpl getTM() {
        return (ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerCoordinatorDescriptor[] getActiveServers() {
        CacheLock cacheLock = ServerCoordinatorDescriptorManagerImpl.cacheLock;
        synchronized (cacheLock) {
            return activeServers.values().toArray(new ServerCoordinatorDescriptor[activeServers.size()]);
        }
    }

    private class GetSubCoordinatorInfoAction
    implements PrivilegedExceptionAction {
        private String coUrl;
        private Map infoMap;
        private SubCoordinator3 sc;

        GetSubCoordinatorInfoAction(SubCoordinator3 subCoordinator3, String string) {
            this.sc = subCoordinator3;
            this.infoMap = null;
            this.coUrl = string;
        }

        public Object run() throws Exception {
            this.infoMap = this.sc.getSubCoordinatorInfo(this.coUrl);
            return null;
        }

        public Map getMap() {
            return this.infoMap;
        }
    }

    private final class RefreshServerAction
    implements PrivilegedExceptionAction {
        private final ServerCoordinatorDescriptor coordinatorDescriptor;

        RefreshServerAction(ServerCoordinatorDescriptor serverCoordinatorDescriptor) {
            this.coordinatorDescriptor = serverCoordinatorDescriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws Exception {
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.refreshServer(" + this.coordinatorDescriptor.getCoordinatorURL() + ")");
            }
            TransactionImpl transactionImpl = null;
            RefreshServerAction refreshServerAction = this;
            synchronized (refreshServerAction) {
                if (this.coordinatorDescriptor.isRefreshInProgress()) {
                    if (TxDebug.JTANaming.isDebugEnabled()) {
                        TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.refreshServer(" + this.coordinatorDescriptor.getCoordinatorURL() + ") refresh in progress");
                    }
                    return null;
                }
                this.coordinatorDescriptor.setRefreshInProgress(true);
            }
            try {
                try {
                    transactionImpl = ServerCoordinatorDescriptorManagerImpl.getTM().internalSuspend();
                    refreshServerAction = this.getSubCoordinator3();
                    if (refreshServerAction != null) {
                        this.doPeerExchange((SubCoordinator3)refreshServerAction);
                        Object var4_6 = null;
                        return var4_6;
                    }
                }
                finally {
                    ServerCoordinatorDescriptorManagerImpl.getTM().internalResume(transactionImpl);
                }
            }
            catch (Exception exception) {
                if (TxDebug.JTANaming.isDebugEnabled()) {
                    TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.refreshServer(" + this.coordinatorDescriptor.getCoordinatorURL() + ") Exception: ", (Throwable)exception);
                }
            }
            finally {
                RefreshServerAction refreshServerAction2 = this;
                synchronized (refreshServerAction2) {
                    this.coordinatorDescriptor.setRefreshInProgress(false);
                    this.coordinatorDescriptor.setRefreshScheduled(false);
                    this.coordinatorDescriptor.setLastRefreshTime(System.currentTimeMillis());
                    this.notifyAll();
                }
                if (TxDebug.JTANaming.isDebugEnabled()) {
                    TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.refreshServer(" + this.coordinatorDescriptor.getCoordinatorURL() + ") completed lookup");
                }
            }
            return null;
        }

        private SubCoordinator3 getSubCoordinator3() {
            Object object = JNDIAdvertiser.getCachedCoordinator((CoordinatorDescriptor)this.coordinatorDescriptor, null);
            if (object == null && ServerCoordinatorDescriptorManagerImpl.this.inLocalDomain((CoordinatorDescriptor)this.coordinatorDescriptor)) {
                String string;
                try {
                    string = ServerCoordinatorDescriptorManagerImpl.getCoordinatorURL(this.coordinatorDescriptor.getDomainName(), this.coordinatorDescriptor.getServerName());
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (TxDebug.JTANaming.isDebugEnabled()) {
                        TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.getSubCoordinator3() Invalid URI: " + uRISyntaxException);
                    }
                    return null;
                }
                if (string == null) {
                    if (TxDebug.JTANaming.isDebugEnabled()) {
                        TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.getSubCoordinator3() no URL found for " + this.coordinatorDescriptor.getServerID());
                    }
                    return null;
                }
                if (!CoordinatorDescriptor.getServerURL((String)string).equals(this.coordinatorDescriptor.serverURL)) {
                    if (TxDebug.JTANaming.isDebugEnabled()) {
                        TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.getSubCoordinator3() server " + this.coordinatorDescriptor.getServerID() + " has moved to " + string);
                    }
                    this.coordinatorDescriptor.init(string);
                }
            }
            if ((object = JNDIAdvertiser.getCachedCoordinator((CoordinatorDescriptor)this.coordinatorDescriptor, null)) != null && object instanceof SubCoordinator3 && object instanceof NotificationBroadcaster) {
                return (SubCoordinator3)object;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPeerExchange(SubCoordinator3 subCoordinator3) throws Exception {
            Object object;
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.doPeerExchange()");
            }
            String string = ServerCoordinatorDescriptorManagerImpl.this.getLocalCoordinatorURL();
            String string2 = this.coordinatorDescriptor.getCoordinatorURL();
            String string3 = ServerCoordinatorDescriptor.getServerURL((String)string2);
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.doPeerExchange()serverURL= " + string3);
            }
            GetSubCoordinatorInfoAction getSubCoordinatorInfoAction = new GetSubCoordinatorInfoAction(subCoordinator3, string);
            SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)getSubCoordinatorInfoAction, (String)string3, (String)"sc3.getSubCoordinatorInfo");
            Map map = getSubCoordinatorInfoAction.getMap();
            if (map == null) {
                if (TxDebug.JTANaming.isDebugEnabled()) {
                    TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.doPeerExchange()  peer info null");
                }
                return;
            }
            SubCoordinatorInfo subCoordinatorInfo = new SubCoordinatorInfo(map);
            this.coordinatorDescriptor.init(subCoordinatorInfo.getCoordinatorURL());
            this.coordinatorDescriptor.setSSLOnly(subCoordinatorInfo.isSslOnly());
            NotificationBroadcaster notificationBroadcaster = (NotificationBroadcaster)subCoordinator3;
            notificationBroadcaster.addNotificationListener((NotificationListener)((CoordinatorImpl)ServerCoordinatorDescriptorManagerImpl.getTM().getLocalCoordinator()), (Object)this.coordinatorDescriptor.getCoordinatorURL());
            if (subCoordinator3 instanceof Remote) {
                object = DisconnectMonitorListImpl.getDisconnectMonitor();
                try {
                    object.addDisconnectListener((Remote)subCoordinator3, (DisconnectListener)new SubCoordinatorDisconnectListener(this.coordinatorDescriptor.getCoordinatorURL(), this.coordinatorDescriptor.getServerID()));
                }
                catch (DisconnectMonitorUnavailableException disconnectMonitorUnavailableException) {
                    // empty catch block
                }
            }
            object = cacheLock;
            synchronized (object) {
                ServerCoordinatorDescriptorManagerImpl.updateSCDXAResources(this.coordinatorDescriptor, ServerCoordinatorDescriptorManagerImpl.nameArray2XAResourceDescriptorSet(subCoordinatorInfo.getRegisteredXAResources()));
                ServerCoordinatorDescriptorManagerImpl.updateSCDNonXAResources(this.coordinatorDescriptor, ServerCoordinatorDescriptorManagerImpl.nameArray2NonXAResourceDescriptorSet(subCoordinatorInfo.getRegisteredNonXAResources()));
                activeServers.put(this.coordinatorDescriptor.getServerID(), this.coordinatorDescriptor);
                lostServers.remove(this.coordinatorDescriptor.getServerID());
            }
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.process90Exchange() completed lookup for " + this.coordinatorDescriptor.getCoordinatorURL());
            }
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.doPeerExchange() initialized");
            }
        }

        class SubCoordinatorDisconnectListener
        implements DisconnectListener {
            String url;
            String id;

            SubCoordinatorDisconnectListener(String string, String string2) {
                this.url = string;
                this.id = string2;
            }

            public void onDisconnect(DisconnectEvent disconnectEvent) {
                if (TxDebug.JTANaming.isDebugEnabled()) {
                    TxDebug.JTANaming.debug("ServerCoordinatorDescriptor.RefreshServerAction.DisconnectListenerImpl.onDisconnect(" + this.url + ")");
                }
                ServerCoordinatorDescriptorManagerImpl.lostServer(this.id);
            }
        }
    }

    private static final class SCDMaker {
        private static ServerCoordinatorDescriptor SELF;

        private SCDMaker() {
        }

        static {
            try {
                if (Kernel.isServer()) {
                    String string = ServerCoordinatorDescriptorManagerImpl.getCoordinatorURL(ManagementService.getRuntimeAccess(kernelID).getServer());
                    if (TxDebug.JTANaming.isDebugEnabled()) {
                        TxDebug.JTANaming.debug("ServerCoordinatorDescriptor(): local server " + string);
                    }
                    if (PlatformHelper.getPlatformHelper().extendCoordinatorURL(string) && !PlatformHelper.getPlatformHelper().isCDSEnabled()) {
                        SELF = new ServerCoordinatorDescriptor(string, CoordinatorDescriptor.getPort((String)string));
                    } else {
                        if (((ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager()).getInteropMode() != 2) {
                            ((ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager()).setInteropModeToVal(1);
                        }
                        SELF = new ServerCoordinatorDescriptor(string);
                    }
                }
            }
            catch (Exception exception) {
                TXLogger.logLocalCoordinatorDescriptorError((Throwable)exception);
            }
        }
    }

    private static final class CacheLock {
        private CacheLock() {
        }
    }
}

