/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.transaction.TransactionSystemException;
import weblogic.transaction.internal.AbortRequestedException;
import weblogic.transaction.internal.Constants;
import weblogic.transaction.internal.CoordinatorDescriptor;
import weblogic.transaction.internal.CoordinatorOneway;
import weblogic.transaction.internal.CoordinatorOneway2;
import weblogic.transaction.internal.JNDIAdvertiser;
import weblogic.transaction.internal.ListenerNotFoundException;
import weblogic.transaction.internal.NonXAServerResourceInfo;
import weblogic.transaction.internal.Notification;
import weblogic.transaction.internal.NotificationBroadcaster;
import weblogic.transaction.internal.NotificationBroadcasterImpl;
import weblogic.transaction.internal.NotificationListener;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.PropagationContext;
import weblogic.transaction.internal.PropertyChangeNotification;
import weblogic.transaction.internal.ReceiveSecureAction;
import weblogic.transaction.internal.ResourceDescriptor;
import weblogic.transaction.internal.ResourceInfo;
import weblogic.transaction.internal.SecureAction;
import weblogic.transaction.internal.ServerCoordinatorDescriptor;
import weblogic.transaction.internal.ServerCoordinatorDescriptorManager;
import weblogic.transaction.internal.ServerResourceInfo;
import weblogic.transaction.internal.ServerSCInfo;
import weblogic.transaction.internal.ServerTransactionImpl;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.SubCoordinator;
import weblogic.transaction.internal.SubCoordinator3;
import weblogic.transaction.internal.SubCoordinatorInfo;
import weblogic.transaction.internal.SubCoordinatorOneway3;
import weblogic.transaction.internal.SubCoordinatorOneway4;
import weblogic.transaction.internal.SubCoordinatorOneway5;
import weblogic.transaction.internal.SubCoordinatorOneway6;
import weblogic.transaction.internal.SubCoordinatorRM;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TxDebug;
import weblogic.transaction.internal.XAResourceDescriptor;
import weblogic.transaction.nonxa.NonXAException;

public class SubCoordinatorImpl
implements SubCoordinator3,
SubCoordinatorOneway3,
Constants,
NotificationBroadcaster,
NotificationListener,
SubCoordinatorRM,
SubCoordinatorOneway4,
SubCoordinatorOneway5,
SubCoordinatorOneway6 {
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private NotificationBroadcasterImpl notificationBroadcaster = new NotificationBroadcasterImpl((SubCoordinator)this);
    private static final boolean INSTR_ENABLED;
    private Map commitUsernameStats;
    private Map rollbackUsernameStats;

    public SubCoordinatorImpl() {
        if (INSTR_ENABLED) {
            this.commitUsernameStats = new HashMap();
            this.rollbackUsernameStats = new HashMap();
        }
    }

    public void startPrePrepareAndChain(PropagationContext propagationContext, int n) {
        block15: {
            ServerTransactionImpl serverTransactionImpl;
            boolean bl = false;
            try {
                serverTransactionImpl = (ServerTransactionImpl)propagationContext.getTransaction();
            }
            catch (TransactionSystemException transactionSystemException) {
                return;
            }
            CoordinatorOneway coordinatorOneway = null;
            try {
                if (serverTransactionImpl == null) {
                    return;
                }
                coordinatorOneway = this.getCoordinator(serverTransactionImpl.getCoordinatorDescriptor(), (TransactionImpl)serverTransactionImpl);
                if (coordinatorOneway == null) {
                    return;
                }
                serverTransactionImpl.localPrePrepareAndChain();
                if (serverTransactionImpl.allSCsPrePrepared()) {
                    bl = true;
                }
            }
            catch (AbortRequestedException abortRequestedException) {
                bl = true;
            }
            if (bl) {
                try {
                    if (serverTransactionImpl.isCancelled()) {
                        serverTransactionImpl.globalRollback();
                        break block15;
                    }
                    if (coordinatorOneway == null) break block15;
                    if (serverTransactionImpl.isCoordinatingTransaction()) {
                        serverTransactionImpl.ackPrePrepare();
                        break block15;
                    }
                    try {
                        CoordinatorDescriptor coordinatorDescriptor = serverTransactionImpl.getCoordinatorDescriptor();
                        String string = coordinatorDescriptor.getCoordinatorURL();
                        SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new AckPrePrepareAction(coordinatorOneway, serverTransactionImpl.getRequestPropagationContext()), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co.ackPrePrepare");
                    }
                    catch (Exception exception) {
                        if (TxDebug.JTA2PC.isDebugEnabled()) {
                            TxDebug.JTA2PC.debug("ackPrePrepare FAILED", (Throwable)exception);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!TxDebug.JTA2PC.isDebugEnabled()) break block15;
                    TxDebug.JTA2PC.debug("startPrePrepareAndChain FAILED", (Throwable)exception);
                }
            }
        }
    }

    public void startPrepare(Xid xid, String string, String[] stringArray, int n) {
        this.startPrepare(xid, string, stringArray, n, null);
    }

    public void startPrepare(Xid xid, String string, String[] stringArray, int n, Map map) {
        block20: {
            int n2 = 0;
            ServerTransactionImpl serverTransactionImpl = null;
            CoordinatorOneway coordinatorOneway = null;
            try {
                serverTransactionImpl = this.getTM().getOrCreateTransaction(xid, n, n);
                serverTransactionImpl.setCoordinatorURL(string);
                coordinatorOneway = this.getCoordinator(serverTransactionImpl.getCoordinatorDescriptor(), (TransactionImpl)serverTransactionImpl);
                if (coordinatorOneway == null) {
                    throw new SystemException("Could not obtain coordinator at " + string);
                }
                if (map != null) {
                    if (TxDebug.JTA2PC.isDebugEnabled()) {
                        TxDebug.JTA2PC.debug("startPrepare: Add properties: " + map);
                    }
                    serverTransactionImpl.addProperties(map);
                }
                if (INSTR_ENABLED) {
                    serverTransactionImpl.check("SCBeforePrepare", this.getTM().getLocalCoordinatorDescriptor().getServerName());
                }
                serverTransactionImpl.localPrepare(stringArray);
                if (INSTR_ENABLED) {
                    serverTransactionImpl.check("SCAfterPrepare", this.getTM().getLocalCoordinatorDescriptor().getServerName());
                }
            }
            catch (SystemException systemException) {
                if (TxDebug.JTA2PC.isDebugEnabled()) {
                    TxDebug.JTA2PC.debug("startPrepare FAILED", (Throwable)systemException);
                }
                return;
            }
            try {
                if (coordinatorOneway != null) {
                    if (serverTransactionImpl.isCancelled()) {
                        try {
                            CoordinatorDescriptor coordinatorDescriptor = serverTransactionImpl.getCoordinatorDescriptor();
                            SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new StartRollbackAction(coordinatorOneway, serverTransactionImpl.getRequestPropagationContext()), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co.startRollback");
                        }
                        catch (Exception exception) {
                            if (TxDebug.JTA2PC.isDebugEnabled()) {
                                TxDebug.JTA2PC.debug("startRollback FAILED", (Throwable)exception);
                            }
                        }
                    } else if (serverTransactionImpl.isPrepared()) {
                        try {
                            CoordinatorDescriptor coordinatorDescriptor = serverTransactionImpl.getCoordinatorDescriptor();
                            SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new AckPrepareAction(coordinatorOneway, xid, this.getScUrl(), n2), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co.ackPrepare");
                        }
                        catch (Exception exception) {
                            if (TxDebug.JTA2PC.isDebugEnabled()) {
                                TxDebug.JTA2PC.debug("ackPrepare FAILED", (Throwable)exception);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!TxDebug.JTA2PC.isDebugEnabled()) break block20;
                TxDebug.JTA2PC.debug("startPrepare FAILED", (Throwable)exception);
            }
        }
    }

    public final void startCommit(Xid xid, String string, String[] stringArray, boolean bl, boolean bl2) {
        this.startCommit(xid, string, stringArray, bl, bl2, null);
    }

    public final void startCommit(Xid xid, String string, String[] stringArray, boolean bl, boolean bl2, AuthenticatedUser authenticatedUser) {
        this.startCommit(xid, string, stringArray, bl, bl2, authenticatedUser, null);
    }

    public final void startCommit(Xid xid, String string, String[] stringArray, boolean bl, boolean bl2, AuthenticatedUser authenticatedUser, Map map) {
        block36: {
            StringBuffer stringBuffer;
            if (INSTR_ENABLED && !bl2) {
                this.incrementUsernameStats(this.commitUsernameStats);
            }
            AuthenticatedSubject authenticatedSubject = null;
            authenticatedSubject = authenticatedUser == null ? SubjectUtils.getAnonymousSubject() : SecurityServiceManager.getASFromWire((AuthenticatedSubject)((AuthenticatedSubject)authenticatedUser));
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                stringBuffer = new StringBuffer(50);
                int n = stringArray == null ? 0 : stringArray.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(" " + stringArray[i]);
                }
                TxDebug.JTA2PC.debug("startCommit: " + xid + " for coordinator=" + string + " resources=" + stringBuffer);
            }
            stringBuffer = null;
            try {
                EndPoint endPoint = ServerHelper.getClientEndPoint();
                if (endPoint != null && endPoint instanceof PeerInfoable) {
                    stringBuffer = ((PeerInfoable)endPoint).getPeerInfo();
                }
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            if (stringBuffer != null && stringBuffer.isServer()) {
                if (ReceiveSecureAction.stranger(this.getHostID(), "startCommit")) {
                    TXLogger.logUserNotAuthorizedForStartCommit((String)this.getUserName());
                    return;
                }
            } else {
                TXLogger.logUserNotAuthorizedForStartCommit((String)this.getUserName());
                return;
            }
            if (TxDebug.JTA2PC.isDebugEnabled()) {
                TxDebug.JTA2PC.debug("startCommit: About to do start.commit");
            }
            int n = this.getTM().getDefaultTimeoutSeconds();
            ServerTransactionImpl serverTransactionImpl = null;
            try {
                CoordinatorOneway coordinatorOneway = null;
                CoordinatorOneway2 coordinatorOneway2 = null;
                try {
                    short s;
                    serverTransactionImpl = this.getTM().getOrCreateTransaction(xid, n, n);
                    coordinatorOneway = this.getCoordinator(ServerCoordinatorDescriptor.getOrCreate((String)string), (TransactionImpl)serverTransactionImpl);
                    if (coordinatorOneway == null) {
                        throw new SystemException("Could not obtain coordinator at " + string);
                    }
                    if (coordinatorOneway instanceof CoordinatorOneway2) {
                        coordinatorOneway2 = (CoordinatorOneway2)coordinatorOneway;
                    }
                    if (map != null) {
                        if (TxDebug.JTA2PC.isDebugEnabled()) {
                            TxDebug.JTA2PC.debug("startCommit: Add properties: " + map);
                        }
                        serverTransactionImpl.addProperties(map);
                    }
                    if (INSTR_ENABLED && !bl2) {
                        serverTransactionImpl.check("SCBeforeCommit", this.getTM().getLocalCoordinatorDescriptor().getServerName());
                    }
                    if (!serverTransactionImpl.localCommit(stringArray, bl, bl2, authenticatedSubject)) {
                        if (TxDebug.JTA2PC.isDebugEnabled()) {
                            TxDebug.JTA2PC.debug("startCommit: local commit failed, not responding");
                        }
                        if (INSTR_ENABLED && !bl2) {
                            serverTransactionImpl.check("SCAfterCommit", this.getTM().getLocalCoordinatorDescriptor().getServerName());
                        }
                        return;
                    }
                    if (INSTR_ENABLED && !bl2) {
                        serverTransactionImpl.check("SCAfterCommit", this.getTM().getLocalCoordinatorDescriptor().getServerName());
                    }
                    if ((s = serverTransactionImpl.getHeuristicStatus(4)) == 0) {
                        if (coordinatorOneway2 != null) {
                            try {
                                CoordinatorDescriptor coordinatorDescriptor = serverTransactionImpl.getCoordinatorDescriptor();
                                SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new AckCommitAction(null, coordinatorOneway2, xid, this.getScUrl(), serverTransactionImpl.getCommittedResources()), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co2.ackCommit");
                            }
                            catch (Exception exception) {}
                        } else if (coordinatorOneway != null) {
                            try {
                                CoordinatorDescriptor coordinatorDescriptor = serverTransactionImpl.getCoordinatorDescriptor();
                                SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new AckCommitAction(coordinatorOneway, null, xid, this.getScUrl(), null), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co.ackCommit");
                            }
                            catch (Exception exception) {}
                        }
                        break block36;
                    }
                    TXLogger.logHeuristicCompletion((String)serverTransactionImpl.toString(), (String)serverTransactionImpl.getHeuristicErrorMessage());
                    if (coordinatorOneway2 != null) {
                        try {
                            CoordinatorDescriptor coordinatorDescriptor = serverTransactionImpl.getCoordinatorDescriptor();
                            SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new NakCommitAction(null, coordinatorOneway2, xid, this.getScUrl(), s, serverTransactionImpl.getHeuristicErrorMessage(), serverTransactionImpl.getCommittedResources(), serverTransactionImpl.getRolledbackResources()), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co2.nakCommit");
                        }
                        catch (Exception exception) {}
                        break block36;
                    }
                    if (coordinatorOneway == null) break block36;
                    try {
                        CoordinatorDescriptor coordinatorDescriptor = serverTransactionImpl.getCoordinatorDescriptor();
                        SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new NakCommitAction(coordinatorOneway, null, xid, this.getScUrl(), s, serverTransactionImpl.getHeuristicErrorMessage(), null, null), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co.nakCommit");
                    }
                    catch (Exception exception) {
                    }
                }
                catch (SystemException systemException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void startRollback(Xid xid, String string, String[] stringArray) {
        this.startRollback(xid, string, stringArray, null);
    }

    public void startRollback(Xid xid, String string, String[] stringArray, AuthenticatedUser authenticatedUser) {
        this.startRollback(xid, string, stringArray, authenticatedUser, null);
    }

    public void startRollback(Xid xid, String string, String[] stringArray, AuthenticatedUser authenticatedUser, String[] stringArray2) {
        this.startRollback(xid, string, stringArray, authenticatedUser, stringArray2, null);
    }

    public void startRollback(Xid xid, String string, String[] stringArray, AuthenticatedUser authenticatedUser, String[] stringArray2, Map map) {
        this.startRollback(xid, string, stringArray, authenticatedUser, stringArray2, map, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startRollback(Xid xid, String string, String[] stringArray, AuthenticatedUser authenticatedUser, String[] stringArray2, Map map, boolean bl) {
        StringBuffer stringBuffer;
        boolean bl2;
        boolean bl3 = bl2 = this.getTM().getTransaction(xid) == null;
        if (INSTR_ENABLED && !bl) {
            this.incrementUsernameStats(this.rollbackUsernameStats);
        }
        AuthenticatedSubject authenticatedSubject = null;
        authenticatedSubject = authenticatedUser == null ? SubjectUtils.getAnonymousSubject() : SecurityServiceManager.getASFromWire((AuthenticatedSubject)((AuthenticatedSubject)authenticatedUser));
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            stringBuffer = new StringBuffer(50);
            int n = stringArray == null ? 0 : stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(stringArray[i]);
            }
            TxDebug.JTA2PC.debug("startRollback: " + xid + " for coordinator=" + string + " resources=" + stringBuffer);
        }
        stringBuffer = null;
        try {
            EndPoint endPoint = ServerHelper.getClientEndPoint();
            if (endPoint != null && endPoint instanceof PeerInfoable) {
                stringBuffer = ((PeerInfoable)endPoint).getPeerInfo();
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        if (stringBuffer != null && stringBuffer.isServer()) {
            if (ReceiveSecureAction.stranger(this.getHostID(), "startRollback")) {
                TXLogger.logUserNotAuthorizedForStartRollback((String)this.getUserName());
                return;
            }
        } else {
            TXLogger.logUserNotAuthorizedForStartRollback((String)this.getUserName());
            return;
        }
        try {
            int n = this.getTM().getDefaultTimeoutSeconds();
            CoordinatorOneway coordinatorOneway = null;
            CoordinatorOneway2 coordinatorOneway2 = null;
            ServerTransactionImpl serverTransactionImpl = this.getTM().getOrCreateTransaction(xid, n, n);
            try {
                short s;
                ArrayList arrayList;
                Object object;
                coordinatorOneway = this.getCoordinator(ServerCoordinatorDescriptor.getOrCreate((String)string), (TransactionImpl)serverTransactionImpl);
                if (coordinatorOneway == null) {
                    throw new SystemException("Could not obtain coordinator at " + string);
                }
                if (coordinatorOneway instanceof CoordinatorOneway2) {
                    coordinatorOneway2 = (CoordinatorOneway2)coordinatorOneway;
                }
                if (stringArray2 != null && stringArray2.length > 0) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    object = new TreeSet<String>();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        ((TreeSet)object).add(stringArray2[i]);
                    }
                    arrayList = serverTransactionImpl.getResourceInfoList();
                    if (arrayList != null) {
                        arrayList = (ArrayList)arrayList.clone();
                        for (ResourceInfo resourceInfo : arrayList) {
                            if (((TreeSet)object).contains(resourceInfo.getName())) continue;
                            arrayList2.add(resourceInfo.getName());
                        }
                    }
                    if (arrayList2.size() > 0) {
                        if (stringArray != null && stringArray.length > 0) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                arrayList2.add(stringArray[i]);
                            }
                        }
                        stringArray = arrayList2.toArray(new String[arrayList2.size()]);
                    }
                }
                if (map != null) {
                    if (TxDebug.JTA2PC.isDebugEnabled()) {
                        TxDebug.JTA2PC.debug("startRollback: Add properties: " + map);
                    }
                    serverTransactionImpl.addProperties(map);
                }
                if (INSTR_ENABLED && !bl) {
                    serverTransactionImpl.check("SCBeforeRollback", this.getTM().getLocalCoordinatorDescriptor().getServerName());
                }
                if (!serverTransactionImpl.localRollback(stringArray, authenticatedSubject)) {
                    if (TxDebug.JTA2PC.isDebugEnabled()) {
                        TxDebug.JTA2PC.debug("startRollback: local rollback failed, not responding");
                    }
                    if (!INSTR_ENABLED) return;
                    if (bl) return;
                    serverTransactionImpl.check("SCAfterRollback", this.getTM().getLocalCoordinatorDescriptor().getServerName());
                    return;
                }
                if (INSTR_ENABLED && !bl) {
                    serverTransactionImpl.check("SCAfterRollback", this.getTM().getLocalCoordinatorDescriptor().getServerName());
                }
                if ((s = serverTransactionImpl.getHeuristicStatus(8)) == 0) {
                    if (coordinatorOneway2 != null) {
                        try {
                            object = serverTransactionImpl.getCoordinatorDescriptor();
                            SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new AckRollbackAction(null, coordinatorOneway2, xid, this.getScUrl(), serverTransactionImpl.getRolledbackResources()), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co2.ackRollback");
                            return;
                        }
                        catch (Exception exception) {
                            if (!TxDebug.JTA2PC.isDebugEnabled()) return;
                            TxDebug.JTA2PC.debug("ackRollback remote exception: " + exception);
                            return;
                        }
                    }
                    if (coordinatorOneway == null) return;
                    try {
                        object = serverTransactionImpl.getCoordinatorDescriptor();
                        SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new AckRollbackAction(coordinatorOneway, null, xid, this.getScUrl(), null), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co.ackRollback");
                        return;
                    }
                    catch (Exception exception) {
                        if (!TxDebug.JTA2PC.isDebugEnabled()) return;
                        TxDebug.JTA2PC.debug("ackRollback remote exception: " + exception);
                        return;
                    }
                }
                object = serverTransactionImpl.getHeuristicErrorMessage();
                TXLogger.logHeuristicCompletion((String)serverTransactionImpl.toString(), (String)object);
                if (coordinatorOneway2 != null) {
                    try {
                        arrayList = serverTransactionImpl.getCoordinatorDescriptor();
                        SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new NakRollbackAction(null, coordinatorOneway2, xid, this.getScUrl(), s, serverTransactionImpl.getHeuristicErrorMessage(), serverTransactionImpl.getCommittedResources(), serverTransactionImpl.getRolledbackResources()), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co2.nakRollback");
                        return;
                    }
                    catch (Exception exception) {
                        if (!TxDebug.JTA2PC.isDebugEnabled()) return;
                        TxDebug.JTA2PC.debug("nakRollback remote exception: " + exception);
                        return;
                    }
                }
                if (coordinatorOneway != null) {
                    try {
                        arrayList = serverTransactionImpl.getCoordinatorDescriptor();
                        SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new NakRollbackAction(coordinatorOneway, null, xid, this.getScUrl(), s, serverTransactionImpl.getHeuristicErrorMessage(), null, null), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co.nakRollback");
                        return;
                    }
                    catch (Exception exception) {
                        if (!TxDebug.JTA2PC.isDebugEnabled()) return;
                        TxDebug.JTA2PC.debug("nakRollback remote exception: " + exception);
                        return;
                    }
                }
                if (coordinatorOneway == null) return;
                return;
            }
            catch (SystemException systemException) {
                if (coordinatorOneway == null) return;
                try {
                    CoordinatorDescriptor coordinatorDescriptor = serverTransactionImpl.getCoordinatorDescriptor();
                    SecureAction.runAction((AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new NakRollbackAction(coordinatorOneway, null, xid, this.getScUrl(), 2, systemException.toString(), null, null), (String)CoordinatorDescriptor.getServerURL((String)string), (String)"co.nakRollback");
                    return;
                }
                catch (Exception exception) {
                    if (!TxDebug.JTA2PC.isDebugEnabled()) return;
                    TxDebug.JTA2PC.debug("nakRollback remote exception: " + exception);
                    return;
                }
            }
        }
        catch (Exception exception) {
            if (!TxDebug.JTA2PC.isDebugEnabled()) return;
            TxDebug.JTA2PC.debug("startRollback remote exception: " + exception);
        }
    }

    public void startRollback(Xid[] xidArray) throws RemoteException {
        int n;
        int n2 = n = xidArray == null ? 0 : xidArray.length;
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug("SC.startRollback: " + n + " XIDs");
        }
        if (ReceiveSecureAction.stranger(this.getHostID(), "sc.startRollback")) {
            TXLogger.logUserNotAuthorizedForRollback((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = null;
        for (int i = 0; i < xidArray.length; ++i) {
            serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xidArray[i]);
            if (serverTransactionImpl == null) continue;
            serverTransactionImpl.localRollback();
        }
    }

    public Xid[] recover(String string, String string2) throws SystemException {
        if (ReceiveSecureAction.stranger(this.getHostID(), "recover")) {
            TXLogger.logUserNotAuthorizedForRecover((String)this.getUserName());
            return null;
        }
        try {
            ServerSCInfo serverSCInfo = new ServerSCInfo(this.getScUrl());
            return serverSCInfo.recover(string, ServerCoordinatorDescriptor.getOrCreate((String)string2), null);
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (Exception exception) {
            throw new SystemException("Subcoordinator raised exception on recover: " + exception);
        }
    }

    public void rollback(String string, Xid[] xidArray) throws SystemException, RemoteException {
        EndPoint endPoint;
        PeerInfo peerInfo = null;
        try {
            endPoint = ServerHelper.getClientEndPoint();
            if (endPoint != null && endPoint instanceof PeerInfoable) {
                peerInfo = ((PeerInfoable)endPoint).getPeerInfo();
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        if (peerInfo != null && peerInfo.isServer() && ReceiveSecureAction.stranger(this.getHostID(), "rollback recovery")) {
            TXLogger.logUserNotAuthorizedForRollback((String)this.getUserName());
            return;
        }
        endPoint = new ServerSCInfo(this.getScUrl());
        endPoint.rollback(string, xidArray);
    }

    public void nonXAResourceCommit(Xid xid, boolean bl, String string) throws SystemException, RemoteException {
        PeerInfo peerInfo = null;
        try {
            EndPoint endPoint = ServerHelper.getClientEndPoint();
            if (endPoint != null && endPoint instanceof PeerInfoable) {
                peerInfo = ((PeerInfoable)endPoint).getPeerInfo();
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        if (peerInfo != null && peerInfo.isServer()) {
            if (ReceiveSecureAction.stranger(this.getHostID(), "nonXAResourceCommit")) {
                TXLogger.logUserNotAuthorizedForNonXACommit((String)this.getUserName());
                throw new SystemException("Failed to commit non XA resource");
            }
        } else {
            TXLogger.logUserNotAuthorizedForNonXACommit((String)this.getUserName());
            throw new SystemException("Failed to commit non XA resource");
        }
        int n = this.getTM().getDefaultTimeoutSeconds();
        ServerTransactionImpl serverTransactionImpl = null;
        serverTransactionImpl = this.getTM().getOrCreateTransaction(xid, n, n);
        ServerResourceInfo serverResourceInfo = (ServerResourceInfo)serverTransactionImpl.getResourceInfo(string);
        if (serverResourceInfo instanceof NonXAServerResourceInfo) {
            try {
                ((NonXAServerResourceInfo)serverResourceInfo).commit(serverTransactionImpl, bl, false, true);
            }
            catch (NonXAException nonXAException) {
                if (TxDebug.JTANonXA.isDebugEnabled()) {
                    TxDebug.JTANonXA.debug("SC.nonXAResourceCommit: " + xid + ", failed", (Throwable)nonXAException);
                }
                throw new RemoteException("NonXAResource commit failed: " + (Object)((Object)nonXAException));
            }
        } else {
            throw new SystemException("Attempt to perform a non-XA resource commit on a resource that is not a NonXAResource");
        }
    }

    public void forceLocalRollback(Xid xid) throws SystemException, RemoteException {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug("SC.forceLocalRollback: " + xid);
        }
        if (ReceiveSecureAction.stranger(this.getHostID(), "forceLocalRollback")) {
            TXLogger.logUserNotAuthorizedForForceLocalRollback((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (serverTransactionImpl == null) {
            TXLogger.logForceLocalRollbackNoTx((String)xid.toString());
            return;
        }
        serverTransactionImpl.forceLocalRollback();
    }

    public void forceLocalCommit(Xid xid) throws SystemException, RemoteException {
        if (TxDebug.JTA2PC.isDebugEnabled()) {
            TxDebug.JTA2PC.debug("SC.forceLocalCommit: " + xid);
        }
        if (ReceiveSecureAction.stranger(this.getHostID(), "forceLocalCommit")) {
            TXLogger.logUserNotAuthorizedForForceLocalCommit((String)this.getUserName());
            return;
        }
        ServerTransactionImpl serverTransactionImpl = (ServerTransactionImpl)this.getTM().getTransaction(xid);
        if (serverTransactionImpl == null) {
            TXLogger.logForceLocalCommitNoTx((String)xid.toString());
            return;
        }
        serverTransactionImpl.forceLocalCommit();
    }

    public Map getProperties(String string) {
        if (ReceiveSecureAction.stranger(this.getHostID(), "getPoperties")) {
            TXLogger.logUserNotAuthorizedForGetProperties((String)this.getUserName());
            return null;
        }
        ResourceDescriptor resourceDescriptor = XAResourceDescriptor.get((String)string);
        if (resourceDescriptor == null) {
            return null;
        }
        return resourceDescriptor.getProperties();
    }

    protected ServerTransactionManagerImpl getTM() {
        return (ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager();
    }

    protected HostID getHostID() {
        try {
            EndPoint endPoint = ServerHelper.getClientEndPoint();
            HostID hostID = endPoint.getHostID();
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("RMI call coming from = " + ((ServerIdentity)hostID).getDomainName());
            }
            return hostID;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private CoordinatorOneway getCoordinator(CoordinatorDescriptor coordinatorDescriptor, TransactionImpl transactionImpl) {
        return JNDIAdvertiser.getCoordinator((CoordinatorDescriptor)coordinatorDescriptor, (TransactionImpl)transactionImpl);
    }

    private String getScUrl() {
        return this.getTM().getLocalCoordinatorURL();
    }

    public void addNotificationListener(NotificationListener notificationListener, Object object) throws IllegalArgumentException {
        this.notificationBroadcaster.addNotificationListener(notificationListener, object);
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.notificationBroadcaster.removeNotificationListener(notificationListener);
    }

    public void handleNotification(Notification notification, Object object) {
        if (TxDebug.JTANaming.isDebugEnabled()) {
            TxDebug.JTANaming.debug("SubCoordinatorImpl.handleNotification(" + object + ")");
        }
        if (ReceiveSecureAction.stranger(this.getHostID(), "handleNotification")) {
            TXLogger.logUserNotAuthorizedForStartCommit((String)this.getUserName());
            return;
        }
        if (notification instanceof PropertyChangeNotification) {
            PropertyChangeNotification propertyChangeNotification = (PropertyChangeNotification)notification;
            if (TxDebug.JTANaming.isDebugEnabled()) {
                TxDebug.JTANaming.debug("SubCoordinatorImpl.handleNotification(notificaiton=" + notification + ", handback=" + object + ")");
            }
            if ("XAResources".equals(propertyChangeNotification.getName())) {
                ((ServerCoordinatorDescriptorManager)PlatformHelper.getPlatformHelper().getCoordinatorDescriptorManager()).updateXAResources((String)object, (String[])propertyChangeNotification.getNewValue());
            } else if ("NonXAResources".equals(propertyChangeNotification.getName())) {
                ((ServerCoordinatorDescriptorManager)PlatformHelper.getPlatformHelper().getCoordinatorDescriptorManager()).updateNonXAResources((String)object, (String[])propertyChangeNotification.getNewValue());
            }
        }
    }

    public Map getSubCoordinatorInfo(String string) throws RemoteException {
        if (TxDebug.JTANaming.isDebugEnabled()) {
            TxDebug.JTANaming.debug("SubCoordinatorImpl.getSubCoordinatorInfo(" + string + ")");
        }
        if (ReceiveSecureAction.stranger(this.getHostID(), "getSubCoordinatorInfo")) {
            TXLogger.logUserNotAuthorizedForGetSubCoordinatorInfo((String)this.getUserName());
            return null;
        }
        CoordinatorDescriptor coordinatorDescriptor = ServerCoordinatorDescriptor.getOrCreate((String)string);
        ServerCoordinatorDescriptor serverCoordinatorDescriptor = ((ServerCoordinatorDescriptorManager)PlatformHelper.getPlatformHelper().getCoordinatorDescriptorManager()).getLocalCoordinatorDescriptor();
        if (serverCoordinatorDescriptor != null) {
            return SubCoordinatorInfo.createMap((ServerCoordinatorDescriptor)serverCoordinatorDescriptor);
        }
        return null;
    }

    public void broadcastXAResourceRegistrationChange(String[] stringArray, String[] stringArray2) {
        this.notificationBroadcaster.broadcastXAResourceRegistrationChange(stringArray, stringArray2);
    }

    public void broadcastNonXAResourceRegistrationChange(String[] stringArray, String[] stringArray2) {
        this.notificationBroadcaster.broadcastNonXAResourceRegistrationChange(stringArray, stringArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCommitUsernameStat(String string) {
        if (this.commitUsernameStats == null) {
            return -1L;
        }
        Map map = this.commitUsernameStats;
        synchronized (map) {
            Long l = (Long)this.commitUsernameStats.get(string);
            if (l == null) {
                return 0L;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getCommitUsernameStats() {
        if (this.commitUsernameStats == null) {
            return null;
        }
        Map map = this.commitUsernameStats;
        synchronized (map) {
            return (Map)((HashMap)this.commitUsernameStats).clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getRollbackUsernameStat(String string) {
        if (this.rollbackUsernameStats == null) {
            return -1L;
        }
        Map map = this.rollbackUsernameStats;
        synchronized (map) {
            Long l = (Long)this.rollbackUsernameStats.get(string);
            if (l == null) {
                return 0L;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getRollbackUsernameStats() {
        if (this.rollbackUsernameStats == null) {
            return null;
        }
        Map map = this.rollbackUsernameStats;
        synchronized (map) {
            return (Map)((HashMap)this.rollbackUsernameStats).clone();
        }
    }

    private String getUserName() {
        return SubjectUtils.getUsername((AuthenticatedSubject)SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementUsernameStats(Map map) {
        Map map2 = map;
        synchronized (map2) {
            String string = SubjectUtils.getUsername((AuthenticatedSubject)SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelID));
            Long l = (Long)map.get(string);
            l = l != null ? new Long(l + 1L) : new Long(1L);
            map.put(string, l);
        }
    }

    static {
        String string = System.getProperty("weblogic.transaction.EnableInstrumentedTM");
        INSTR_ENABLED = string != null && string.equals("true");
    }

    private class NakRollbackAction
    implements PrivilegedExceptionAction {
        private CoordinatorOneway co = null;
        private CoordinatorOneway2 co2 = null;
        private Xid xid = null;
        private String scUrl = null;
        private short heurStatus = 0;
        private String heuristicErrorMessage = null;
        private String[] committedResources = null;
        private String[] rolledbackResources = null;

        NakRollbackAction(CoordinatorOneway coordinatorOneway, CoordinatorOneway2 coordinatorOneway2, Xid xid, String string, short s, String string2, String[] stringArray, String[] stringArray2) {
            this.co = coordinatorOneway;
            this.co2 = coordinatorOneway2;
            this.xid = xid;
            this.scUrl = string;
            this.heurStatus = s;
            this.heuristicErrorMessage = string2;
            this.committedResources = stringArray;
            this.rolledbackResources = stringArray2;
        }

        public Object run() throws Exception {
            if (this.co2 != null) {
                this.co2.nakRollback(this.xid, SubCoordinatorImpl.this.getScUrl(), this.heurStatus, this.heuristicErrorMessage, this.committedResources, this.rolledbackResources);
            } else if (this.co != null) {
                this.co.nakRollback(this.xid, SubCoordinatorImpl.this.getScUrl(), this.heurStatus, this.heuristicErrorMessage);
            }
            return null;
        }
    }

    private class AckRollbackAction
    implements PrivilegedExceptionAction {
        private CoordinatorOneway co = null;
        private CoordinatorOneway2 co2 = null;
        private Xid xid;
        private String scUrl = null;
        private String[] rolledbackResources;

        AckRollbackAction(CoordinatorOneway coordinatorOneway, CoordinatorOneway2 coordinatorOneway2, Xid xid, String string, String[] stringArray) {
            this.co = coordinatorOneway;
            this.co2 = coordinatorOneway2;
            this.xid = xid;
            this.scUrl = string;
            this.rolledbackResources = stringArray;
        }

        public Object run() throws Exception {
            if (this.co2 != null) {
                this.co2.ackRollback(this.xid, SubCoordinatorImpl.this.getScUrl(), this.rolledbackResources);
            } else if (this.co != null) {
                this.co.ackRollback(this.xid, this.scUrl);
            }
            return null;
        }
    }

    private class NakCommitAction
    implements PrivilegedExceptionAction {
        private CoordinatorOneway co = null;
        private CoordinatorOneway2 co2 = null;
        private Xid xid = null;
        private String scUrl = null;
        private short heurStatus = 0;
        private String heuristicErrorMessage = null;
        private String[] committedResources = null;
        private String[] rolledbackResources = null;

        NakCommitAction(CoordinatorOneway coordinatorOneway, CoordinatorOneway2 coordinatorOneway2, Xid xid, String string, short s, String string2, String[] stringArray, String[] stringArray2) {
            this.co = coordinatorOneway;
            this.co2 = coordinatorOneway2;
            this.xid = xid;
            this.scUrl = string;
            this.heurStatus = s;
            this.heuristicErrorMessage = string2;
            this.committedResources = stringArray;
            this.rolledbackResources = stringArray2;
        }

        public Object run() throws Exception {
            if (this.co2 != null) {
                this.co2.nakCommit(this.xid, SubCoordinatorImpl.this.getScUrl(), this.heurStatus, this.heuristicErrorMessage, this.committedResources, this.rolledbackResources);
            } else if (this.co != null) {
                this.co.nakCommit(this.xid, SubCoordinatorImpl.this.getScUrl(), this.heurStatus, this.heuristicErrorMessage);
            }
            return null;
        }
    }

    private class AckCommitAction
    implements PrivilegedExceptionAction {
        private CoordinatorOneway co = null;
        private CoordinatorOneway2 co2 = null;
        private Xid xid = null;
        private String scUrl = null;
        private String[] committedResources;

        AckCommitAction(CoordinatorOneway coordinatorOneway, CoordinatorOneway2 coordinatorOneway2, Xid xid, String string, String[] stringArray) {
            this.co = coordinatorOneway;
            this.co2 = coordinatorOneway2;
            this.xid = xid;
            this.scUrl = string;
            this.committedResources = stringArray;
        }

        public Object run() throws Exception {
            if (this.co2 != null) {
                this.co2.ackCommit(this.xid, SubCoordinatorImpl.this.getScUrl(), this.committedResources);
            } else if (this.co != null) {
                this.co.ackCommit(this.xid, this.scUrl);
            }
            return null;
        }
    }

    private class AckPrepareAction
    implements PrivilegedExceptionAction {
        private CoordinatorOneway co = null;
        private Xid xid = null;
        private String scUrl = null;
        private int vote = 0;

        AckPrepareAction(CoordinatorOneway coordinatorOneway, Xid xid, String string, int n) {
            this.co = coordinatorOneway;
            this.xid = xid;
            this.scUrl = string;
            this.vote = n;
        }

        public Object run() throws Exception {
            this.co.ackPrepare(this.xid, SubCoordinatorImpl.this.getScUrl(), this.vote);
            return null;
        }
    }

    private class StartRollbackAction
    implements PrivilegedExceptionAction {
        private CoordinatorOneway co = null;
        private PropagationContext propagationCtx = null;

        StartRollbackAction(CoordinatorOneway coordinatorOneway, PropagationContext propagationContext) {
            this.co = coordinatorOneway;
            this.propagationCtx = propagationContext;
        }

        public Object run() throws Exception {
            this.co.startRollback(this.propagationCtx);
            return null;
        }
    }

    private class AckPrePrepareAction
    implements PrivilegedExceptionAction {
        private CoordinatorOneway co = null;
        private PropagationContext propagationCtx = null;

        AckPrePrepareAction(CoordinatorOneway coordinatorOneway, PropagationContext propagationContext) {
            this.co = coordinatorOneway;
            this.propagationCtx = propagationContext;
        }

        public Object run() throws Exception {
            this.co.ackPrePrepare(this.propagationCtx);
            return null;
        }
    }
}

