/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import weblogic.management.DomainDir;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.transaction.TransactionLoggable;
import weblogic.transaction.internal.LogDataInput;
import weblogic.transaction.internal.ResourceCheckpoint;
import weblogic.transaction.internal.ServerTransactionImpl;
import weblogic.transaction.internal.StoreTransactionLoggerImpl;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TxDebug;
import weblogic.transaction.internal.XidImpl;
import weblogic.utils.StackTraceUtils;

public final class TransactionLogUpgradeHelper {
    private final ArrayList abbrevTable = new ArrayList();
    private final List fileList = new LinkedList();

    public void attemptUpgrade(PersistentStore persistentStore, String string, String string2, String string3) throws IOException, PersistentStoreException {
        StoreTransactionLoggerImpl storeTransactionLoggerImpl = new StoreTransactionLoggerImpl(persistentStore);
        File file = this.findOldTLOG(string, string2, string3);
        if (file != null) {
            List list = this.recover();
            storeTransactionLoggerImpl.store(list);
            file.delete();
            this.delete();
        }
    }

    public File findOldTLOG(String string, String string2, String string3) throws IOException {
        string = string + string2;
        String string4 = this.addSeparator(string3);
        String string5 = TransactionLogUpgradeHelper.getRelativePrefixRelativeServerDir(string2);
        if (string5.length() > 0 && !string5.endsWith("/") && !string5.endsWith(File.separatorChar + "")) {
            string5 = string5 + File.separatorChar;
        }
        if (TxDebug.JTATLOG.isDebugEnabled()) {
            TxDebug.JTATLOG.debug("Looking for TLOG: DefaultLogPath=\"" + string5 + "\", RootDir=\"" + string4 + "\"");
        }
        if (this.isRelativePath(string)) {
            try {
                return this.readHeader(string5 + string + ".");
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    return this.readHeader(string4 + string5 + string + ".");
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    try {
                        return this.readHeader(string4 + string + ".");
                    }
                    catch (FileNotFoundException fileNotFoundException3) {
                        try {
                            return this.readHeader(string);
                        }
                        catch (FileNotFoundException fileNotFoundException4) {
                        }
                    }
                }
            }
        } else {
            try {
                return this.readHeader(string + ".");
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    return this.readHeader(string);
                }
                catch (FileNotFoundException fileNotFoundException5) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private File readHeader(String string) throws IOException {
        int n;
        byte[] byArray;
        File file;
        String string2 = string + "0000.tlog";
        String string3 = string + "0000.tmp";
        if (TxDebug.JTATLOG.isDebugEnabled()) {
            TxDebug.JTATLOG.debug("TLOG header: reading, fname=" + string2);
        }
        if (!(file = new File(string2)).exists()) {
            file = new File(string3);
            if (!file.exists()) {
                if (TxDebug.JTATLOG.isDebugEnabled()) {
                    TxDebug.JTATLOG.debug("TLOG header: file not found, headerFileName=" + string2);
                }
                throw new FileNotFoundException(string2);
            }
            TXLogger.logTLOGRecoveredBackupHeader((String)string3);
        }
        if ((byArray = this.readFile(file)).length == 0) {
            return file;
        }
        UpgradeLogDataInputImpl upgradeLogDataInputImpl = new UpgradeLogDataInputImpl(new LogByteArrayInputStream(byArray));
        int n2 = upgradeLogDataInputImpl.readNonNegativeInt();
        if (TxDebug.JTATLOG.isDebugEnabled()) {
            TxDebug.JTATLOG.debug("TLOG header: read version=" + n2);
        }
        if (n2 != 0) {
            TXLogger.logTLOGUnrecognizedHeaderVersionNumber();
            return file;
        }
        int n3 = upgradeLogDataInputImpl.readNonNegativeInt();
        if (TxDebug.JTATLOG.isDebugEnabled()) {
            TxDebug.JTATLOG.debug("TLOG header: read nextFileID=" + n3);
        }
        int n4 = upgradeLogDataInputImpl.readNonNegativeInt();
        if (TxDebug.JTATLOG.isDebugEnabled()) {
            TxDebug.JTATLOG.debug("TLOG header: read file cnt=" + n4);
        }
        for (n = 0; n < n4; ++n) {
            int n5 = upgradeLogDataInputImpl.readNonNegativeInt();
            if (TxDebug.JTATLOG.isDebugEnabled()) {
                TxDebug.JTATLOG.debug("TLOG header: read active file id[" + n + "]=" + n5);
            }
            this.fileList.add(this.makeName(string, n5));
        }
        n4 = upgradeLogDataInputImpl.readNonNegativeInt();
        if (TxDebug.JTATLOG.isDebugEnabled()) {
            TxDebug.JTATLOG.debug("TLOG header: read abbreviation cnt=" + n4);
        }
        for (n = 0; n < n4; ++n) {
            String string4 = upgradeLogDataInputImpl.readString();
            if (TxDebug.JTATLOG.isDebugEnabled()) {
                TxDebug.JTATLOG.debug("TLOG header: read abbreviation[" + n + "]=" + string4);
            }
            this.abbrevTable.add(string4);
        }
        return file;
    }

    List recover() throws IOException {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.fileList.iterator();
        while (iterator.hasNext()) {
            this.recoverFile(linkedList, (String)iterator.next());
        }
        return linkedList;
    }

    void delete() throws IOException {
        Iterator iterator = this.fileList.iterator();
        while (iterator.hasNext()) {
            File file = new File((String)iterator.next());
            file.delete();
        }
    }

    private void recoverFile(List list, String string) throws IOException {
        File file;
        if (TxDebug.JTATLOG.isDebugEnabled()) {
            TxDebug.JTATLOG.debug("TLOG file: recovering, fname=" + string);
        }
        if (!(file = new File(string)).exists()) {
            TXLogger.logTLOGMissing((String)string);
            return;
        }
        byte[] byArray = this.readFile(file);
        UpgradeLogDataInputImpl upgradeLogDataInputImpl = new UpgradeLogDataInputImpl(new LogByteArrayInputStream(byArray));
        while (upgradeLogDataInputImpl.available() > 0) {
            int n = 0;
            int n2 = -1;
            try {
                n = upgradeLogDataInputImpl.readNonNegativeInt();
                n2 = upgradeLogDataInputImpl.getPos();
            }
            catch (Exception exception) {
                TXLogger.logTLOGFileReadFormatException((int)100, (String)string, (Throwable)exception);
            }
            if (n <= 0 || n2 < 0) {
                TXLogger.logTLOGFileReadFormatError((int)200, (String)string);
                break;
            }
            upgradeLogDataInputImpl.skip(n);
            try {
                TransactionLoggable transactionLoggable = this.readLogRecord(byArray, n2, n);
                if (transactionLoggable != null) {
                    if (transactionLoggable instanceof ResourceCheckpoint) {
                        ((ResourceCheckpoint)transactionLoggable).convertPre810JTSName();
                    }
                    if (transactionLoggable instanceof ServerTransactionImpl) {
                        ((ServerTransactionImpl)transactionLoggable).convertPre810JTSName();
                    }
                    list.add(transactionLoggable);
                    continue;
                }
                TXLogger.logTLOGFileReadFormatError((int)300, (String)string);
            }
            catch (Exception exception) {
                TXLogger.logTLOGFileReadFormatException((int)400, (String)string, (Throwable)exception);
            }
        }
    }

    private TransactionLoggable readLogRecord(byte[] byArray, int n, int n2) {
        TransactionLoggable transactionLoggable;
        UpgradeLogDataInputImpl upgradeLogDataInputImpl;
        Object object;
        if (n + n2 > byArray.length || n2 < 5) {
            TXLogger.logTLOGReadChecksumError();
            return null;
        }
        try {
            object = new CRC32();
            ((CRC32)object).update(byArray, n, n2 - 4);
            long l = ((CRC32)object).getValue();
            long l2 = ((long)byArray[n + n2 - 4] & 0xFFL) << 24;
            l2 += ((long)byArray[n + n2 - 3] & 0xFFL) << 16;
            l2 += ((long)byArray[n + n2 - 2] & 0xFFL) << 8;
            if (l != (l2 += (long)byArray[n + n2 - 1] & 0xFFL)) {
                TXLogger.logTLOGRecordChecksumMismatch((int)1);
                if (TxDebug.JTATLOG.isDebugEnabled()) {
                    TxDebug.JTATLOG.debug("Mismatch!  checksum=" + l + ", verify=" + l2);
                }
                return null;
            }
        }
        catch (Exception exception) {
            TXLogger.logTLOGRecordChecksumException((int)2, (Throwable)exception);
            return null;
        }
        try {
            upgradeLogDataInputImpl = new UpgradeLogDataInputImpl(new LogByteArrayInputStream(byArray, n));
        }
        catch (IOException iOException) {
            return null;
        }
        object = upgradeLogDataInputImpl.readAbbrevString();
        try {
            transactionLoggable = (TransactionLoggable)Class.forName((String)object).newInstance();
        }
        catch (Exception exception) {
            TXLogger.logTLOGRecordClassInstantiationException((String)object, (Throwable)exception);
            return null;
        }
        try {
            transactionLoggable.readExternal((DataInput)upgradeLogDataInputImpl);
        }
        catch (Throwable throwable) {
            TXLogger.logTLOGReadExternalException((String)object, (Throwable)throwable);
            return null;
        }
        if (TxDebug.JTATLOG.isDebugEnabled()) {
            TxDebug.JTATLOG.debug("TLOG read log record, obj=" + transactionLoggable);
        }
        return transactionLoggable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File file) {
        byte[] byArray = new byte[]{};
        FileInputStream fileInputStream = null;
        try {
            int n;
            byArray = new byte[(int)file.length()];
            fileInputStream = new FileInputStream(file);
            int n2 = 0;
            do {
                if ((n = fileInputStream.read(byArray, n2, byArray.length - n2)) <= 0) continue;
                n2 += n;
            } while (n > 0);
        }
        catch (Exception exception) {
            TXLogger.logTLOGFileReadError((String)file.getAbsolutePath(), (Throwable)exception);
        }
        finally {
            block14: {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    if (!TxDebug.JTATLOG.isDebugEnabled()) break block14;
                    TxDebug.JTATLOG.debug("TLOG header: close exception, fname=" + file.getAbsolutePath(), (Throwable)exception);
                }
            }
        }
        return byArray;
    }

    private String makeName(String string, int n) {
        String[] stringArray = new String[]{"000", "00", "0", ""};
        String string2 = Integer.toString(n);
        return string + stringArray[string2.length() - 1] + string2 + ".tlog";
    }

    private String addSeparator(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() > 0 && !string.endsWith("/") && !string.endsWith(File.separatorChar + "")) {
            return string + File.separatorChar;
        }
        return string;
    }

    private boolean isRelativePath(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return false;
        }
        return !file.toString().startsWith(File.separatorChar + "");
    }

    private static String getRelativePrefixRelativeServerDir(String string) {
        return DomainDir.getRootDir() + File.separator + string;
    }

    private final class UpgradeLogDataInputImpl
    extends DataInputStream
    implements LogDataInput {
        private final LogByteArrayInputStream inStream;

        public UpgradeLogDataInputImpl(LogByteArrayInputStream logByteArrayInputStream) throws IOException {
            super(logByteArrayInputStream);
            this.inStream = logByteArrayInputStream;
        }

        public int getPos() {
            return this.inStream.getPos();
        }

        public void skip(int n) {
            this.inStream.skip(n);
        }

        private byte readByteIgnore() {
            try {
                return super.readByte();
            }
            catch (IOException iOException) {
                return 0;
            }
        }

        private int readIntIgnore() {
            try {
                return super.readInt();
            }
            catch (IOException iOException) {
                return 0;
            }
        }

        public int readNonNegativeInt() {
            byte by;
            int n = 0;
            do {
                by = this.readByteIgnore();
                n = n << 7 | by & 0x7F;
            } while ((by & 0x80) != 0);
            return n;
        }

        public String readString() {
            int n = this.readNonNegativeInt();
            if (n > this.inStream.available()) {
                throw new RuntimeException("transaction log decoder:  String(" + n + ") too big");
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append((char)this.readNonNegativeInt());
            }
            return stringBuffer.toString();
        }

        public String readAbbrevString() {
            int n = this.readNonNegativeInt();
            if (n == 0) {
                int n2 = this.readNonNegativeInt();
                if (n2 == 0) {
                    return "";
                }
                return (String)TransactionLogUpgradeHelper.this.abbrevTable.get(n2 - 1);
            }
            if (n > this.inStream.available()) {
                throw new RuntimeException("transaction log decoder:  String(" + n + ") too big");
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append((char)this.readNonNegativeInt());
            }
            return stringBuffer.toString();
        }

        public byte[] readByteArray() {
            int n = this.readNonNegativeInt();
            if (n <= 0) {
                return null;
            }
            if (n > this.inStream.available()) {
                throw new RuntimeException("transaction log decoder:  String(" + n + ") too big");
            }
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.readByteIgnore();
            }
            return byArray;
        }

        public Map readProperties() throws IOException {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
            int n = this.readNonNegativeInt();
            block8: for (int i = 0; i < n; ++i) {
                String string = this.readAbbrevString();
                if (string == null || string.equals("")) {
                    throw new InvalidObjectException("transaction log record: missing property name");
                }
                int n2 = this.readNonNegativeInt();
                switch (n2) {
                    case 1: {
                        String string2 = this.readString();
                        hashMap.put(string, string2);
                        continue block8;
                    }
                    case 2: {
                        String string3 = this.readString();
                        hashMap.put(string, new Integer(string3));
                        continue block8;
                    }
                    case 3: {
                        XidImpl xidImpl = XidImpl.create((int)this.readNonNegativeInt(), (byte[])this.readByteArray(), (byte[])this.readByteArray());
                        hashMap.put(string, xidImpl);
                        continue block8;
                    }
                    case 4: {
                        XidImpl xidImpl = XidImpl.create((int)this.readIntIgnore(), (byte[])this.readByteArray(), (byte[])this.readByteArray());
                        hashMap.put(string, xidImpl);
                        continue block8;
                    }
                    case 5: {
                        hashMap.put(string, new Integer(this.readIntIgnore()));
                        continue block8;
                    }
                    case 6: {
                        hashMap.put(string, this.readObject());
                        continue block8;
                    }
                    default: {
                        throw new InvalidObjectException("transaction log record: bad property type " + n2 + " for property:" + string);
                    }
                }
            }
            return hashMap;
        }

        private Object readObject() throws IOException {
            ObjectInputStream objectInputStream = new ObjectInputStream(this.inStream);
            try {
                return objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(StackTraceUtils.throwable2StackTrace((Throwable)classNotFoundException));
            }
        }
    }

    private final class LogByteArrayInputStream
    extends ByteArrayInputStream {
        LogByteArrayInputStream(byte[] byArray) {
            super(byArray);
        }

        LogByteArrayInputStream(byte[] byArray, int n) {
            super(byArray, n, byArray.length - n);
        }

        int getPos() {
            return this.pos;
        }
    }
}

