/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import weblogic.cluster.migration.Migratable;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.transaction.internal.TransactionRecoveryService;
import weblogic.transaction.internal.TxDebug;

public class TransactionRecoveryNoOpService
extends AbstractServerService
implements Migratable {
    private static final boolean DEBUG = false;

    public void start() throws ServiceFailureException {
        if (!TransactionRecoveryService.isInCluster()) {
            return;
        }
        JTAMigratableTargetMBean jTAMigratableTargetMBean = TransactionRecoveryService.getLocalServer().getJTAMigratableTarget();
        if (TxDebug.JTAMigration.isDebugEnabled()) {
            TxDebug.JTAMigration.debug("Register no-op migratable on JTAMT [" + TransactionRecoveryService.getLocalServerName() + "] ...");
        }
        try {
            MigrationManager.singleton().register(this, jTAMigratableTargetMBean);
        }
        catch (MigrationException migrationException) {
            throw new ServiceFailureException("Error occurred while registering Transaction Recovery No-Op Service.", (Throwable)migrationException);
        }
    }

    public void stop() throws ServiceFailureException {
        this.halt();
    }

    public void halt() throws ServiceFailureException {
        if (!TransactionRecoveryService.isInCluster()) {
            return;
        }
        JTAMigratableTargetMBean jTAMigratableTargetMBean = TransactionRecoveryService.getLocalServer().getJTAMigratableTarget();
        if (TxDebug.JTAMigration.isDebugEnabled()) {
            TxDebug.JTAMigration.debug("UnRegister no-op migratable on JTAMT [" + TransactionRecoveryService.getLocalServerName() + "] ...");
        }
        try {
            MigrationManager.singleton().unregister(this, jTAMigratableTargetMBean);
        }
        catch (MigrationException migrationException) {
            throw new ServiceFailureException("Error occurred while unregistering Transaction Recovery No-Op Service.", (Throwable)migrationException);
        }
    }

    public int getOrder() {
        return -901;
    }

    public void migratableActivate() throws MigrationException {
    }

    public void migratableDeactivate() throws MigrationException {
    }

    public void migratableInitialize() {
    }
}

