/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import weblogic.cluster.migration.JTAMigrationHandler;
import weblogic.cluster.migration.Migratable;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.JTARecoveryRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.transaction.internal.JTARecoveryRuntime;
import weblogic.transaction.internal.JTARecoveryRuntimeMBeanImpl;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TransactionService;
import weblogic.transaction.internal.TxDebug;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransactionRecoveryService
extends AbstractServerService
implements Migratable {
    private String serverName;
    private boolean active = false;
    private boolean failBackInProgress = false;
    private JTARecoveryRuntimeMBeanImpl runtimeMBean;
    private MigratableTargetMBean mtConfig;
    private static final HashMap mServices = new HashMap(3);
    private static boolean ownRecoveryService = false;
    private static final Object startLock = new Object();
    private static boolean started;
    private static final AuthenticatedSubject kernelId;
    static final int TRS_MIGRATABLE_ORDER = -900;

    public TransactionRecoveryService() {
    }

    private TransactionRecoveryService(String string) {
        this.serverName = string;
        try {
            this.runtimeMBean = new JTARecoveryRuntimeMBeanImpl(this);
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
    }

    @Override
    public void migratableInitialize() {
        if (TxDebug.JTAMigration.isDebugEnabled()) {
            TxDebug.JTAMigration.debug("migratableInitialize called for '" + this.serverName + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migratableActivate() throws MigrationException {
        if (TxDebug.JTAMigration.isDebugEnabled()) {
            TxDebug.JTAMigration.debug("migratableActivate called for '" + this.serverName + "', active:" + this.active);
        }
        ServerTransactionManagerImpl serverTransactionManagerImpl = TransactionRecoveryService.getTM();
        try {
            TransactionRecoveryService transactionRecoveryService = this;
            synchronized (transactionRecoveryService) {
                if (this.active) {
                    return;
                }
                this.active = true;
            }
            if (this.serverName.equals(TransactionRecoveryService.getLocalServerName())) {
                ownRecoveryService = true;
                serverTransactionManagerImpl.recover();
            } else {
                serverTransactionManagerImpl.recover(this.serverName);
            }
        }
        catch (Exception exception) {
            TransactionRecoveryService transactionRecoveryService = this;
            synchronized (transactionRecoveryService) {
                this.active = false;
            }
            TXLogger.logRecoveryServiceActivationFailed((String)this.serverName, (Throwable)exception);
            throw new MigrationException("Activation of TransactionRecoveryService for server '" + this.serverName + "' failed", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migratableDeactivate() throws MigrationException {
        if (TxDebug.JTAMigration.isDebugEnabled()) {
            TxDebug.JTAMigration.debug("migratableDeactivate called for '" + this.serverName + "', active:" + this.active);
        }
        if (!this.serverName.equals(TransactionRecoveryService.getLocalServerName())) {
            TransactionRecoveryService transactionRecoveryService = this;
            synchronized (transactionRecoveryService) {
                if (!this.active) {
                    return;
                }
                this.active = false;
            }
            TransactionRecoveryService.getTM().suspendRecovery(this.serverName);
        } else {
            if (TransactionService.isRunning()) {
                TXLogger.logMigrateRecoveryServiceWhileServerActive();
                throw new MigrationException("Current server is still active.  Cannot migrate Transaction Recovery Service from current server.  For controlled migration, please shut down the server and then perform the manual migration.");
            }
            if (TransactionService.isSuspending() || TransactionService.isForceSuspending() || TransactionService.isShuttingDown()) {
                TransactionRecoveryService transactionRecoveryService = this;
                synchronized (transactionRecoveryService) {
                    if (!this.active) {
                        return;
                    }
                    this.active = false;
                }
                TransactionRecoveryService.getTM().checkpoint();
            }
        }
    }

    @Override
    public int getOrder() {
        return -900;
    }

    String getServerName() {
        return this.serverName;
    }

    static final boolean isInCluster() {
        return ManagementService.getRuntimeAccess(kernelId).getServer().getCluster() != null;
    }

    boolean isActive() {
        return this.active;
    }

    private JTARecoveryRuntime getRuntimeMBean() {
        return this.runtimeMBean;
    }

    static void resume() throws ServiceFailureException {
        TransactionRecoveryService.startOwnRecoveryIfNeeded();
        if (!TransactionRecoveryService.isInCluster()) {
            return;
        }
        try {
            TransactionRecoveryService.deployAllTransactionRecoveryServices();
        }
        catch (MigrationException migrationException) {
            throw new ServiceFailureException("Error occurred while registering or activating the Transaction Recovery Service for the current server.", (Throwable)migrationException);
        }
        TransactionRecoveryService.checkTransactionLogOwnership();
        started = true;
    }

    public void start() throws ServiceFailureException {
    }

    public void stop() {
        this.halt();
    }

    public void halt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void forceSuspend() {
        Iterator iterator = startLock;
        synchronized (iterator) {
            if (!started) {
                return;
            }
        }
        TransactionRecoveryService.stopOwnRecoveryIfNeeded();
        if (!TransactionRecoveryService.isInCluster()) {
            return;
        }
        iterator = mServices.values().iterator();
        while (iterator.hasNext()) {
            TransactionRecoveryService transactionRecoveryService = (TransactionRecoveryService)iterator.next();
            transactionRecoveryService.cleanup();
            iterator.remove();
        }
    }

    private static void startOwnRecoveryIfNeeded() throws ServiceFailureException {
        if (!TransactionRecoveryService.isInCluster()) {
            ServerTransactionManagerImpl serverTransactionManagerImpl = TransactionRecoveryService.getTM();
            TransactionRecoveryService transactionRecoveryService = TransactionRecoveryService.getOrCreate(TransactionRecoveryService.getLocalServerName());
            try {
                serverTransactionManagerImpl.recover();
                transactionRecoveryService.active = true;
                ownRecoveryService = true;
                serverTransactionManagerImpl.setJdbcTLogInitialized(true);
            }
            catch (Exception exception) {
                throw new ServiceFailureException("Fatal error creating or processing transaction log during crash recovery", (Throwable)exception);
            }
            return;
        }
    }

    private static void stopOwnRecoveryIfNeeded() {
        if (!TransactionRecoveryService.isInCluster()) {
            TransactionRecoveryService.getTM().checkpoint();
        }
    }

    static void scheduleFailBack(String string) {
        if (TransactionRecoveryService.requestFailBack(string)) {
            if (TxDebug.JTAMigration.isDebugEnabled()) {
                TxDebug.JTAMigration.debug("MigratedTLog.scheduleFailBack for '" + string + "'");
            }
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new FailBackRequest(string)));
        }
    }

    static JTARecoveryRuntime getRuntimeMBean(String string) {
        TransactionRecoveryService transactionRecoveryService = TransactionRecoveryService.get(string);
        if (transactionRecoveryService != null) {
            return transactionRecoveryService.getRuntimeMBean();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JTARecoveryRuntimeMBean[] getAllRuntimeMBeans() {
        Vector<JTARecoveryRuntime> vector = new Vector<JTARecoveryRuntime>(mServices.size());
        JTARecoveryRuntimeMBean[] jTARecoveryRuntimeMBeanArray = mServices;
        synchronized (mServices) {
            for (TransactionRecoveryService transactionRecoveryService : mServices.values()) {
                vector.add(transactionRecoveryService.getRuntimeMBean());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            jTARecoveryRuntimeMBeanArray = new JTARecoveryRuntimeMBean[vector.size()];
            vector.toArray(jTARecoveryRuntimeMBeanArray);
            return jTARecoveryRuntimeMBeanArray;
        }
    }

    private void cleanup() {
        if (this.mtConfig != null) {
            try {
                if (TxDebug.JTAMigration.isDebugEnabled()) {
                    TxDebug.JTAMigration.debug("Unregistering migratable for '" + this.serverName + "', isManualActiveOn: " + this.mtConfig.isManualActiveOn(ManagementService.getRuntimeAccess(kernelId).getServer()) + "', userPreferredServer: " + this.mtConfig.getUserPreferredServer().getName() + ", migrationPolicy: " + this.mtConfig.getMigrationPolicy());
                }
                MigrationManager.singleton().unregister(this, this.mtConfig);
                if (TxDebug.JTAMigration.isDebugEnabled()) {
                    TxDebug.JTAMigration.debug("Migratable for '" + this.serverName + "' unregistered");
                }
            }
            catch (MigrationException migrationException) {
                if (TxDebug.JTAMigration.isDebugEnabled()) {
                    TxDebug.JTAMigration.debug("Migratable for '" + this.serverName + "' unregistration failed", (Throwable)migrationException);
                }
                TXLogger.logRecoveryServiceUnregistrationFailed((String)this.serverName);
            }
        }
        if (this.runtimeMBean != null) {
            try {
                this.runtimeMBean.unregister();
            }
            catch (ManagementException managementException) {
                // empty catch block
            }
            this.runtimeMBean = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TransactionRecoveryService get(String string) {
        HashMap hashMap = mServices;
        synchronized (hashMap) {
            return (TransactionRecoveryService)mServices.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TransactionRecoveryService getOrCreate(String string) {
        TransactionRecoveryService transactionRecoveryService;
        HashMap hashMap = mServices;
        synchronized (hashMap) {
            transactionRecoveryService = (TransactionRecoveryService)mServices.get(string);
            if (transactionRecoveryService != null) {
                return transactionRecoveryService;
            }
            transactionRecoveryService = new TransactionRecoveryService(string);
            mServices.put(string, transactionRecoveryService);
        }
        return transactionRecoveryService;
    }

    private static TransactionRecoveryService getOrCreate(ServerMBean serverMBean) throws MigrationException {
        TransactionRecoveryService transactionRecoveryService;
        block6: {
            transactionRecoveryService = TransactionRecoveryService.getOrCreate(serverMBean.getName());
            transactionRecoveryService.mtConfig = serverMBean.getJTAMigratableTarget();
            if (transactionRecoveryService.mtConfig != null) {
                String string = serverMBean.getName();
                try {
                    if (TxDebug.JTAMigration.isDebugEnabled()) {
                        TxDebug.JTAMigration.debug("Registering migratable for '" + string + "', isManualActiveOn: " + transactionRecoveryService.mtConfig.isManualActiveOn(ManagementService.getRuntimeAccess(kernelId).getServer()) + "', userPreferredServer: " + transactionRecoveryService.mtConfig.getUserPreferredServer().getName() + ", migrationPolicy: " + transactionRecoveryService.mtConfig.getMigrationPolicy());
                    }
                    MigrationManager.singleton().register(transactionRecoveryService, transactionRecoveryService.mtConfig);
                    if (TxDebug.JTAMigration.isDebugEnabled()) {
                        TxDebug.JTAMigration.debug("Migratable for '" + string + "' registered");
                    }
                }
                catch (MigrationException migrationException) {
                    if (TxDebug.JTAMigration.isDebugEnabled()) {
                        TxDebug.JTAMigration.debug("Migratable for '" + string + "' registration failed", (Throwable)migrationException);
                    }
                    TXLogger.logRecoveryServiceRegistrationFailed((String)string);
                    if (!string.equals(TransactionRecoveryService.getLocalServerName())) break block6;
                    throw migrationException;
                }
            }
        }
        return transactionRecoveryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(String string) {
        TransactionRecoveryService transactionRecoveryService = TransactionRecoveryService.get(string);
        if (transactionRecoveryService != null) {
            transactionRecoveryService.cleanup();
            HashMap hashMap = mServices;
            synchronized (hashMap) {
                mServices.remove(string);
            }
        }
    }

    private static void deployAllTransactionRecoveryServices() throws MigrationException {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            ServerMBean serverMBean = serverMBeanArray[i];
            String string = serverMBeanArray[i].getName();
            JTAMigratableTargetMBean jTAMigratableTargetMBean = serverMBean.getJTAMigratableTarget();
            if (TransactionRecoveryService.isLocalServerIncluded(jTAMigratableTargetMBean.getAllCandidateServers())) {
                TransactionRecoveryService.getOrCreate(serverMBean);
            }
            if (string.equals(TransactionRecoveryService.getLocalServerName())) continue;
            jTAMigratableTargetMBean.addPropertyChangeListener(new DeploymentChangeListener(string));
            if (!TxDebug.JTAMigration.isDebugEnabled()) continue;
            TxDebug.JTAMigration.debug("Added DeploymentChangeListener for '" + string + "'");
        }
    }

    private static void checkTransactionLogOwnership() throws ServiceFailureException {
        if (ownRecoveryService) {
            if (TxDebug.JTAMigration.isDebugEnabled()) {
                TxDebug.JTAMigration.debug("Successfully gained TLOG ownership.");
            }
        } else {
            TXLogger.logGetTransactionLogOwnershipError();
            throw new ServiceFailureException("Cannot get ownership of Transaction Log.  Make sure that the Transaction Recovery Migratable Service is migrated back to the current server before restarting it.");
        }
    }

    public void prepareDeployments(Collection<DeploymentMBean> collection, boolean bl) {
    }

    public void activateDeployments() {
        TransactionRecoveryService.initialize();
    }

    public void rollbackDeployments() {
    }

    public void destroyDeployments(Collection<DeploymentMBean> collection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        try {
            Object object = startLock;
            synchronized (object) {
                if (!started) {
                    PlatformHelper.getPlatformHelper().openPrimaryStore(false);
                    if (PlatformHelper.getPlatformHelper().getPrimaryStore() == null) {
                        String string = "Transaction Log PrimaryStore can not be set";
                        TransactionRecoveryService.getTM().registerFailedPrimaryStore((Throwable)new ServiceFailureException(string));
                        TXLogger.logFailedTLOGBoot((String)string);
                    } else {
                        TransactionRecoveryService.resume();
                    }
                }
            }
        }
        catch (ServiceFailureException serviceFailureException) {
            TXLogger.logFailedActivateDeployments((Throwable)serviceFailureException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean requestFailBack(String string) {
        TransactionRecoveryService transactionRecoveryService = TransactionRecoveryService.get(string);
        if (transactionRecoveryService != null) {
            TransactionRecoveryService transactionRecoveryService2 = transactionRecoveryService;
            synchronized (transactionRecoveryService2) {
                if (transactionRecoveryService.failBackInProgress || !transactionRecoveryService.active) {
                    return false;
                }
                transactionRecoveryService.failBackInProgress = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void failBack(String string, boolean bl) {
        block24: {
            TransactionRecoveryService transactionRecoveryService;
            block25: {
                try {
                    if (JTAMigrationHandler.isAvailable(string)) break block24;
                    if (!TxDebug.JTAMigration.isDebugEnabled()) break block25;
                    TxDebug.JTAMigration.debug("Migrator is not available. Will skip failback.");
                }
                catch (Throwable throwable) {
                    TransactionRecoveryService transactionRecoveryService2 = TransactionRecoveryService.get(string);
                    if (transactionRecoveryService2 != null) {
                        TransactionRecoveryService transactionRecoveryService3 = transactionRecoveryService2;
                        synchronized (transactionRecoveryService3) {
                            transactionRecoveryService2.failBackInProgress = false;
                        }
                    }
                    throw throwable;
                }
            }
            if ((transactionRecoveryService = TransactionRecoveryService.get(string)) != null) {
                TransactionRecoveryService transactionRecoveryService4 = transactionRecoveryService;
                synchronized (transactionRecoveryService4) {
                    transactionRecoveryService.failBackInProgress = false;
                }
            }
            return;
        }
        try {
            TransactionRecoveryService.migrateJTA(string, string, true, bl);
            if (TxDebug.JTAMigration.isDebugEnabled()) {
                TxDebug.JTAMigration.debug("Successfully failed back to '" + string + "'");
            }
        }
        catch (MigrationException migrationException) {
            if (TxDebug.JTAMigration.isDebugEnabled()) {
                TxDebug.JTAMigration.debug("Recovery is done, but fail-back to '" + string + "'" + " failed.", (Throwable)migrationException);
            }
            if (bl) {
                TXLogger.logRecoveryServiceFailbackFailed((String)string);
            }
            TxDebug.JTAMigration.debug("Try again with destinationUp=true");
            try {
                TransactionRecoveryService.migrateJTA(string, string, true, true);
                if (TxDebug.JTAMigration.isDebugEnabled()) {
                    TxDebug.JTAMigration.debug("Successfully failed back to '" + string + "'");
                }
            }
            catch (MigrationException migrationException2) {
                if (TxDebug.JTAMigration.isDebugEnabled()) {
                    TxDebug.JTAMigration.debug("Recovery is done, but fail-back to '" + string + "'" + " failed.", (Throwable)migrationException2);
                }
                TXLogger.logRecoveryServiceFailbackRetryFailed((String)string);
            }
        }
        TransactionRecoveryService transactionRecoveryService = TransactionRecoveryService.get(string);
        if (transactionRecoveryService != null) {
            TransactionRecoveryService transactionRecoveryService5 = transactionRecoveryService;
            synchronized (transactionRecoveryService5) {
                transactionRecoveryService.failBackInProgress = false;
            }
        }
    }

    static final void failbackIfNeeded() {
        try {
            if (!TransactionRecoveryService.isInCluster()) {
                return;
            }
            if (ManagementService.getRuntimeAccess(kernelId).isAdminServer() && !TransactionRecoveryService.isAutomaticMigrationMode()) {
                if (TxDebug.JTAMigration.isDebugEnabled()) {
                    TxDebug.JTAMigration.debug("AdminServer itself is in cluster, and it is manual JTA migration policy. Will skip TRS failback.");
                }
                return;
            }
            if (TxDebug.JTAMigration.isDebugEnabled()) {
                TxDebug.JTAMigration.debug("Going to deactivate JTAMT...");
            }
            JTAMigrationHandler.deactivateJTA(TransactionRecoveryService.getLocalServerName(), TransactionRecoveryService.getLocalServerName());
            if (TxDebug.JTAMigration.isDebugEnabled()) {
                TxDebug.JTAMigration.debug("Deactivated JTAMT");
            }
        }
        catch (Exception exception) {
            if (TxDebug.JTAMigration.isDebugEnabled()) {
                TxDebug.JTAMigration.debug("Failed to deactivate JTAMT", (Throwable)exception);
            }
            if (!TransactionRecoveryService.isStrictOwnershipCheck() && !JTAMigrationHandler.isAvailable(TransactionRecoveryService.getLocalServerName())) {
                TXLogger.logMigratorNotAvailable((String)TransactionRecoveryService.getLocalServerName());
                return;
            }
            throw new MigrationException("Could not start JTAMT on local server because it could not be deactivated on the current host.", exception);
        }
    }

    private static void migrateJTA(String string, String string2, boolean bl, boolean bl2) throws MigrationException {
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedExceptionAction)new MigrateJTAAction(string, string2, bl, bl2));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof MigrationException) {
                throw (MigrationException)exception;
            }
            throw new MigrationException("Unexpected exception thrown during migrate operation.", exception);
        }
    }

    private static ServerMBean getServerConfigMBean(String string) {
        return ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(string);
    }

    static final String getLocalServerName() {
        return ManagementService.getRuntimeAccess(kernelId).getServer().getName();
    }

    static final ServerMBean getLocalServer() {
        return ManagementService.getRuntimeAccess(kernelId).getServer();
    }

    static final boolean isAutomaticMigrationMode() {
        return TransactionRecoveryService.getLocalServer().getJTAMigratableTarget() != null && "failure-recovery".equals(TransactionRecoveryService.getLocalServer().getJTAMigratableTarget().getMigrationPolicy());
    }

    private static final boolean isStrictOwnershipCheck() {
        return TransactionRecoveryService.getLocalServer().getJTAMigratableTarget() != null && TransactionRecoveryService.getLocalServer().getJTAMigratableTarget().isStrictOwnershipCheck();
    }

    private static ServerTransactionManagerImpl getTM() {
        return (ServerTransactionManagerImpl)ServerTransactionManagerImpl.getTransactionManager();
    }

    private static boolean isLocalServerIncluded(ServerMBean[] serverMBeanArray) {
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBeanArray[i].getName().equals(TransactionRecoveryService.getLocalServerName())) continue;
            return true;
        }
        return false;
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private static final class DeploymentChangeListener
    implements PropertyChangeListener {
        final String serverName;

        DeploymentChangeListener(String string) {
            this.serverName = string;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block8: {
                if (propertyChangeEvent.getPropertyName().equals("ConstrainedCandidateServers")) {
                    boolean bl = TransactionRecoveryService.isLocalServerIncluded((ServerMBean[])propertyChangeEvent.getNewValue());
                    if (TxDebug.JTAMigration.isDebugEnabled()) {
                        TxDebug.JTAMigration.debug("Received deployment change notification for '" + this.serverName + "', localServerIncluded: " + bl);
                    }
                    if (bl) {
                        try {
                            TransactionRecoveryService.getOrCreate(TransactionRecoveryService.getServerConfigMBean(this.serverName));
                        }
                        catch (MigrationException migrationException) {
                            if (TxDebug.JTAMigration.isDebugEnabled()) {
                                TxDebug.JTAMigration.debug("Processing of deployment change notification for '" + this.serverName + "' failed", (Throwable)migrationException);
                            }
                            break block8;
                        }
                        catch (Exception exception) {
                            if (TxDebug.JTAMigration.isDebugEnabled()) {
                                TxDebug.JTAMigration.debug("Processing of deployment change notification for '" + this.serverName + "' failed", (Throwable)exception);
                            }
                            break block8;
                        }
                    }
                    TransactionRecoveryService.remove(this.serverName);
                }
            }
        }
    }

    private static class MigrateJTAAction
    implements PrivilegedExceptionAction {
        String migratableName;
        String serverName;
        boolean sourceUp;
        boolean destinationUp;

        MigrateJTAAction(String string, String string2, boolean bl, boolean bl2) {
            this.migratableName = string;
            this.serverName = string2;
            this.sourceUp = bl;
            this.destinationUp = bl2;
        }

        public Object run() throws Exception {
            JTAMigrationHandler.migrateJTA(this.migratableName, this.serverName, this.sourceUp, this.destinationUp);
            return null;
        }
    }

    private static final class FailBackRequest
    extends WorkAdapter {
        final String serverName;

        FailBackRequest(String string) {
            this.serverName = string;
        }

        public void run() {
            TransactionRecoveryService.failBack(this.serverName, false);
        }

        public String toString() {
            return "Recovery fail-back request for '" + this.serverName + "'";
        }
    }
}

