/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import javax.transaction.xa.XAException;
import weblogic.health.HealthState;
import weblogic.management.MBeanCreationException;
import weblogic.management.ManagementException;
import weblogic.management.runtime.TransactionResourceRuntimeMBean;
import weblogic.transaction.internal.HealthEvent;
import weblogic.transaction.internal.JTARuntimeImpl;
import weblogic.transaction.internal.JTAStatisticsImpl;
import weblogic.transaction.internal.ServerResourceInfo;
import weblogic.transaction.internal.TransactionResourceRuntime;

public final class TransactionResourceRuntimeImpl
extends JTAStatisticsImpl
implements TransactionResourceRuntimeMBean,
TransactionResourceRuntime {
    private static final long serialVersionUID = -2736453126861335594L;
    private JTARuntimeImpl jtaRuntime;
    private String resourceName;
    protected long transactionCommittedTotalCount;
    protected long transactionRolledBackTotalCount;
    protected long transactionHeuristicCommitTotalCount;
    protected long transactionHeuristicRollbackTotalCount;
    protected long transactionHeuristicMixedTotalCount;
    protected long transactionHeuristicHazardTotalCount;
    private boolean healthy;
    private HealthState healthState;

    public TransactionResourceRuntimeImpl(String string, JTARuntimeImpl jTARuntimeImpl) throws MBeanCreationException, ManagementException {
        super(string, jTARuntimeImpl);
        jTARuntimeImpl.addTransactionResourceRuntimeMBean(this);
        this.jtaRuntime = jTARuntimeImpl;
        this.resourceName = string;
        this.healthy = true;
        this.healthState = new HealthState(0);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public HealthState getHealthState() {
        return this.healthState;
    }

    public void tallyCompletion(ServerResourceInfo serverResourceInfo, XAException xAException) {
        if (xAException != null) {
            switch (xAException.errorCode) {
                case 7: {
                    this.tallyHeuristicCommitCompletion();
                    break;
                }
                case 6: {
                    this.tallyHeuristicRollbackCompletion();
                    break;
                }
                case 8: {
                    this.tallyHeuristicHazardCompletion();
                    break;
                }
                case 5: {
                    this.tallyHeuristicMixedCompletion();
                }
            }
        }
        if (serverResourceInfo.isCommitted()) {
            ++this.transactionCommittedTotalCount;
        } else if (serverResourceInfo.isRolledBack()) {
            ++this.transactionRolledBackTotalCount;
        }
    }

    public void setHealthy(boolean bl) {
        if (this.healthy == bl) {
            return;
        }
        HealthState healthState = this.healthState;
        String[] stringArray = new String[1];
        this.healthy = bl;
        HealthEvent healthEvent = null;
        if (!bl) {
            stringArray[0] = "Resource " + this.resourceName + " declared unhealthy";
            this.healthState = new HealthState(3, stringArray);
            healthEvent = new HealthEvent(5, this.resourceName, stringArray[0]);
        } else {
            stringArray[0] = "Resource " + this.resourceName + " declared healthy";
            this.healthState = new HealthState(0, stringArray);
            healthEvent = new HealthEvent(6, this.resourceName, stringArray[0]);
        }
        this.jtaRuntime.healthEvent(healthEvent);
    }

    public void tallyHeuristicCommitCompletion() {
        ++this.transactionHeuristicCommitTotalCount;
    }

    public void tallyHeuristicRollbackCompletion() {
        ++this.transactionHeuristicRollbackTotalCount;
    }

    public void tallyHeuristicMixedCompletion() {
        ++this.transactionHeuristicMixedTotalCount;
    }

    public void tallyHeuristicHazardCompletion() {
        ++this.transactionHeuristicHazardTotalCount;
    }

    public long getTransactionTotalCount() {
        return this.getTransactionCommittedTotalCount() + this.getTransactionRolledBackTotalCount();
    }

    public long getTransactionCommittedTotalCount() {
        return this.transactionCommittedTotalCount;
    }

    public long getTransactionRolledBackTotalCount() {
        return this.transactionRolledBackTotalCount;
    }

    public long getTransactionHeuristicsTotalCount() {
        return this.getTransactionHeuristicCommitTotalCount() + this.getTransactionHeuristicRollbackTotalCount() + this.getTransactionHeuristicMixedTotalCount() + this.getTransactionHeuristicHazardTotalCount();
    }

    public long getTransactionHeuristicCommitTotalCount() {
        return this.transactionHeuristicCommitTotalCount;
    }

    public long getTransactionHeuristicRollbackTotalCount() {
        return this.transactionHeuristicRollbackTotalCount;
    }

    public long getTransactionHeuristicMixedTotalCount() {
        return this.transactionHeuristicMixedTotalCount;
    }

    public long getTransactionHeuristicHazardTotalCount() {
        return this.transactionHeuristicHazardTotalCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{");
        stringBuffer.append("resourceName=").append(this.resourceName);
        stringBuffer.append(",");
        stringBuffer.append("transactionHeuristicCommitTotalCount=").append(this.getTransactionHeuristicCommitTotalCount());
        stringBuffer.append(",");
        stringBuffer.append("transactionHeuristicRollbackTotalCount=").append(this.getTransactionHeuristicRollbackTotalCount());
        stringBuffer.append(",");
        stringBuffer.append("transactionHeuristicMixedTotalCount=").append(this.getTransactionHeuristicMixedTotalCount());
        stringBuffer.append(",");
        stringBuffer.append("transactionHeuristicHazardTotalCount=").append(this.getTransactionHeuristicHazardTotalCount());
        stringBuffer.append(",");
        stringBuffer.append(super.toString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

