/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.image.ImageSource;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.internal.ClientTransactionManagerImpl;
import weblogic.transaction.internal.Constants;
import weblogic.transaction.internal.Coordinator;
import weblogic.transaction.internal.CoordinatorDescriptor;
import weblogic.transaction.internal.CoordinatorImpl;
import weblogic.transaction.internal.JNDIAdvertiser;
import weblogic.transaction.internal.JTAConfig;
import weblogic.transaction.internal.JTAConfigImpl;
import weblogic.transaction.internal.JTADiagnosticImageSource;
import weblogic.transaction.internal.JTARuntime;
import weblogic.transaction.internal.JTARuntimeImpl;
import weblogic.transaction.internal.PlatformHelper;
import weblogic.transaction.internal.ProcessManager;
import weblogic.transaction.internal.ProcessManagerImpl;
import weblogic.transaction.internal.ServerCoordinatorDescriptorManager;
import weblogic.transaction.internal.ServerTransactionManagerImpl;
import weblogic.transaction.internal.TXLogger;
import weblogic.transaction.internal.TransactionHelperImpl;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.TransactionManagerImpl;
import weblogic.transaction.internal.TransactionRecoveryService;
import weblogic.transaction.internal.TxDebug;
import weblogic.transaction.internal.WLSTimer;
import weblogic.work.WorkManagerFactory;

public class TransactionService
extends AbstractServerService
implements Constants {
    private static ClientTransactionManagerImpl ctm = null;
    public static final int FORCE_SUSPENDING = 1004;
    private static int state = 0;
    private static Object stateLock = new String("LifecycleState");
    private static Object suspendLock = new String("LifecycleSuspend");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static TransactionService singleton = null;

    private void initialize() throws ServiceFailureException {
        if (this.initStateTimerAndTxHelper()) {
            return;
        }
        if (ctm == null) {
            this.initTM();
        }
        this.initCheckTimerRegisterWithHealthServiceAndSetState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean initStateTimerAndTxHelper() {
        Object object = stateLock;
        synchronized (object) {
            if (state != 0) {
                return true;
            }
            state = 1;
        }
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("INITIALIZING ...");
        }
        WLSTimer.initialize();
        TransactionService.initializeEarly();
        return false;
    }

    private void initTM() throws ServiceFailureException {
        JTAMBean jTAMBean = this.initJNDIConfigMBeanAndTM();
        this.initJTACoordinatorWM();
        this.initCoordinatorAndSetTxTimeoutThread(jTAMBean);
    }

    JTAMBean initJNDIConfigMBeanAndTM() throws ServiceFailureException {
        try {
            JNDIAdvertiser.initialize((String)TransactionService.getServerName());
        }
        catch (NamingException namingException) {
            throw new ServiceFailureException((Throwable)namingException);
        }
        JTAMBean jTAMBean = TransactionService.getConfiguration();
        ctm = TransactionService.createTransactionManager(jTAMBean);
        return jTAMBean;
    }

    void initJTACoordinatorWM() {
        WorkManagerFactory.getInstance().findOrCreate("JTACoordinatorWM", 100, 3, -1);
        WorkManagerFactory.getInstance().findOrCreate("OneWayJTACoordinatorWM", 100, 3, -1);
    }

    void initCoordinatorAndSetTxTimeoutThread(JTAMBean jTAMBean) throws ServiceFailureException {
        TransactionService.createCoordinator(ctm);
        TransactionService.setTransactionTimeoutMainThread(jTAMBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initCheckTimerRegisterWithHealthServiceAndSetState() throws ServiceFailureException {
        if (!ctm.isTimerStarted()) {
            throw new ServiceFailureException("JTA Timer did not start: ", ctm.getTimerFailureReason());
        }
        ((JTARuntimeImpl)TransactionService.getTM().getRuntime()).registerWithHealthService();
        Object object = stateLock;
        synchronized (object) {
            if (state == 1) {
                state = 3;
            }
        }
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("INITIALIZING DONE");
        }
    }

    public void start() throws ServiceFailureException {
        this.initialize();
        this.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("RESUMING ...");
        }
        Object object = stateLock;
        synchronized (object) {
            if (state != 3) {
                if (TxDebug.JTALifecycle.isDebugEnabled()) {
                    TxDebug.JTALifecycle.debug("Skip resuming, state:" + state);
                }
                return;
            }
            state = 6;
        }
        TransactionImpl.setAbandonGraceTimeEndSec((int)((int)(System.currentTimeMillis() / 1000L) + 600));
        object = stateLock;
        synchronized (object) {
            if (state == 6) {
                state = 2;
            }
        }
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("RESUMING DONE");
        }
    }

    public static void initializeEarly() {
        TransactionHelper.setTransactionHelper((TransactionHelper)new TransactionHelperImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ServiceFailureException {
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("SUSPENDING ...");
        }
        Object object = stateLock;
        synchronized (object) {
            if (state != 2) {
                if (TxDebug.JTALifecycle.isDebugEnabled()) {
                    TxDebug.JTALifecycle.debug("Skip suspending, state:" + state);
                }
                return;
            }
            state = 4;
        }
        TransactionRecoveryService.forceSuspend();
        object = TransactionService.getTM();
        Object object2 = suspendLock;
        synchronized (object2) {
            try {
                if (!object.isTxMapEmpty()) {
                    suspendLock.wait();
                } else {
                    state = 3;
                }
            }
            catch (InterruptedException interruptedException) {
                Object object3 = stateLock;
                synchronized (object3) {
                    if (state == 3) {
                        if (TxDebug.JTALifecycle.isDebugEnabled()) {
                            TxDebug.JTALifecycle.debug("suspendSuccessfullyCompleted");
                        }
                    } else {
                        if (TxDebug.JTALifecycle.isDebugEnabled()) {
                            TxDebug.JTALifecycle.debug("suspendFailed");
                        }
                        throw new ServiceFailureException("TransactionService suspend failed");
                    }
                }
            }
            finally {
                Object object4 = stateLock;
                synchronized (object4) {
                    if (state == 3) {
                        if (TxDebug.JTALifecycle.isDebugEnabled()) {
                            TxDebug.JTALifecycle.debug("suspendSuccessfullyCompleted");
                        }
                    } else {
                        if (TxDebug.JTALifecycle.isDebugEnabled()) {
                            TxDebug.JTALifecycle.debug("suspendFailed");
                        }
                        throw new ServiceFailureException("TransactionService suspend failed");
                    }
                }
            }
        }
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("SUSPEND DONE");
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() throws ServiceFailureException {
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("FORCE SUSPENDING ...");
        }
        Object object = stateLock;
        synchronized (object) {
            if (state != 2 && state != 4) {
                if (TxDebug.JTALifecycle.isDebugEnabled()) {
                    TxDebug.JTALifecycle.debug("Skip force suspending, state:" + state);
                }
                return;
            }
            state = 1004;
        }
        TransactionService.performForceSuspend();
        object = stateLock;
        synchronized (object) {
            if (state == 1004) {
                state = 3;
            }
        }
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("FORCE SUSPEND DONE");
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws ServiceFailureException {
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("SHUTTING DOWN ...");
        }
        Object object = stateLock;
        synchronized (object) {
            if (state == 7 || state == 0) {
                if (TxDebug.JTALifecycle.isDebugEnabled()) {
                    TxDebug.JTALifecycle.debug("Skip shutdown, state:" + state);
                }
                return;
            }
            state = 7;
        }
        ((JTARuntimeImpl)TransactionService.getTM().getRuntime()).unregisterFromHealthService();
        object = stateLock;
        synchronized (object) {
            state = 0;
        }
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("SHUTDOWN DONE");
        }
    }

    static boolean isRunning() {
        return state == 2;
    }

    static boolean isSuspending() {
        return state == 4;
    }

    static boolean isForceSuspending() {
        return state == 1004;
    }

    static boolean isShuttingDown() {
        return state == 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void suspendDone() {
        Object object = suspendLock;
        synchronized (object) {
            if (state == 4) {
                state = 3;
            }
            suspendLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performForceSuspend() {
        if (TxDebug.JTALifecycle.isDebugEnabled()) {
            TxDebug.JTALifecycle.debug("Performing forceSuspend ...");
        }
        Object object = suspendLock;
        synchronized (object) {
            suspendLock.notify();
        }
        TransactionRecoveryService.forceSuspend();
        TransactionService.getTM().dropAllTransactions();
    }

    private static ClientTransactionManagerImpl createTransactionManager(JTAMBean jTAMBean) throws ServiceFailureException {
        ServerTransactionManagerImpl serverTransactionManagerImpl = new ServerTransactionManagerImpl((JTAConfig)new JTAConfigImpl(jTAMBean), TransactionService.getServerName());
        serverTransactionManagerImpl.setLocalCoordinatorDescriptor(TransactionService.getLocalCoordinatorDescriptor());
        serverTransactionManagerImpl.setProcessManager((ProcessManager)new ProcessManagerImpl());
        try {
            serverTransactionManagerImpl.setJTARuntime((JTARuntime)new JTARuntimeImpl("JTARuntime", serverTransactionManagerImpl));
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException((Throwable)managementException);
        }
        ImageManager imageManager = ImageManager.getInstance();
        imageManager.registerImageSource("JTA", (ImageSource)new JTADiagnosticImageSource(serverTransactionManagerImpl));
        ctm = new ClientTransactionManagerImpl();
        ctm.setCoordinatorURL(TransactionService.getLocalCoordinatorURL());
        ctm.setAbandonTimeoutSeconds(jTAMBean.getAbandonTimeoutSeconds());
        ctm.setDefaultTimeoutSeconds(jTAMBean.getTimeoutSeconds());
        ClientTransactionManagerImpl.initialized = true;
        JNDIAdvertiser.advertiseTransactionManager((TransactionManager)ctm);
        JNDIAdvertiser.advertiseUserTransaction((UserTransaction)ctm);
        JNDIAdvertiser.advertiseTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)ctm);
        return ctm;
    }

    private static void setTransactionTimeoutMainThread(JTAMBean jTAMBean) throws ServiceFailureException {
        try {
            TransactionHelper transactionHelper = TransactionHelper.getTransactionHelper();
            ClientTransactionManager clientTransactionManager = transactionHelper.getTransactionManager();
            clientTransactionManager.setTransactionTimeout(jTAMBean.getTimeoutSeconds());
        }
        catch (SystemException systemException) {
            throw new ServiceFailureException("Setting transaction timeout " + (Object)((Object)systemException));
        }
    }

    private static String getServerName() {
        return ManagementService.getRuntimeAccess(kernelId).getServer().getName();
    }

    private static CoordinatorImpl createCoordinator(ClientTransactionManagerImpl clientTransactionManagerImpl) throws ServiceFailureException {
        CoordinatorImpl coordinatorImpl = new CoordinatorImpl();
        clientTransactionManagerImpl.setCoordinator((Object)coordinatorImpl);
        TransactionService.getTM().setLocalCoordinator((Coordinator)coordinatorImpl);
        try {
            Context context = JNDIAdvertiser.getServerContext();
            context.bind(JNDIAdvertiser.getServerName(), (Object)clientTransactionManagerImpl);
            ServerHelper.exportObject((Remote)((Remote)clientTransactionManagerImpl.getCoordinator()));
        }
        catch (NamingException namingException) {
            TXLogger.logAdvertiseCoordinatorError((Throwable)namingException);
            throw new ServiceFailureException((Throwable)namingException);
        }
        catch (RemoteException remoteException) {
            TXLogger.logExportCoordinatorObjIDError((Throwable)remoteException);
            throw new ServiceFailureException((Throwable)remoteException);
        }
        return coordinatorImpl;
    }

    private static JTAMBean getConfiguration() throws ServiceFailureException {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        JTAMBean jTAMBean = domainMBean.getJTA();
        if (jTAMBean == null) {
            throw new ServiceFailureException("Unable to obtain configuration for transaction service");
        }
        return jTAMBean;
    }

    private static CoordinatorDescriptor getLocalCoordinatorDescriptor() throws ServiceFailureException {
        try {
            return ((ServerCoordinatorDescriptorManager)PlatformHelper.getPlatformHelper().getCoordinatorDescriptorManager()).getLocalCoordinatorDescriptor();
        }
        catch (Exception exception) {
            throw new ServiceFailureException("Transaction service startup failure", (Throwable)exception);
        }
    }

    private static String getLocalCoordinatorURL() throws ServiceFailureException {
        try {
            return ((ServerCoordinatorDescriptorManager)PlatformHelper.getPlatformHelper().getCoordinatorDescriptorManager()).getLocalCoordinatorURL();
        }
        catch (Exception exception) {
            throw new ServiceFailureException("Transaction service startup failure", (Throwable)exception);
        }
    }

    private static ServerTransactionManagerImpl getTM() {
        return (ServerTransactionManagerImpl)TransactionManagerImpl.getTransactionManager();
    }

    public TransactionService() {
        singleton = this;
    }

    public static TransactionService getTransactionService() {
        return singleton;
    }

    public String getName() {
        return "Transaction Service";
    }

    public String getVersion() {
        return "JTA 1.1";
    }
}

