/*
 * Decompiled with CFR 0.152.
 */
package weblogic.uddi.client.serialize.dom;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.uddi.client.serialize.dom.AddressLineDOMBinder;
import weblogic.uddi.client.structures.datatypes.Address;
import weblogic.uddi.client.structures.datatypes.AddressLine;

public class AddressDOMBinder {
    public static Address fromDOM(Element element) {
        Address address = new Address();
        if (element.hasAttribute("useType")) {
            address.setUseType(element.getAttribute("useType"));
        }
        if (element.hasAttribute("sortCode")) {
            address.setSortCode(element.getAttribute("sortCode"));
        }
        Vector<AddressLine> vector = new Vector<AddressLine>();
        NodeList nodeList = element.getElementsByTagName("addressLine");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            vector.add(AddressLineDOMBinder.fromDOM((Element)nodeList.item(i)));
        }
        address.setAddressLineVector(vector);
        return address;
    }

    public static Element toDOM(Address address, Document document) {
        Element element = document.createElement("address");
        if (address.getUseType() != null) {
            element.setAttribute("useType", address.getUseType());
        }
        if (address.getSortCode() != null) {
            element.setAttribute("sortCode", address.getSortCode());
        }
        Vector vector = address.getAddressLineVector();
        for (int i = 0; i < vector.size(); ++i) {
            element.appendChild(AddressLineDOMBinder.toDOM((AddressLine)vector.elementAt(i), document));
        }
        return element;
    }
}

