/*
 * Decompiled with CFR 0.152.
 */
package weblogic.uddi.client.serialize.dom;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.uddi.client.serialize.dom.AccessPointDOMBinder;
import weblogic.uddi.client.serialize.dom.DescriptionDOMBinder;
import weblogic.uddi.client.serialize.dom.HostingRedirectorDOMBinder;
import weblogic.uddi.client.serialize.dom.TModelInstanceDetailsDOMBinder;
import weblogic.uddi.client.structures.datatypes.BindingTemplate;
import weblogic.uddi.client.structures.datatypes.Description;

public class BindingTemplateDOMBinder {
    public static BindingTemplate fromDOM(Element element) {
        BindingTemplate bindingTemplate = new BindingTemplate();
        if (element.hasAttribute("bindingKey")) {
            bindingTemplate.setBindingKey(element.getAttribute("bindingKey"));
        }
        if (element.hasAttribute("serviceKey")) {
            bindingTemplate.setServiceKey(element.getAttribute("serviceKey"));
        }
        Vector<Description> vector = new Vector<Description>();
        NodeList nodeList = element.getElementsByTagName("description");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (!((Element)nodeList.item(i)).getParentNode().equals(element)) continue;
            vector.add(DescriptionDOMBinder.fromDOM((Element)nodeList.item(i)));
        }
        bindingTemplate.setDescriptionVector(vector);
        nodeList = element.getElementsByTagName("accessPoint");
        if (nodeList.getLength() > 0) {
            bindingTemplate.setAccessPoint(AccessPointDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("hostingRedirector")).getLength() > 0) {
            bindingTemplate.setHostingRedirector(HostingRedirectorDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("tModelInstanceDetails")).getLength() > 0) {
            bindingTemplate.setTModelInstanceDetails(TModelInstanceDetailsDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        return bindingTemplate;
    }

    public static Element toDOM(BindingTemplate bindingTemplate, Document document) {
        Element element = document.createElement("bindingTemplate");
        if (bindingTemplate.getBindingKey() != null) {
            element.setAttribute("bindingKey", bindingTemplate.getBindingKey());
        }
        if (bindingTemplate.getServiceKey() != null) {
            element.setAttribute("serviceKey", bindingTemplate.getServiceKey());
        }
        Vector vector = bindingTemplate.getDescriptionVector();
        for (int i = 0; i < vector.size(); ++i) {
            element.appendChild(DescriptionDOMBinder.toDOM((Description)vector.elementAt(i), document));
        }
        if (bindingTemplate.getAccessPoint() != null) {
            element.appendChild(AccessPointDOMBinder.toDOM(bindingTemplate.getAccessPoint(), document));
        }
        if (bindingTemplate.getHostingRedirector() != null) {
            element.appendChild(HostingRedirectorDOMBinder.toDOM(bindingTemplate.getHostingRedirector(), document));
        }
        if (bindingTemplate.getTModelInstanceDetails() != null) {
            element.appendChild(TModelInstanceDetailsDOMBinder.toDOM(bindingTemplate.getTModelInstanceDetails(), document));
        }
        return element;
    }
}

