/*
 * Decompiled with CFR 0.152.
 */
package weblogic.uddi.client.serialize.dom;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.uddi.client.serialize.dom.BusinessServicesDOMBinder;
import weblogic.uddi.client.serialize.dom.CategoryBagDOMBinder;
import weblogic.uddi.client.serialize.dom.ContactsDOMBinder;
import weblogic.uddi.client.serialize.dom.DescriptionDOMBinder;
import weblogic.uddi.client.serialize.dom.DiscoveryURLsDOMBinder;
import weblogic.uddi.client.serialize.dom.IdentifierBagDOMBinder;
import weblogic.uddi.client.serialize.dom.NameDOMBinder;
import weblogic.uddi.client.structures.datatypes.BusinessEntity;
import weblogic.uddi.client.structures.datatypes.Description;

public class BusinessEntityDOMBinder {
    public static BusinessEntity fromDOM(Element element) {
        int n;
        NodeList nodeList;
        BusinessEntity businessEntity = new BusinessEntity();
        if (element.hasAttribute("businessKey")) {
            businessEntity.setBusinessKey(element.getAttribute("businessKey"));
        }
        if (element.hasAttribute("operator")) {
            businessEntity.setOperator(element.getAttribute("operator"));
        }
        if (element.hasAttribute("authorizedName")) {
            businessEntity.setAuthorizedName(element.getAttribute("authorizedName"));
        }
        if ((nodeList = element.getElementsByTagName("discoveryURLs")).getLength() > 0) {
            businessEntity.setDiscoveryURLs(DiscoveryURLsDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("name")).getLength() > 0) {
            businessEntity.setName(NameDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        Vector<Description> vector = new Vector<Description>();
        nodeList = element.getElementsByTagName("description");
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            if (!((Element)nodeList.item(n)).getParentNode().equals(element)) continue;
            vector.add(DescriptionDOMBinder.fromDOM((Element)nodeList.item(n)));
        }
        businessEntity.setDescriptionVector(vector);
        nodeList = element.getElementsByTagName("contacts");
        if (nodeList.getLength() > 0) {
            businessEntity.setContacts(ContactsDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("businessServices")).getLength() > 0) {
            businessEntity.setBusinessServices(BusinessServicesDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("identifierBag")).getLength() > 0) {
            businessEntity.setIdentifierBag(IdentifierBagDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        nodeList = element.getElementsByTagName("categoryBag");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            if (!((Element)nodeList.item(n)).getParentNode().equals(element)) continue;
            businessEntity.setCategoryBag(CategoryBagDOMBinder.fromDOM((Element)nodeList.item(n)));
            break;
        }
        return businessEntity;
    }

    public static Element toDOM(BusinessEntity businessEntity, Document document) {
        Element element = document.createElement("businessEntity");
        if (businessEntity.getBusinessKey() != null) {
            element.setAttribute("businessKey", businessEntity.getBusinessKey());
        }
        if (businessEntity.getOperator() != null) {
            element.setAttribute("operator", businessEntity.getOperator());
        }
        if (businessEntity.getAuthorizedName() != null) {
            element.setAttribute("authorizedName", businessEntity.getAuthorizedName());
        }
        if (businessEntity.getDiscoveryURLs() != null) {
            element.appendChild(DiscoveryURLsDOMBinder.toDOM(businessEntity.getDiscoveryURLs(), document));
        }
        if (businessEntity.getName() != null) {
            element.appendChild(NameDOMBinder.toDOM(businessEntity.getName(), document));
        }
        Vector vector = businessEntity.getDescriptionVector();
        for (int i = 0; i < vector.size(); ++i) {
            element.appendChild(DescriptionDOMBinder.toDOM((Description)vector.elementAt(i), document));
        }
        if (businessEntity.getContacts() != null) {
            element.appendChild(ContactsDOMBinder.toDOM(businessEntity.getContacts(), document));
        }
        if (businessEntity.getBusinessServices() != null) {
            element.appendChild(BusinessServicesDOMBinder.toDOM(businessEntity.getBusinessServices(), document));
        }
        if (businessEntity.getIdentifierBag() != null) {
            element.appendChild(IdentifierBagDOMBinder.toDOM(businessEntity.getIdentifierBag(), document));
        }
        if (businessEntity.getCategoryBag() != null) {
            element.appendChild(CategoryBagDOMBinder.toDOM(businessEntity.getCategoryBag(), document));
        }
        return element;
    }
}

