/*
 * Decompiled with CFR 0.152.
 */
package weblogic.uddi.client.serialize.dom;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.uddi.client.serialize.dom.DescriptionDOMBinder;
import weblogic.uddi.client.serialize.dom.NameDOMBinder;
import weblogic.uddi.client.serialize.dom.ServiceInfosDOMBinder;
import weblogic.uddi.client.structures.datatypes.BusinessInfo;
import weblogic.uddi.client.structures.datatypes.Description;

public class BusinessInfoDOMBinder {
    public static BusinessInfo fromDOM(Element element) {
        NodeList nodeList;
        BusinessInfo businessInfo = new BusinessInfo();
        if (element.hasAttribute("businessKey")) {
            businessInfo.setBusinessKey(element.getAttribute("businessKey"));
        }
        if ((nodeList = element.getElementsByTagName("name")).getLength() > 0) {
            businessInfo.setName(NameDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        Vector<Description> vector = new Vector<Description>();
        nodeList = element.getElementsByTagName("description");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (!((Element)nodeList.item(i)).getParentNode().equals(element)) continue;
            vector.add(DescriptionDOMBinder.fromDOM((Element)nodeList.item(i)));
        }
        businessInfo.setDescriptionVector(vector);
        nodeList = element.getElementsByTagName("serviceInfos");
        if (nodeList.getLength() > 0) {
            businessInfo.setServiceInfos(ServiceInfosDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        return businessInfo;
    }

    public static Element toDOM(BusinessInfo businessInfo, Document document) {
        Element element = document.createElement("businessInfo");
        if (businessInfo.getBusinessKey() != null) {
            element.setAttribute("businessKey", businessInfo.getBusinessKey());
        }
        if (businessInfo.getName() != null) {
            element.appendChild(NameDOMBinder.toDOM(businessInfo.getName(), document));
        }
        Vector vector = businessInfo.getDescriptionVector();
        for (int i = 0; i < vector.size(); ++i) {
            element.appendChild(DescriptionDOMBinder.toDOM((Description)vector.elementAt(i), document));
        }
        if (businessInfo.getServiceInfos() != null) {
            element.appendChild(ServiceInfosDOMBinder.toDOM(businessInfo.getServiceInfos(), document));
        }
        return element;
    }
}

