/*
 * Decompiled with CFR 0.152.
 */
package weblogic.uddi.client.serialize.dom;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.uddi.client.serialize.dom.BindingTemplatesDOMBinder;
import weblogic.uddi.client.serialize.dom.CategoryBagDOMBinder;
import weblogic.uddi.client.serialize.dom.DescriptionDOMBinder;
import weblogic.uddi.client.serialize.dom.NameDOMBinder;
import weblogic.uddi.client.structures.datatypes.BusinessService;
import weblogic.uddi.client.structures.datatypes.Description;

public class BusinessServiceDOMBinder {
    public static BusinessService fromDOM(Element element) {
        NodeList nodeList;
        BusinessService businessService = new BusinessService();
        if (element.hasAttribute("businessKey")) {
            businessService.setBusinessKey(element.getAttribute("businessKey"));
        }
        if (element.hasAttribute("serviceKey")) {
            businessService.setServiceKey(element.getAttribute("serviceKey"));
        }
        if ((nodeList = element.getElementsByTagName("name")).getLength() > 0) {
            businessService.setName(NameDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        Vector<Description> vector = new Vector<Description>();
        nodeList = element.getElementsByTagName("description");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (!((Element)nodeList.item(i)).getParentNode().equals(element)) continue;
            vector.add(DescriptionDOMBinder.fromDOM((Element)nodeList.item(i)));
        }
        businessService.setDescriptionVector(vector);
        nodeList = element.getElementsByTagName("bindingTemplates");
        if (nodeList.getLength() > 0) {
            businessService.setBindingTemplates(BindingTemplatesDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("categoryBag")).getLength() > 0) {
            businessService.setCategoryBag(CategoryBagDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        return businessService;
    }

    public static Element toDOM(BusinessService businessService, Document document) {
        Element element = document.createElement("businessService");
        if (businessService.getBusinessKey() != null) {
            element.setAttribute("businessKey", businessService.getBusinessKey());
        }
        if (businessService.getServiceKey() != null) {
            element.setAttribute("serviceKey", businessService.getServiceKey());
        }
        if (businessService.getName() != null) {
            element.appendChild(NameDOMBinder.toDOM(businessService.getName(), document));
        }
        Vector vector = businessService.getDescriptionVector();
        for (int i = 0; i < vector.size(); ++i) {
            element.appendChild(DescriptionDOMBinder.toDOM((Description)vector.elementAt(i), document));
        }
        if (businessService.getBindingTemplates() != null) {
            element.appendChild(BindingTemplatesDOMBinder.toDOM(businessService.getBindingTemplates(), document));
        }
        if (businessService.getCategoryBag() != null) {
            element.appendChild(CategoryBagDOMBinder.toDOM(businessService.getCategoryBag(), document));
        }
        return element;
    }
}

