/*
 * Decompiled with CFR 0.152.
 */
package weblogic.uddi.client.serialize.dom;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.uddi.client.serialize.dom.AddressDOMBinder;
import weblogic.uddi.client.serialize.dom.DescriptionDOMBinder;
import weblogic.uddi.client.serialize.dom.EmailDOMBinder;
import weblogic.uddi.client.serialize.dom.PersonNameDOMBinder;
import weblogic.uddi.client.serialize.dom.PhoneDOMBinder;
import weblogic.uddi.client.structures.datatypes.Address;
import weblogic.uddi.client.structures.datatypes.Contact;
import weblogic.uddi.client.structures.datatypes.Description;
import weblogic.uddi.client.structures.datatypes.Email;
import weblogic.uddi.client.structures.datatypes.Phone;

public class ContactDOMBinder {
    public static Contact fromDOM(Element element) {
        Contact contact = new Contact();
        if (element.hasAttribute("useType")) {
            contact.setUseType(element.getAttribute("useType"));
        }
        Vector<Description> vector = new Vector<Description>();
        NodeList nodeList = element.getElementsByTagName("description");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (!((Element)nodeList.item(i)).getParentNode().equals(element)) continue;
            vector.add(DescriptionDOMBinder.fromDOM((Element)nodeList.item(i)));
        }
        contact.setDescriptionVector(vector);
        nodeList = element.getElementsByTagName("personName");
        if (nodeList.getLength() > 0) {
            contact.setPersonName(PersonNameDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        Vector<Phone> vector2 = new Vector<Phone>();
        nodeList = element.getElementsByTagName("phone");
        n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            vector2.add(PhoneDOMBinder.fromDOM((Element)nodeList.item(i)));
        }
        contact.setPhoneVector(vector2);
        Vector<Email> vector3 = new Vector<Email>();
        nodeList = element.getElementsByTagName("email");
        n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            vector3.add(EmailDOMBinder.fromDOM((Element)nodeList.item(i)));
        }
        contact.setEmailVector(vector3);
        Vector<Address> vector4 = new Vector<Address>();
        nodeList = element.getElementsByTagName("address");
        n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            vector4.add(AddressDOMBinder.fromDOM((Element)nodeList.item(i)));
        }
        contact.setAddressVector(vector4);
        return contact;
    }

    public static Element toDOM(Contact contact, Document document) {
        Element element = document.createElement("contact");
        if (contact.getUseType() != null) {
            element.setAttribute("useType", contact.getUseType());
        }
        Vector vector = contact.getDescriptionVector();
        for (int i = 0; i < vector.size(); ++i) {
            element.appendChild(DescriptionDOMBinder.toDOM((Description)vector.elementAt(i), document));
        }
        if (contact.getPersonName() != null) {
            element.appendChild(PersonNameDOMBinder.toDOM(contact.getPersonName(), document));
        }
        Vector vector2 = contact.getPhoneVector();
        for (int i = 0; i < vector2.size(); ++i) {
            element.appendChild(PhoneDOMBinder.toDOM((Phone)vector2.elementAt(i), document));
        }
        Vector vector3 = contact.getEmailVector();
        for (int i = 0; i < vector3.size(); ++i) {
            element.appendChild(EmailDOMBinder.toDOM((Email)vector3.elementAt(i), document));
        }
        Vector vector4 = contact.getAddressVector();
        for (int i = 0; i < vector4.size(); ++i) {
            element.appendChild(AddressDOMBinder.toDOM((Address)vector4.elementAt(i), document));
        }
        return element;
    }
}

