/*
 * Decompiled with CFR 0.152.
 */
package weblogic.uddi.client.serialize.dom;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.uddi.client.serialize.dom.DescriptionDOMBinder;
import weblogic.uddi.client.serialize.dom.InstanceParmsDOMBinder;
import weblogic.uddi.client.serialize.dom.OverviewDocDOMBinder;
import weblogic.uddi.client.structures.datatypes.Description;
import weblogic.uddi.client.structures.datatypes.InstanceDetails;

public class InstanceDetailsDOMBinder {
    public static InstanceDetails fromDOM(Element element) {
        InstanceDetails instanceDetails = new InstanceDetails();
        Vector<Description> vector = new Vector<Description>();
        NodeList nodeList = element.getElementsByTagName("description");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (!((Element)nodeList.item(i)).getParentNode().equals(element)) continue;
            vector.add(DescriptionDOMBinder.fromDOM((Element)nodeList.item(i)));
        }
        instanceDetails.setDescriptionVector(vector);
        nodeList = element.getElementsByTagName("overviewDoc");
        if (nodeList.getLength() > 0) {
            instanceDetails.setOverviewDoc(OverviewDocDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("instanceParms")).getLength() > 0) {
            instanceDetails.setInstanceParms(InstanceParmsDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        return instanceDetails;
    }

    public static Element toDOM(InstanceDetails instanceDetails, Document document) {
        Element element = document.createElement("instanceDetails");
        Vector vector = instanceDetails.getDescriptionVector();
        for (int i = 0; i < vector.size(); ++i) {
            element.appendChild(DescriptionDOMBinder.toDOM((Description)vector.elementAt(i), document));
        }
        if (instanceDetails.getOverviewDoc() != null) {
            element.appendChild(OverviewDocDOMBinder.toDOM(instanceDetails.getOverviewDoc(), document));
        }
        if (instanceDetails.getInstanceParms() != null) {
            element.appendChild(InstanceParmsDOMBinder.toDOM(instanceDetails.getInstanceParms(), document));
        }
        return element;
    }
}

