/*
 * Decompiled with CFR 0.152.
 */
package weblogic.uddi.client.serialize.dom;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.uddi.client.serialize.dom.CategoryBagDOMBinder;
import weblogic.uddi.client.serialize.dom.DescriptionDOMBinder;
import weblogic.uddi.client.serialize.dom.IdentifierBagDOMBinder;
import weblogic.uddi.client.serialize.dom.NameDOMBinder;
import weblogic.uddi.client.serialize.dom.OverviewDocDOMBinder;
import weblogic.uddi.client.structures.datatypes.Description;
import weblogic.uddi.client.structures.datatypes.TModel;

public class TModelDOMBinder {
    public static TModel fromDOM(Element element) {
        NodeList nodeList;
        TModel tModel = new TModel();
        if (element.hasAttribute("tModelKey")) {
            tModel.setTModelKey(element.getAttribute("tModelKey"));
        }
        if (element.hasAttribute("operator")) {
            tModel.setOperator(element.getAttribute("operator"));
        }
        if (element.hasAttribute("authorizedName")) {
            tModel.setAuthorizedName(element.getAttribute("authorizedName"));
        }
        if ((nodeList = element.getElementsByTagName("name")).getLength() > 0) {
            tModel.setName(NameDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        Vector<Description> vector = new Vector<Description>();
        nodeList = element.getElementsByTagName("description");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (!((Element)nodeList.item(i)).getParentNode().equals(element)) continue;
            vector.add(DescriptionDOMBinder.fromDOM((Element)nodeList.item(i)));
        }
        tModel.setDescriptionVector(vector);
        nodeList = element.getElementsByTagName("overviewDoc");
        if (nodeList.getLength() > 0) {
            tModel.setOverviewDoc(OverviewDocDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("identifierBag")).getLength() > 0) {
            tModel.setIdentifierBag(IdentifierBagDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("categoryBag")).getLength() > 0) {
            tModel.setCategoryBag(CategoryBagDOMBinder.fromDOM((Element)nodeList.item(0)));
        }
        return tModel;
    }

    public static Element toDOM(TModel tModel, Document document) {
        Element element = document.createElement("tModel");
        if (tModel.getTModelKey() != null) {
            element.setAttribute("tModelKey", tModel.getTModelKey());
        }
        if (tModel.getOperator() != null) {
            element.setAttribute("operator", tModel.getOperator());
        }
        if (tModel.getAuthorizedName() != null) {
            element.setAttribute("authorizedName", tModel.getAuthorizedName());
        }
        if (tModel.getName() != null) {
            element.appendChild(NameDOMBinder.toDOM(tModel.getName(), document));
        }
        Vector vector = tModel.getDescriptionVector();
        for (int i = 0; i < vector.size(); ++i) {
            element.appendChild(DescriptionDOMBinder.toDOM((Description)vector.elementAt(i), document));
        }
        if (tModel.getOverviewDoc() != null) {
            element.appendChild(OverviewDocDOMBinder.toDOM(tModel.getOverviewDoc(), document));
        }
        if (tModel.getIdentifierBag() != null) {
            element.appendChild(IdentifierBagDOMBinder.toDOM(tModel.getIdentifierBag(), document));
        }
        if (tModel.getCategoryBag() != null) {
            element.appendChild(CategoryBagDOMBinder.toDOM(tModel.getCategoryBag(), document));
        }
        return element;
    }
}

