/*
 * Decompiled with CFR 0.152.
 */
package weblogic.uddi.client.service;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.uddi.client.structures.exception.XML_SoapException;
import weblogic.webservice.binding.Binding;
import weblogic.webservice.binding.BindingFactory;
import weblogic.webservice.binding.BindingInfo;
import weblogic.webservice.core.DefaultMessageContext;
import weblogic.webservice.core.soap.SOAPTextElement;

public class UDDISoapMessage {
    private Element result = null;

    public Document createDOMDoc() throws XML_SoapException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XML_SoapException(parserConfigurationException.getMessage());
        }
    }

    public void sendMessage(Element element, String string) throws XML_SoapException {
        System.setProperty("javax.xml.soap.MessageFactory", "weblogic.webservice.core.soap.MessageFactoryImpl");
        try {
            DefaultMessageContext defaultMessageContext = new DefaultMessageContext();
            SOAPMessage sOAPMessage = defaultMessageContext.getMessage();
            MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
            mimeHeaders.addHeader("soapAction", "\"\"");
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            SOAPElement sOAPElement = sOAPBody.addChildElement(element.getTagName());
            this.populateSOAPElement(sOAPEnvelope, sOAPElement, element);
            BindingFactory bindingFactory = BindingFactory.getInstance();
            BindingInfo bindingInfo = new BindingInfo();
            bindingInfo.setAddress(string);
            Binding binding = bindingFactory.create(bindingInfo);
            binding.send((MessageContext)defaultMessageContext);
            binding.receive((MessageContext)defaultMessageContext);
            sOAPMessage = defaultMessageContext.getMessage();
            sOAPPart = sOAPMessage.getSOAPPart();
            sOAPEnvelope = sOAPPart.getEnvelope();
            sOAPBody = sOAPEnvelope.getBody();
            Iterator iterator = sOAPBody.getChildElements();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SOAPElement)) continue;
                SOAPElement sOAPElement2 = (SOAPElement)e;
                Document document = this.createDOMDoc();
                this.result = this.populateDOMElement(document, sOAPElement2);
                return;
            }
        }
        catch (SOAPException sOAPException) {
            throw new XML_SoapException(sOAPException.getMessage());
        }
        catch (IOException iOException) {
            throw new XML_SoapException(iOException.getMessage());
        }
    }

    public Element populateDOMElement(Document document, SOAPElement sOAPElement) throws XML_SoapException {
        String string;
        Iterator iterator;
        Element element = document.createElement(sOAPElement.getElementName().getLocalName());
        Iterator iterator2 = sOAPElement.getAllAttributes();
        while (iterator2.hasNext()) {
            iterator = (Name)iterator2.next();
            string = sOAPElement.getAttributeValue((Name)iterator);
            element.setAttribute(iterator.getLocalName(), string);
        }
        iterator = sOAPElement.getChildElements();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement2;
            string = iterator.next();
            if (string instanceof SOAPElement) {
                sOAPElement2 = (SOAPElement)string;
                Element element2 = this.populateDOMElement(document, sOAPElement2);
                element.appendChild(element2);
            }
            if (!(string instanceof SOAPTextElement)) continue;
            sOAPElement2 = (SOAPTextElement)string;
            element.appendChild(document.createTextNode(sOAPElement2.getText()));
        }
        return element;
    }

    public SOAPElement populateSOAPElement(SOAPEnvelope sOAPEnvelope, SOAPElement sOAPElement, Element element) throws SOAPException {
        int n;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            Node node = namedNodeMap.item(n);
            sOAPElement.addAttribute(sOAPEnvelope.createName(node.getNodeName()), element.getAttribute(node.getNodeName()));
        }
        NodeList nodeList = element.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            short s = nodeList.item(n).getNodeType();
            String string = "";
            if (nodeList.item(n).getNodeType() == 3) {
                sOAPElement.addTextNode(nodeList.item(n).getNodeValue());
            }
            if (nodeList.item(n).getNodeType() != 1) continue;
            SOAPElement sOAPElement2 = sOAPElement.addChildElement(((Element)nodeList.item(n)).getTagName());
            sOAPElement2 = this.populateSOAPElement(sOAPEnvelope, sOAPElement2, (Element)nodeList.item(n));
        }
        return sOAPElement;
    }

    public boolean isFault() {
        if (this.result != null) {
            String string = new String("Fault");
            String string2 = this.result.getTagName();
            int n = this.result.getTagName().indexOf(":");
            if (n == -1) {
                return string.equals(this.result.getTagName());
            }
            return string2.substring(n + 1, string2.length()).equals(string);
        }
        return false;
    }

    public Element getResult() {
        return this.result;
    }

    private void printXML(Element element, int n) {
        int n2;
        int n3;
        if (element == null) {
            return;
        }
        if (n == 0) {
            System.out.println("");
            System.out.println("");
        }
        for (n3 = 0; n3 < n; ++n3) {
            System.out.print("    ");
        }
        System.out.print("<" + element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
            System.out.println("");
            Node node = namedNodeMap.item(n2);
            for (n3 = 0; n3 < n; ++n3) {
                System.out.print("    ");
            }
            System.out.print("  " + node.getNodeName() + "=\"" + element.getAttribute(node.getNodeName()) + "\"");
        }
        System.out.println(">");
        NodeList nodeList = element.getChildNodes();
        String string = "";
        for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
            if (nodeList.item(n3).getNodeType() != 3) continue;
            string = string + nodeList.item(n3).getNodeValue();
        }
        if (!string.equals("")) {
            for (n3 = 0; n3 < n; ++n3) {
                System.out.print("    ");
            }
            System.out.println("    " + string.trim());
        }
        nodeList = element.getChildNodes();
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            if (nodeList.item(n2).getNodeType() != 1) continue;
            this.printXML((Element)nodeList.item(n2), n + 1);
        }
        for (n3 = 0; n3 < n; ++n3) {
            System.out.print("    ");
        }
        System.out.println("</" + element.getTagName() + ">");
        if (n == 0) {
            System.out.println("");
            System.out.println("");
        }
    }
}

