/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade;

import com.bea.plateng.plugin.helper.ExecutionPlanChoiceHelper;
import com.oracle.cie.common.ui.gui.SplashWindow;
import com.oracle.cie.wizard.WizardHelper;
import com.oracle.cie.wizard.WizardStatus;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import weblogic.upgrade.UpgradeHelper;

public class Main {
    public static final String REDIRECTED_OUTPUT_FILE_KEY = Main.class.getName() + ".REDIRECTED_OUTPUT_FILE_KEY";
    private static boolean DEBUG = true;
    private static int NO_SYSTEM_EXIT_CALLED = 1298493394;
    public static final int TTY = 4;
    public static final int GUI = 5;
    public static final int SILENT = 6;
    private String execplan = null;
    private String silentxmlfile = null;
    private String logfile = null;
    private String[] wizardparams = new String[0];
    private int mode = 5;
    private boolean isDomainUpgrade = false;
    private boolean debug = false;

    public Main() {
        this.setMode("gui");
        this.setType("domain");
    }

    public Main(String[] stringArray) {
        this.setMode("gui");
        boolean bl = this.showSplash(stringArray);
        this.setType("domain", bl);
    }

    private boolean showSplash(String[] stringArray) {
        String string = "gui";
        String string2 = "domain";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-mode")) {
                string = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-type")) continue;
            string2 = stringArray[++i];
        }
        return string.equalsIgnoreCase("GUI") && (string2.equalsIgnoreCase("domain") || string2.equalsIgnoreCase("wlsdomain"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(String string, boolean bl) {
        Window window = null;
        try {
            try {
                URL uRL;
                if (bl && (uRL = Main.class.getClassLoader().getResource("resources/upgrade/splash_upgradeWiz.gif")) != null) {
                    window = SplashWindow.splash((Image)Toolkit.getDefaultToolkit().createImage(uRL));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setType(string);
        }
        finally {
            if (window != null) {
                window.setVisible(false);
                window.dispose();
            }
        }
    }

    public void setSilentMode() {
        this.mode = 6;
    }

    public void setResponses(String string) {
        this.silentxmlfile = string;
        if ("-".equals(this.silentxmlfile)) {
            this.silentxmlfile = null;
        }
    }

    public void setType(String string) {
        this.isDomainUpgrade = false;
        if (string.equals("domain") || string.equals("wlsdomain")) {
            if (Main.resourceExists("weblogic-upgrade-domain-execplan.xml")) {
                this.setExecutionPlan("weblogic-upgrade-domain-execplan.xml");
            } else {
                this.setExecutionPlan(ExecutionPlanChoiceHelper.getUpgradeExecutionPlan());
                this.isDomainUpgrade = true;
            }
            if (Main.resourceExists("weblogic-upgrade-domain-responses.xml")) {
                this.setResponses("weblogic-upgrade-domain-responses.xml");
            } else {
                this.setResponses("weblogic/upgrade/domain/responses.xml");
            }
        } else if (string.equals("nodemanager")) {
            this.setExecutionPlan("weblogic/upgrade/nodemanager/execplan.xml");
            if (Main.resourceExists("weblogic-upgrade-nodemanager-responses.xml")) {
                this.setResponses("weblogic-upgrade-nodemanager-responses.xml");
            } else {
                this.setResponses("weblogic/upgrade/nodemanager/responses.xml");
            }
        } else if (string.equals("securityproviders") || string.equals("securityprovider")) {
            this.setExecutionPlan("weblogic/upgrade/upgradesecurityproviders/execplan.xml");
            if (Main.resourceExists("weblogic-upgrade-upgradesecurityproviders-responses.xml")) {
                this.setResponses("weblogic-upgrade-upgradesecurityproviders-responses.xml");
            } else {
                this.setResponses("weblogic/upgrade/upgradesecurityproviders/responses.xml");
            }
        } else {
            throw new InvalidMainException("Invalid -type parameter: Valid options are domain, nodemanager, securityproviders");
        }
    }

    public void setDebug() {
        this.debug = true;
    }

    public void setLogFile(String string) {
        this.logfile = string;
    }

    public void setMode(String string) {
        if (string.equals("gui")) {
            this.mode = 5;
        } else if (string.equals("silent")) {
            this.mode = 6;
        } else {
            throw new InvalidMainException("Invalid -mode parameter: Valid options are gui or silent");
        }
    }

    public void setExecutionPlan(String string) {
        this.execplan = string;
    }

    public void setExtraWizardParams(String[] stringArray) {
        this.wizardparams = stringArray;
        if (this.wizardparams == null) {
            this.wizardparams = new String[0];
        }
    }

    public int execute() throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.mode == 6) {
            arrayList.add("-mode=silent");
            arrayList.add("-file=wcf/plugin_silent_wizard.xml");
            if (this.silentxmlfile != null) {
                arrayList.add("-p:plugin:plugin.silent.response.file=" + this.silentxmlfile);
            }
        } else if (this.mode == 5) {
            arrayList.add("-mode=gui");
            arrayList.add("-file=wcf/plugin_gui_wizard.xml");
        }
        if (this.logfile != null) {
            arrayList.add("-log=" + this.logfile);
        } else {
            arrayList.add("-log=stdout");
        }
        if (this.debug) {
            arrayList.add("-log_priority=debug");
        }
        arrayList.add("-p:plugin:plugin.executionPlan.file=" + this.execplan);
        arrayList.add("-p:plugin:I18N_PLUGIN=weblogic/upgrade/i18n_upgrade");
        arrayList.add("-p:plugin:TARGET_VERSION=" + UpgradeHelper.getTargetVersion());
        if (this.wizardparams != null) {
            arrayList.addAll(Arrays.asList((Object[])this.wizardparams));
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        Main.log("Calling Wizard framework for upgrade: args2: " + arrayList);
        WizardStatus wizardStatus = WizardHelper.invokeWizardAndWait((String[])stringArray, null);
        int n = -1;
        if (wizardStatus != null) {
            n = wizardStatus.getExitCode();
        }
        return n;
    }

    public static int doMain(String[] stringArray) throws Exception {
        if (stringArray.length == 1 && (stringArray[0].equals("-usage") || stringArray[0].equals("-?") || stringArray[0].equals("-help") || stringArray[0].equals("-h"))) {
            Main.printHelp();
            return NO_SYSTEM_EXIT_CALLED;
        }
        Main main = new Main(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-mode")) {
                main.setMode(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-responses")) {
                main.setResponses(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                main.setDebug();
                continue;
            }
            if (stringArray[i].equals("-type")) {
                main.setType(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-out")) {
                main.setLogFile(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-plan")) {
                main.setExecutionPlan(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-wizardparams")) continue;
            String[] stringArray2 = new String[stringArray.length - ++i];
            System.arraycopy(stringArray, i, stringArray2, 0, stringArray2.length);
            main.setExtraWizardParams(stringArray2);
            break;
        }
        if (main.execplan == null) {
            System.out.println("No execution plan is specified. Please provide a type argument ('-type ...')");
            System.out.println("For usage information, type 'java weblogic.Upgrade -help'");
            return NO_SYSTEM_EXIT_CALLED;
        }
        if (main.isDomainUpgrade && main.mode == 6) {
            main.execplan = "weblogic/upgrade/domain/execplan.xml";
        }
        return main.execute();
    }

    private static void setSysProps() {
        if (System.getProperty("display.splash") == null) {
            System.setProperty("display.splash", "false");
        }
        if (System.getProperty("log4j.configuration") == null) {
            System.setProperty("log4j.configuration", "weblogic/upgrade/upgrade-log4j.properties");
        }
    }

    public static void main(String[] stringArray) {
        Main.setSysProps();
        int n = 0;
        try {
            n = Main.doMain(stringArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Invalid parameters entered");
            Main.printHelp();
            n = -1;
        }
        catch (InvalidMainException invalidMainException) {
            System.err.println("Invalid Input: " + invalidMainException.getMessage());
            Main.printHelp();
            n = -1;
        }
        catch (Throwable throwable) {
            System.err.println("Exception caught from Main.doMain(...): " + throwable);
            throwable.printStackTrace(System.err);
            n = -1;
        }
        if (n != NO_SYSTEM_EXIT_CALLED) {
            System.exit(n);
        }
    }

    public static Throwable getInnermostCause(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            return throwable;
        }
        return Main.getInnermostCause(throwable2);
    }

    public static void printHelp() {
        String string = System.getProperty("line.separator");
        String string2 = "Usage: java weblogic.Upgrade [options]" + string + "Options and arguments:" + string + " -help             : Show this usage message" + string + "                     Synonym is -? OR -h OR -usage" + string + " -type <type>      : Run a specific type of upgrade." + string + "                     This sets up the exec plan, silent responses file, etc" + string + "                     Type is one of domain OR nodemanager OR securityproviders" + string + "                     Default: domain" + string + " -mode <mode>      : Specifies the mode" + string + "                     Type is one of gui OR silent" + string + "                     Default: gui" + string + " -responses <file> : Specify the resource location of the XML file defining the responses." + string + "                     Use only with silent mode" + string + "                     Give a - if there is no response file" + string + " -out <file>       : Specify the file to send standard output and error to." + string + "                     if not specified, standard output and error is used" + string + "                   " + string + " NOTE:             : All options are optional " + string + " ---Examples--- " + string + "  -mode silent -type domain" + string + "                   : Run in silent mode, with no responses provided, " + string + "                     against execution plan for domain upgrade" + string + "  -mode gui -type domain" + string + "                   : Same as above, but run the GUI" + string + "";
        System.out.println(string2);
    }

    private static void log(Object object) {
        if (DEBUG) {
            if (object != null && object instanceof Throwable) {
                ((Throwable)object).printStackTrace();
            } else {
                System.out.println(object);
            }
        }
    }

    private static boolean resourceExists(String string) {
        boolean bl = false;
        URL uRL = Main.getCL().getResource(string);
        if (uRL != null) {
            bl = true;
        } else {
            File file = new File(string);
            if (file.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    private static ClassLoader getCL() {
        return Main.class.getClassLoader();
    }

    private static void redirectOutErr(String string) throws Exception {
        File file = new File(string);
        file.createNewFile();
        file = file.getAbsoluteFile().getCanonicalFile();
        System.setProperty(REDIRECTED_OUTPUT_FILE_KEY, file.getPath());
        FileOutputStream fileOutputStream = new FileOutputStream(string, true);
        final PrintStream printStream = new PrintStream(fileOutputStream);
        System.setOut(printStream);
        System.setErr(printStream);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    printStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private static class InvalidMainException
    extends IllegalArgumentException {
        public InvalidMainException(String string) {
            super(string);
        }
    }
}

