/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInMessageObservation;
import com.bea.plateng.plugin.PlugInObservation;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.ia.InputAdapter;
import java.io.File;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DomainMBean;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class PluginActionDelegate {
    private AbstractPlugIn plugIn;
    private PlugInMessageObservation msgObservation;
    private PlugInContext context;

    public String getName() {
        return this.getClass().getName();
    }

    public void initPlugIn(AbstractPlugIn abstractPlugIn) {
        this.plugIn = abstractPlugIn;
        this.msgObservation = new PlugInMessageObservation(this.plugIn.getName());
    }

    public void prepare(PlugInContext plugInContext) throws Exception {
        this.context = plugInContext;
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        return new ValidationStatus(true);
    }

    public void execute() throws Exception {
    }

    public void log(Object object) {
        if (object != null) {
            if (this.plugIn != null) {
                this.msgObservation = new PlugInMessageObservation(this.plugIn.getName());
                this.msgObservation.setMessage(object.toString() + "");
                this.plugIn.updateObservers((PlugInObservation)this.msgObservation);
            } else {
                System.out.println(object);
            }
        }
    }

    public File getDomainDirectory() {
        File file = null;
        if (this.context != null) {
            file = (File)this.context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        }
        if (file == null) {
            String string = DomainDir.getRootDir();
            if (string == null) {
                string = ".";
            }
            file = new File(string);
        }
        return file;
    }

    public DomainMBean getDomainMBean() {
        DomainMBean domainMBean = null;
        if (this.context != null) {
            domainMBean = (DomainMBean)this.context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        }
        return domainMBean;
    }

    public PlugIn getPlugin() {
        return this.plugIn;
    }

    public PlugInContext getPlugInContext() {
        return this.context;
    }
}

