/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.PlugInMessageObservation;
import com.bea.plateng.plugin.PlugInObservation;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.ia.InputAdapter;
import java.util.ArrayList;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.upgrade.PluginActionDelegate;
import weblogic.upgrade.UpgradeHelper;

public class PluginActionDelegatePlugIn
extends AbstractPlugIn {
    private PlugInMessageObservation msgObservation;
    private PluginActionDelegate[] updaters;
    private String[] ARR = new String[0];

    public PluginActionDelegatePlugIn(PlugInDefinition plugInDefinition, String[] stringArray) throws PlugInException {
        super(plugInDefinition);
        try {
            this.ARR = stringArray;
            this.msgObservation = new PlugInMessageObservation(this.getName());
            ArrayList<1> arrayList = new ArrayList<1>();
            for (int i = 0; i < this.ARR.length; ++i) {
                Class<?> clazz = Class.forName(this.ARR[i]);
                Object obj = clazz.newInstance();
                if (obj instanceof ConfigurationProcessor) {
                    final ConfigurationProcessor configurationProcessor = (ConfigurationProcessor)obj;
                    PluginActionDelegate pluginActionDelegate = new PluginActionDelegate(){

                        public void execute() throws Exception {
                            configurationProcessor.updateConfiguration(this.getDomainMBean());
                        }

                        public String getName() {
                            return configurationProcessor.getClass().getName();
                        }
                    };
                    arrayList.add(pluginActionDelegate);
                    continue;
                }
                if (obj instanceof PluginActionDelegate) {
                    arrayList.add(obj);
                    continue;
                }
                throw new PlugInException(this.getName(), "Object must be a ConfigurationProcessor or PluginActionDelegate, not: " + obj.getClass().getName());
            }
            this.updaters = arrayList.toArray(new PluginActionDelegate[0]);
        }
        catch (PlugInException plugInException) {
            throw plugInException;
        }
        catch (Exception exception) {
            throw new PlugInException(this.getName(), "Constructor Exception: " + exception, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(PlugInContext plugInContext) throws PlugInException {
        try {
            super.prepare(plugInContext);
            UpgradeHelper.setupWLSClientLogger(this);
            for (int i = 0; i < this.updaters.length; ++i) {
                try {
                    this.updaters[i].initPlugIn(this);
                    this.updaters[i].prepare(plugInContext);
                    continue;
                }
                catch (Exception exception) {
                    throw new PlugInException(this.getName(), "Prepare Exception: " + exception, (Throwable)exception);
                }
            }
        }
        finally {
            UpgradeHelper.setupWLSClientLogger(null);
        }
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        ValidationStatus validationStatus = super.validateInputAdapter(inputAdapter);
        ValidationStatus validationStatus2 = null;
        if (validationStatus.isValid()) {
            for (int i = 0; i < this.updaters.length; ++i) {
                validationStatus2 = this.updaters[i].validateInputAdapter(inputAdapter);
                if (validationStatus2.isValid()) continue;
                validationStatus = validationStatus2;
                break;
            }
        }
        return validationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws PlugInException {
        try {
            UpgradeHelper.setupWLSClientLogger(this);
            for (int i = 0; i < this.updaters.length; ++i) {
                try {
                    this.updaters[i].execute();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new PlugInException(this.getName(), "Exception: " + throwable, throwable);
                }
            }
        }
        finally {
            UpgradeHelper.setupWLSClientLogger(null);
        }
    }

    public synchronized void log(Object object) {
        if (object != null) {
            this.msgObservation = new PlugInMessageObservation(this.getName());
            this.msgObservation.setMessage(object.toString() + "");
            this.updateObservers((PlugInObservation)this.msgObservation);
        }
    }
}

