/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInMessageObservation;
import com.bea.plateng.plugin.PlugInObservation;
import com.bea.plateng.plugin.ia.DefaultChoiceInputAdapter;
import com.bea.plateng.plugin.ia.DefaultCompositeInputAdapter;
import com.bea.plateng.plugin.ia.DefaultTextInputAdapter;
import com.bea.plateng.wizard.plugin.helpers.PlugInWizardInputAdapterHelper;
import com.bea.plateng.wizard.plugin.helpers.SummaryMessageHelper;
import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.common.util.ResourceBundleManager;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import weblogic.common.internal.VersionInfo;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.kernel.KernelLogManager;
import weblogic.logging.ConsoleHandler;
import weblogic.logging.WLLevel;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.upgrade.Main;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class UpgradeHelper {
    private static WLLogHandlerForUpgrade wlLogHdlr;

    public static final String i18n(String string) {
        String string2 = ResourceBundleManager.getString((String)"plugin", (String)string);
        if (string2 != null) {
            IObjectStore iObjectStore = ObjectStoreManager.getObjectStore((String)"plugin");
            string2 = iObjectStore.substitute(string2);
        } else {
            string2 = "";
        }
        return string2;
    }

    public static final String i18n(String string, Object object) {
        return MessageFormat.format(UpgradeHelper.i18n(string), object);
    }

    public static final String i18n(String string, Object object, Object object2) {
        return MessageFormat.format(UpgradeHelper.i18n(string), object, object2);
    }

    public static final String i18n(String string, Object[] objectArray) {
        return MessageFormat.format(UpgradeHelper.i18n(string), objectArray);
    }

    public static List listFiles(File file, boolean bl, FileFilter fileFilter, List list) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileFilter != null && !fileFilter.accept(fileArray[i])) continue;
            if (bl && fileArray[i].isDirectory()) {
                UpgradeHelper.listFiles(fileArray[i], bl, fileFilter, list);
                continue;
            }
            list.add(fileArray[i]);
        }
        return list;
    }

    public static DefaultTextInputAdapter createTextIA(String string, String string2) throws Exception {
        return PlugInWizardInputAdapterHelper.createDefaultTextInputAdapter((String)string, (String)string2, (String)"");
    }

    public static DefaultCompositeInputAdapter createCompositeIA(String string, String string2) throws Exception {
        return PlugInWizardInputAdapterHelper.createDefaultCompositeInputAdapter((String)string, (String)string2);
    }

    public static DefaultChoiceInputAdapter createChoiceIA(String string, String string2) throws Exception {
        return PlugInWizardInputAdapterHelper.createDefaultChoiceInputAdapter((String)string, (String)string2, (String)"");
    }

    public static void addSummaryMessage(PlugInContext plugInContext, String string, String string2) {
        SummaryMessageHelper.addSummaryMessage((PlugInContext)plugInContext, (String)string, (String)string2);
    }

    public static void clearSummaryMessages(PlugInContext plugInContext, String string) {
        ArrayList arrayList = (ArrayList)plugInContext.get((Object)"PLUGIN_SUMMARY_MESSAGES_KEY");
        if (arrayList == null) {
            arrayList = new ArrayList();
            plugInContext.put((Object)"PLUGIN_SUMMARY_MESSAGES_KEY", arrayList);
        }
        arrayList.clear();
    }

    public static String getOutputLocation() {
        String string = System.getProperty(Main.REDIRECTED_OUTPUT_FILE_KEY);
        if (string == null) {
            string = UpgradeHelper.i18n("plugin.std_out_repr");
        }
        return string;
    }

    public static void addSummaryMessageForOutputLocation(PlugInContext plugInContext, String string) {
        String string2 = UpgradeHelper.i18n("plugin.comprehensive_log_written", UpgradeHelper.getOutputLocation());
        UpgradeHelper.addSummaryMessage(plugInContext, string, string2);
    }

    private static void log(String string, String string2, AbstractPlugIn abstractPlugIn) {
        PlugInMessageObservation plugInMessageObservation = new PlugInMessageObservation(string);
        plugInMessageObservation.setMessage(string2);
        abstractPlugIn.updateObservers((PlugInObservation)plugInMessageObservation);
    }

    public static void log(AbstractPlugIn abstractPlugIn, String string) {
        UpgradeHelper.log(abstractPlugIn.getName(), string, abstractPlugIn);
    }

    public static void setupWLSClientLogger(AbstractPlugIn abstractPlugIn) {
        wlLogHdlr.setCurrentPlugIn(abstractPlugIn);
    }

    public static void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void resetLocalServerNames(AbstractPlugIn abstractPlugIn, PlugInContext plugInContext) {
        File file = (File)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        DomainMBean domainMBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        HashSet<String> hashSet = new HashSet<String>();
        String string = System.getProperty("weblogic.Name");
        String string2 = domainMBean.getConfigurationVersion();
        if (string != null && string.trim().length() > 0) {
            hashSet.add(string);
        }
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            String string3 = serverMBeanArray[i].getTransactionLogFilePrefix();
            File file2 = null;
            file2 = string2.startsWith("6.1") ? file : new File(file, serverMBeanArray[i].getName());
            if (string3 != null && string3.trim().length() > 0) {
                file2 = new File(string3).isAbsolute() ? new File(string3) : new File(file2, string3);
            }
            if (string2.startsWith("6.1")) {
                file2 = new File(file2, serverMBeanArray[i].getName() + ".0000.tlog");
            }
            if (string2.startsWith("6")) {
                file2 = new File(file2, serverMBeanArray[i].getName() + ".0000.tlog");
            }
            if (!file2.exists()) continue;
            hashSet.add(serverMBeanArray[i].getName());
        }
        if (hashSet.size() > 0) {
            UpgradeHelper.log(abstractPlugIn, UpgradeHelper.i18n("plugin.server_detected_in_directory", hashSet));
        } else {
            UpgradeHelper.log(abstractPlugIn, UpgradeHelper.i18n("plugin.no_servers_detected_in_directory"));
        }
        plugInContext.put((Object)DomainPlugInConstants.SERVER_NAMES_KEY, (Object)hashSet.toArray(new String[0]));
    }

    public static String getTargetVersion() {
        VersionInfo versionInfo = VersionInfoFactory.getVersionInfo();
        int n = versionInfo.getMajor();
        int n2 = versionInfo.getMinor();
        int n3 = versionInfo.getServicePack();
        int n4 = versionInfo.getRollingPatch();
        return new String(n + "." + n2 + "." + n3 + "." + n4);
    }

    static {
        Logger logger = KernelLogManager.getLogger();
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            if (!(handlerArray[i] instanceof ConsoleHandler)) continue;
            handlerArray[i].setLevel(Level.OFF);
        }
        wlLogHdlr = new WLLogHandlerForUpgrade();
        logger.addHandler(wlLogHdlr);
    }

    public static class WLLogHandlerForUpgrade
    extends Handler {
        private AbstractPlugIn currPlugin;

        public void close() {
        }

        public void flush() {
        }

        public void setCurrentPlugIn(AbstractPlugIn abstractPlugIn) {
            this.currPlugin = abstractPlugIn;
        }

        public void publish(LogRecord logRecord) {
            if (this.currPlugin == null || logRecord == null) {
                return;
            }
            Level level = logRecord.getLevel();
            if (level != null && (level instanceof WLLevel && level.intValue() >= 980 || level instanceof Level && level.intValue() >= Level.SEVERE.intValue())) {
                UpgradeHelper.log(this.currPlugin, logRecord.getMessage());
            } else {
                UpgradeHelper.log(this.currPlugin, logRecord.getMessage());
            }
        }
    }
}

