/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.channels;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.NetworkChannelMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;

public class ChannelConfigProcessor
implements ConfigurationProcessor {
    private final boolean DEBUG = false;

    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        try {
            this.changeChannels(domainMBean);
        }
        catch (Exception exception) {
            throw new UpdateException(exception);
        }
    }

    private void changeChannels(DomainMBean domainMBean) throws Exception {
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        HashMap<String, ServerMBean> hashMap = new HashMap<String, ServerMBean>();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            hashMap.put(serverMBeanArray[i].getName(), serverMBeanArray[i]);
        }
        NetworkChannelMBean[] networkChannelMBeanArray = domainMBean.getNetworkChannels();
        for (int i = 0; i < networkChannelMBeanArray.length; ++i) {
            NetworkChannelMBean networkChannelMBean = networkChannelMBeanArray[i];
            TargetMBean[] targetMBeanArray = networkChannelMBean.getTargets();
            for (int j = 0; j < targetMBeanArray.length; ++j) {
                Set set = targetMBeanArray[j].getServerNames();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ServerMBean serverMBean = (ServerMBean)hashMap.get((String)iterator.next());
                    NetworkAccessPointMBean[] networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints();
                    NetworkAccessPointMBean networkAccessPointMBean = null;
                    for (int k = 0; k < networkAccessPointMBeanArray.length; ++k) {
                        if (!networkAccessPointMBeanArray[k].getName().equals(networkChannelMBean.getName())) continue;
                        networkAccessPointMBean = networkAccessPointMBeanArray[k];
                        break;
                    }
                    if (networkAccessPointMBean == null) {
                        networkAccessPointMBean = serverMBean.createNetworkAccessPoint(networkChannelMBean.getName());
                    }
                    if (networkChannelMBean.isT3Enabled()) {
                        NetworkAccessPointMBean networkAccessPointMBean2 = serverMBean.createNetworkAccessPoint(networkChannelMBean.getName() + "_t3");
                        networkAccessPointMBean2.setProtocol("t3");
                        networkAccessPointMBean2.setCompleteMessageTimeout(networkChannelMBean.getCompleteT3MessageTimeout());
                        networkAccessPointMBean2.setMaxMessageSize(networkChannelMBean.getMaxT3MessageSize());
                        networkAccessPointMBean2.setHttpEnabledForThisProtocol(networkChannelMBean.isHTTPEnabled());
                        this.copyNCSettings(networkAccessPointMBean2, networkChannelMBean);
                    }
                    if (networkChannelMBean.isT3SEnabled()) {
                        NetworkAccessPointMBean networkAccessPointMBean3 = serverMBean.createNetworkAccessPoint(networkChannelMBean.getName() + "_t3s");
                        networkAccessPointMBean3.setProtocol("t3s");
                        networkAccessPointMBean3.setCompleteMessageTimeout(networkChannelMBean.getCompleteT3MessageTimeout());
                        networkAccessPointMBean3.setMaxMessageSize(networkChannelMBean.getMaxT3MessageSize());
                        networkAccessPointMBean3.setHttpEnabledForThisProtocol(networkChannelMBean.isHTTPSEnabled());
                        this.copyNCSettings(networkAccessPointMBean3, networkChannelMBean);
                    }
                    if (networkChannelMBean.isIIOPEnabled()) {
                        NetworkAccessPointMBean networkAccessPointMBean4 = serverMBean.createNetworkAccessPoint(networkChannelMBean.getName() + "_iiop");
                        networkAccessPointMBean4.setProtocol("iiop");
                        networkAccessPointMBean4.setCompleteMessageTimeout(networkChannelMBean.getCompleteIIOPMessageTimeout());
                        networkAccessPointMBean4.setMaxMessageSize(networkChannelMBean.getMaxIIOPMessageSize());
                        networkAccessPointMBean4.setIdleConnectionTimeout(networkChannelMBean.getIdleIIOPConnectionTimeout());
                        networkAccessPointMBean4.setHttpEnabledForThisProtocol(networkChannelMBean.isHTTPEnabled());
                        this.copyNCSettings(networkAccessPointMBean4, networkChannelMBean);
                    }
                    if (networkChannelMBean.isIIOPSEnabled()) {
                        NetworkAccessPointMBean networkAccessPointMBean5 = serverMBean.createNetworkAccessPoint(networkChannelMBean.getName() + "_iiops");
                        networkAccessPointMBean5.setProtocol("iiops");
                        networkAccessPointMBean5.setCompleteMessageTimeout(networkChannelMBean.getCompleteIIOPMessageTimeout());
                        networkAccessPointMBean5.setMaxMessageSize(networkChannelMBean.getMaxIIOPMessageSize());
                        networkAccessPointMBean5.setIdleConnectionTimeout(networkChannelMBean.getIdleIIOPConnectionTimeout());
                        networkAccessPointMBean5.setHttpEnabledForThisProtocol(networkChannelMBean.isHTTPSEnabled());
                        this.copyNCSettings(networkAccessPointMBean5, networkChannelMBean);
                    }
                    if (networkChannelMBean.isCOMEnabled()) {
                        NetworkAccessPointMBean networkAccessPointMBean6 = serverMBean.createNetworkAccessPoint(networkChannelMBean.getName() + "_com");
                        networkAccessPointMBean6.setProtocol("com");
                        networkAccessPointMBean6.setCompleteMessageTimeout(networkChannelMBean.getCompleteCOMMessageTimeout());
                        networkAccessPointMBean6.setMaxMessageSize(networkChannelMBean.getMaxCOMMessageSize());
                        this.copyNCSettings(networkAccessPointMBean6, networkChannelMBean);
                    }
                    if (networkChannelMBean.isHTTPEnabled()) {
                        NetworkAccessPointMBean networkAccessPointMBean7 = serverMBean.createNetworkAccessPoint(networkChannelMBean.getName() + "_http");
                        networkAccessPointMBean7.setProtocol("http");
                        networkAccessPointMBean7.setCompleteMessageTimeout(networkChannelMBean.getCompleteHTTPMessageTimeout());
                        networkAccessPointMBean7.setMaxMessageSize(networkChannelMBean.getMaxHTTPMessageSize());
                        this.copyNCSettings(networkAccessPointMBean7, networkChannelMBean);
                    }
                    if (networkChannelMBean.isHTTPSEnabled()) {
                        NetworkAccessPointMBean networkAccessPointMBean8 = serverMBean.createNetworkAccessPoint(networkChannelMBean.getName() + "_https");
                        networkAccessPointMBean8.setProtocol("https");
                        networkAccessPointMBean8.setCompleteMessageTimeout(networkChannelMBean.getCompleteHTTPMessageTimeout());
                        networkAccessPointMBean8.setMaxMessageSize(networkChannelMBean.getMaxHTTPMessageSize());
                        this.copyNCSettings(networkAccessPointMBean8, networkChannelMBean);
                    }
                    serverMBean.destroyNetworkAccessPoint(networkAccessPointMBean);
                }
            }
            domainMBean.destroyNetworkChannel(networkChannelMBean);
        }
    }

    private void copyNCSettings(NetworkAccessPointMBean networkAccessPointMBean, NetworkChannelMBean networkChannelMBean) throws Exception {
        networkAccessPointMBean.setListenPort(networkChannelMBean.getListenPort());
        networkAccessPointMBean.setEnabled(networkChannelMBean.isListenPortEnabled());
        networkAccessPointMBean.setOutboundEnabled(networkChannelMBean.isOutgoingEnabled());
        networkAccessPointMBean.setChannelWeight(networkChannelMBean.getChannelWeight());
        networkAccessPointMBean.setAcceptBacklog(networkChannelMBean.getAcceptBacklog());
        networkAccessPointMBean.setLoginTimeoutMillis(networkChannelMBean.getLoginTimeoutMillis());
        networkAccessPointMBean.setTunnelingEnabled(networkChannelMBean.isTunnelingEnabled());
        networkAccessPointMBean.setTunnelingClientPingSecs(networkChannelMBean.getTunnelingClientPingSecs());
        networkAccessPointMBean.setTunnelingClientTimeoutSecs(networkChannelMBean.getTunnelingClientTimeoutSecs());
    }

    private static final void p(String string) {
        System.out.println("<ChannelConfigProcessor>: " + string);
    }
}

