/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain;

import java.io.OutputStream;
import java.util.ArrayList;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.internal.ServerLocks;
import weblogic.management.upgrade.ConfigFileHelper;
import weblogic.management.utils.PDevHelper;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.Executable;
import weblogic.version;

public class DomainUpgradeServerService
extends AbstractServerService {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDomainUpgradeServerService");

    public void start() throws ServiceFailureException {
        try {
            if (ConfigFileHelper.isUpgradeNeeded()) {
                ManagementLogger.logDomainUpgrading((String)version.getReleaseBuildVersion());
                this.doUpgrade();
            }
        }
        catch (ConfigFileHelper.UpgradeNotWantedException upgradeNotWantedException) {
            throw new ServiceFailureException(upgradeNotWantedException.getMessage());
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException(managementException.getMessage(), (Throwable)managementException);
        }
    }

    public void doUpgrade() throws ServiceFailureException {
        try {
            String[] stringArray;
            if (!Boolean.getBoolean("weblogic.ProductionModeEnabled")) {
                SerializedSystemIni.getEncryptionService();
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(System.getProperty("java.home") + "/bin/java");
            Object object = System.getProperties().propertyNames();
            while (object.hasMoreElements()) {
                stringArray = (String[])object.nextElement();
                if (!stringArray.startsWith("weblogic") && !stringArray.startsWith("com")) continue;
                arrayList.add("-D" + (String)stringArray + "=" + System.getProperty((String)stringArray));
            }
            arrayList.add("-Dweblogic.upgrade.forked");
            object = System.getProperty("java.class.path");
            object = PDevHelper.addPDevLibraryToClasspath((String)object);
            object = ((String)object).replaceAll("\\\\\\\\", "/");
            object = ((String)object).replaceAll("\\\\", "/");
            object = ((String)object).replace('\\', '/');
            arrayList.add("-classpath");
            arrayList.add(object);
            arrayList.add("weblogic.Upgrade");
            arrayList.add("-mode");
            arrayList.add("silent");
            arrayList.add("-type");
            arrayList.add("domain");
            if (DEBUG.isDebugEnabled()) {
                arrayList.add("-debug");
                DEBUG.debug("Running DomainUpgradeServerService process with command line list: " + arrayList);
            }
            stringArray = arrayList.toArray(new String[0]);
            Executable executable = new Executable((OutputStream)System.out, (OutputStream)System.err);
            ServerLocks.releaseServerLock();
            executable.exec(stringArray);
            ServerLocks.getServerLock();
            int n = executable.getExitValue();
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug(" DomainUpgradeServerService process exit code is " + n);
            }
            if (n != 0) {
                String string = "Error upgrading the domain. Look at your standard output and error for more information";
                throw new ServiceFailureException(string);
            }
        }
        catch (ServiceFailureException serviceFailureException) {
            throw serviceFailureException;
        }
        catch (Exception exception) {
            throw new ServiceFailureException((Throwable)exception);
        }
    }

    public void halt() throws ServiceFailureException {
    }

    public void stop() throws ServiceFailureException {
    }
}

