/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.adminserverselection;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.ia.Choice;
import com.bea.plateng.plugin.ia.DefaultChoiceInputAdapter;
import com.bea.plateng.plugin.ia.InputAdapter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.ConfigLogger;
import weblogic.management.provider.PropertyService;
import weblogic.server.ServiceFailureException;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class AdminServerSelectionPlugIn
extends AbstractPlugIn
implements DomainPlugInConstants {
    private static PropertyService propertyService = null;
    private static final boolean DEBUG = false;

    public AdminServerSelectionPlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        String string;
        super.prepare(plugInContext);
        DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)this._adapter;
        DomainMBean domainMBean = (DomainMBean)this._context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        if (serverMBeanArray == null || serverMBeanArray.length == 0) {
            throw new PlugInException(this.getName(), "No servers are defined in this domain");
        }
        Choice[] choiceArray = new Choice[serverMBeanArray.length];
        HashMap<String, Choice> hashMap = new HashMap<String, Choice>();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            string = serverMBeanArray[i].getName();
            choiceArray[i] = new Choice(string, false);
            choiceArray[i].setPrompt(string);
            hashMap.put(string, choiceArray[i]);
        }
        defaultChoiceInputAdapter.setChoices(choiceArray);
        String string2 = this.getDefaultAdminServerName(domainMBean, serverMBeanArray);
        string = (Choice)hashMap.get(string2);
        string.setSelected(true);
        this._context.put((Object)DomainPlugInConstants.ADMIN_SERVER_NAME_KEY, (Object)string2);
        defaultChoiceInputAdapter.setMultipleSelectionPermitted(false);
    }

    public InputAdapter getInputAdapter() {
        DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)this._adapter;
        Choice[] choiceArray = defaultChoiceInputAdapter.getChoices();
        if (choiceArray.length == 1) {
            return null;
        }
        return super.getInputAdapter();
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)this._adapter;
        Choice choice = defaultChoiceInputAdapter.getSelectedChoices()[0];
        String string = choice.getId();
        this._context.put((Object)DomainPlugInConstants.ADMIN_SERVER_NAME_KEY, (Object)string);
        return new ValidationStatus(true);
    }

    public void execute() throws PlugInException {
        try {
            String string = (String)this._context.get((Object)DomainPlugInConstants.ADMIN_SERVER_NAME_KEY);
            UpgradeHelper.addSummaryMessage(this._context, this.getName(), UpgradeHelper.i18n("AdminServerSelectionPlugIn.execute.admin_server_selected", string));
            System.setProperty("weblogic.Name", string);
            BootStrap.reinit();
            if (propertyService == null) {
                propertyService = new PropertyService();
            }
            propertyService.start();
            DomainMBean domainMBean = (DomainMBean)this._context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
            propertyService.doPostParseInitialization(domainMBean);
            String[] stringArray = (String[])this._context.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
            List<String> list = Arrays.asList(stringArray);
            if (list.size() == 0 || list.contains(string)) {
                this._context.put((Object)DomainPlugInConstants.HAS_CONFIGURATION_KEY, (Object)Boolean.TRUE);
                UpgradeHelper.log(this, UpgradeHelper.i18n("AdminServerSelectionPlugIn.CONF_WRITTEN_OUT_LATER"));
            } else {
                this._context.put((Object)DomainPlugInConstants.HAS_CONFIGURATION_KEY, (Object)Boolean.FALSE);
                UpgradeHelper.log(this, UpgradeHelper.i18n("AdminServerSelectionPlugIn.CONF_NOT_WRITTEN_OUT_LATER"));
            }
        }
        catch (ServiceFailureException serviceFailureException) {
            throw new PlugInException(this.getName(), "Error starting property service", (Throwable)serviceFailureException);
        }
    }

    private String getDefaultAdminServerName(DomainMBean domainMBean, ServerMBean[] serverMBeanArray) throws PlugInException {
        String string = (String)this._context.get((Object)DomainPlugInConstants.ADMIN_SERVER_NAME_KEY);
        if (string == null || string.length() == 0) {
            string = System.getProperty("weblogic.upgrade.adminserver");
        }
        if (string == null || string.length() == 0) {
            string = System.getProperty("weblogic.Name");
        }
        if (string != null && string.length() > 0) {
            if (domainMBean.lookupServer(string) != null) {
                return string;
            }
            throw new PlugInException(this.getName(), ConfigLogger.logServerNameNotFoundLoggable((String)string, (String)domainMBean.getName()).getMessage());
        }
        if (serverMBeanArray.length == 1) {
            return serverMBeanArray[0].getName();
        }
        boolean bl = false;
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBeanArray[i].getName().equals("myserver")) continue;
            bl = true;
            break;
        }
        if (bl) {
            return "myserver";
        }
        return serverMBeanArray[0].getName();
    }
}

