/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.application;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.PlugInMessageObservation;
import com.bea.plateng.plugin.PlugInObservation;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.ia.Choice;
import com.bea.plateng.plugin.ia.DefaultChoiceInputAdapter;
import com.bea.plateng.plugin.ia.InputAdapter;
import java.util.ArrayList;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class DomainApplicationsPlugIn
extends AbstractPlugIn {
    private static String SELECTED_APPS_KEY = DomainApplicationsPlugIn.class.getName() + ".SELECTED_APPS_KEY";

    public DomainApplicationsPlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        super.prepare(plugInContext);
        DomainMBean domainMBean = (DomainMBean)this._context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        ApplicationMBean[] applicationMBeanArray = domainMBean.getApplications();
        Choice[] choiceArray = new Choice[applicationMBeanArray.length];
        for (int i = 0; i < applicationMBeanArray.length; ++i) {
            Choice choice = new Choice(applicationMBeanArray[i].getName());
            choice.setPrompt(applicationMBeanArray[i].getName());
            choiceArray[i] = choice;
        }
        DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)this._adapter;
        defaultChoiceInputAdapter.setChoices(choiceArray);
        defaultChoiceInputAdapter.setMultipleSelectionPermitted(true);
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        ValidationStatus validationStatus = super.validateInputAdapter(inputAdapter);
        if (validationStatus.isValid()) {
            DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)this._adapter;
            Choice[] choiceArray = defaultChoiceInputAdapter.getSelectedChoices();
            DomainMBean domainMBean = (DomainMBean)this._context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < choiceArray.length; ++i) {
                String string = choiceArray[i].getPrompt();
                arrayList.add(string);
            }
            this._context.put((Object)SELECTED_APPS_KEY, (Object)arrayList.toArray(new String[0]));
        }
        return validationStatus;
    }

    public void execute() throws PlugInException {
        String[] stringArray = (String[])this._context.get((Object)SELECTED_APPS_KEY);
        for (int i = 0; i < stringArray.length; ++i) {
            this.updateStatus("Updating application: " + stringArray[i]);
            this.sleep(200L);
            this.updateStatus("Application Upgrade not yet supported");
        }
    }

    private void updateStatus(String string) {
        this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), string + ""));
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

