/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.configuration;

import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import java.io.File;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ClientAccess;
import weblogic.management.provider.ManagementServiceClient;
import weblogic.upgrade.PluginActionDelegatePlugIn;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class DomainConfigurationPersistencePlugIn
extends PluginActionDelegatePlugIn {
    private static String[] RESTRUCTURERS = new String[]{"weblogic.upgrade.domain.directoryrestructure.MoveConfigurationFilesPlugin", "weblogic.upgrade.PluginActionDelegate"};

    public DomainConfigurationPersistencePlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition, RESTRUCTURERS);
    }

    public void execute() throws PlugInException {
        try {
            if (this.doWriteOutConfigFiles()) {
                DomainMBean domainMBean = (DomainMBean)this._context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
                File file = (File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
                File file2 = new File(file, "config");
                UpgradeHelper.log(this, UpgradeHelper.i18n("DomainConfigurationPersistencePlugIn.execute.writing_config_files", file2.getPath()));
                ClientAccess clientAccess = ManagementServiceClient.getClientAccess();
                clientAccess.saveDomainDirectory(domainMBean, file.getPath());
                UpgradeHelper.log(this, UpgradeHelper.i18n("DomainConfigurationPersistencePlugIn.execute.done_writing_config_files", file2.getPath()));
                UpgradeHelper.addSummaryMessage(this._context, this.getName(), UpgradeHelper.i18n("DomainConfigurationPersistencePlugIn.execute.check_java_compiler_values"));
                UpgradeHelper.addSummaryMessage(this._context, this.getName(), UpgradeHelper.i18n("DomainConfigurationPersistencePlugIn.execute.check_server_start_values"));
            }
        }
        catch (Exception exception) {
            throw new PlugInException(this.getName(), "Execute Exception ... " + exception.toString(), (Throwable)exception);
        }
        super.execute();
    }

    private boolean doWriteOutConfigFiles() {
        Boolean bl = (Boolean)this._context.get((Object)DomainPlugInConstants.HAS_CONFIGURATION_KEY);
        return bl != null && bl != false;
    }
}

