/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.configuration;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.ia.DefaultCompositeInputAdapter;
import com.bea.plateng.plugin.ia.DefaultTextInputAdapter;
import com.bea.plateng.plugin.ia.InputAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Properties;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.nodemanager.server.DomainDir;
import weblogic.nodemanager.server.UserInfo;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class NodeManagerCredentialsPlugIn
extends AbstractPlugIn {
    private static final String USERNAME_PROP = "username";
    private static final String PASSWORD_PROP = "password";

    public NodeManagerCredentialsPlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        Object object;
        super.prepare(plugInContext);
        DomainMBean domainMBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        String string = (String)plugInContext.get((Object)DomainPlugInConstants.NM_CREDENTIALS_USERNAME_KEY);
        String string2 = (String)plugInContext.get((Object)DomainPlugInConstants.NM_CREDENTIALS_PASSWORD_KEY);
        SecurityConfigurationMBean securityConfigurationMBean = domainMBean.getSecurityConfiguration();
        if (this.isBlank(string)) {
            string = securityConfigurationMBean.getNodeManagerUsername();
        }
        if (this.isBlank(string2)) {
            string2 = securityConfigurationMBean.getNodeManagerPassword();
        }
        File file = (File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        File file2 = new File(file, "config/nodemanager/nm_password.properties");
        if (this.isBlank(string)) {
            string = "weblogic";
            if (file2.exists()) {
                object = this.load(file2);
                string = ((Properties)object).getProperty(USERNAME_PROP);
                string2 = ((Properties)object).getProperty(PASSWORD_PROP);
            }
        }
        if (this.isBlank(string2)) {
            object = new byte[4];
            new SecureRandom().nextBytes((byte[])object);
            string2 = new BigInteger((byte[])object).toString(16);
        }
        plugInContext.put((Object)DomainPlugInConstants.NM_CREDENTIALS_USERNAME_KEY, (Object)string);
        plugInContext.put((Object)DomainPlugInConstants.NM_CREDENTIALS_PASSWORD_KEY, (Object)string2);
        object = (DefaultCompositeInputAdapter)this._adapter;
        DefaultTextInputAdapter defaultTextInputAdapter = (DefaultTextInputAdapter)object.getInputAdapter("UsernameIA");
        defaultTextInputAdapter.setValue(string);
        defaultTextInputAdapter.setPrompt(UpgradeHelper.i18n("NodeManagerCredentialsPlugIn.UsernameIA.input.prompt.text"));
        defaultTextInputAdapter.setDescription(UpgradeHelper.i18n("NodeManagerCredentialsPlugIn.UsernameIA.input.description.text"));
        DefaultTextInputAdapter defaultTextInputAdapter2 = (DefaultTextInputAdapter)object.getInputAdapter("PasswordIA");
        defaultTextInputAdapter2.setAsPassword(true);
        defaultTextInputAdapter2.setValue(string2);
        defaultTextInputAdapter2.setPrompt(UpgradeHelper.i18n("NodeManagerCredentialsPlugIn.PasswordIA.input.prompt.text"));
        defaultTextInputAdapter2.setDescription(UpgradeHelper.i18n("NodeManagerCredentialsPlugIn.PasswordIA.input.description.text"));
        DefaultTextInputAdapter defaultTextInputAdapter3 = (DefaultTextInputAdapter)object.getInputAdapter("PasswordConfirmIA");
        defaultTextInputAdapter3.setAsPassword(true);
        defaultTextInputAdapter3.setValue(string2);
        defaultTextInputAdapter3.setPrompt(UpgradeHelper.i18n("NodeManagerCredentialsPlugIn.PasswordConfirmIA.input.prompt.text"));
        defaultTextInputAdapter3.setDescription(UpgradeHelper.i18n("NodeManagerCredentialsPlugIn.PasswordConfirmIA.input.description.text"));
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        String string;
        ValidationStatus validationStatus = super.validateInputAdapter(inputAdapter);
        DefaultCompositeInputAdapter defaultCompositeInputAdapter = (DefaultCompositeInputAdapter)this._adapter;
        DefaultTextInputAdapter defaultTextInputAdapter = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("UsernameIA");
        DefaultTextInputAdapter defaultTextInputAdapter2 = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("PasswordIA");
        DefaultTextInputAdapter defaultTextInputAdapter3 = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("PasswordConfirmIA");
        String string2 = defaultTextInputAdapter.getValue();
        String string3 = defaultTextInputAdapter2.getValue();
        if (!string3.equals(string = defaultTextInputAdapter3.getValue())) {
            validationStatus.setErrorMessage("Passwords supplied do not match");
            validationStatus.setValid(false);
            return validationStatus;
        }
        this._context.put((Object)DomainPlugInConstants.NM_CREDENTIALS_USERNAME_KEY, (Object)string2);
        this._context.put((Object)DomainPlugInConstants.NM_CREDENTIALS_PASSWORD_KEY, (Object)string3);
        validationStatus.setValid(true);
        return validationStatus;
    }

    public void execute() throws PlugInException {
        boolean bl;
        DomainMBean domainMBean = (DomainMBean)this._context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        SecurityConfigurationMBean securityConfigurationMBean = domainMBean.getSecurityConfiguration();
        String string = (String)this._context.get((Object)DomainPlugInConstants.NM_CREDENTIALS_USERNAME_KEY);
        String string2 = (String)this._context.get((Object)DomainPlugInConstants.NM_CREDENTIALS_PASSWORD_KEY);
        File file = (File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        File file2 = new File(file, "config/nodemanager/nm_password.properties");
        boolean bl2 = file2.exists();
        boolean bl3 = bl = string.equals(securityConfigurationMBean.getNodeManagerUsername()) && string2.equals(securityConfigurationMBean.getNodeManagerPassword());
        if (!bl) {
            UpgradeHelper.log(this, UpgradeHelper.i18n("NodeManagerCredentialsPlugIn.execute.set_NM_cred_in_memory"));
            securityConfigurationMBean.setNodeManagerUsername(string);
            securityConfigurationMBean.setNodeManagerPassword(string2);
        }
        if (!bl || !bl2) {
            try {
                UpgradeHelper.log(this, UpgradeHelper.i18n("NodeManagerCredentialsPlugIn.execute.writing_nm_password_file"));
                file2.getParentFile().mkdirs();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file2));
                String string3 = System.getProperty("line.separator");
                outputStreamWriter.write("username=" + string + string3 + "password=" + string2 + string3);
                outputStreamWriter.close();
                DomainDir domainDir = new DomainDir(file.getAbsolutePath());
                UserInfo userInfo = new UserInfo(domainDir);
                userInfo.load(file2);
                userInfo.save(file2);
            }
            catch (IOException iOException) {
                throw new PlugInException(this.getName(), "Execute Exception ... " + iOException.toString(), (Throwable)iOException);
            }
        }
    }

    private Properties load(File file) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }
}

