/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.configuration;

import java.util.Arrays;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.WebAppContainerMBean;
import weblogic.upgrade.PluginActionDelegate;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;

public class SetBackwardsCompatibilityFlagsDelegate
extends PluginActionDelegate {
    public void execute() throws Exception {
        if (this.isSkipExecute()) {
            return;
        }
        DomainMBean domainMBean = this.getDomainMBean();
        WebAppContainerMBean webAppContainerMBean = domainMBean.getWebAppContainer();
        this.log(UpgradeHelper.i18n("SetBackwardsCompatibilityFlagsDelegate.set_FilterDispatchedRequestsEnabled"));
        webAppContainerMBean.setFilterDispatchedRequestsEnabled(true);
        this.log(UpgradeHelper.i18n("SetBackwardsCompatibilityFlagsDelegate.set_RtexprvalueJspParamName"));
        webAppContainerMBean.setRtexprvalueJspParamName(true);
        this.log(UpgradeHelper.i18n("SetBackwardsCompatibilityFlagsDelegate.set_JSPCompilerBackwardsCompatible="));
        webAppContainerMBean.setJSPCompilerBackwardsCompatible(true);
        this.log(UpgradeHelper.i18n("SetBackwardsCompatibilityFlagsDelegate.set_ReloginEnabled"));
        webAppContainerMBean.setReloginEnabled(true);
        this.log(UpgradeHelper.i18n("SetBackwardsCompatibilityFlagsDelegate.set_AllowAllRoles"));
        webAppContainerMBean.setAllowAllRoles(true);
        SecurityConfigurationMBean securityConfigurationMBean = domainMBean.getSecurityConfiguration();
        if (securityConfigurationMBean != null && !securityConfigurationMBean.isSet("WebAppFilesCaseInsensitive")) {
            this.log(UpgradeHelper.i18n("SetBackwardsCompatibilityFlagsDelegate.set_WebAppFilesCaseInsensitive"));
            securityConfigurationMBean.setWebAppFilesCaseInsensitive("os");
        }
    }

    private boolean isSkipExecute() {
        String[] stringArray = (String[])this.getPlugInContext().get((Object)DomainPlugInConstants.OPTIONAL_GROUPS_KEY);
        return Arrays.asList(stringArray).contains("SKIP_BACKWARDS_COMPATIBILITY_FLAGS_SELECTED_VALUE");
    }
}

