/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directorybackup;

import com.bea.plateng.plugin.AbstractPlugIn;
import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInDefinition;
import com.bea.plateng.plugin.PlugInException;
import com.bea.plateng.plugin.PlugInMessageObservation;
import com.bea.plateng.plugin.PlugInObservation;
import com.bea.plateng.plugin.PlugInProgressObservation;
import com.bea.plateng.plugin.ValidationStatus;
import com.bea.plateng.plugin.ia.DefaultChoiceInputAdapter;
import com.bea.plateng.plugin.ia.DefaultCompositeInputAdapter;
import com.bea.plateng.plugin.ia.DefaultFileSelectionInputAdapter;
import com.bea.plateng.plugin.ia.DefaultTextInputAdapter;
import com.bea.plateng.plugin.ia.InputAdapter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import weblogic.logging.WeblogicLogfileFilter;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.upgrade.UpgradeHelper;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.utils.FileUtils;

public class DomainDirectoryBackupPlugIn
extends AbstractPlugIn {
    public DomainDirectoryBackupPlugIn(PlugInDefinition plugInDefinition) throws PlugInException {
        super(plugInDefinition);
    }

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        Object object;
        super.prepare(plugInContext);
        PlugInMessageObservation plugInMessageObservation = new PlugInMessageObservation(this.getName());
        this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.prepare.prepare_to_backup")));
        File file = (File)this._context.get((Object)DomainPlugInConstants.DOMAIN_BACKUP_DIRECTORY_KEY);
        if (file == null) {
            file = (File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        }
        if (file == null) {
            file = new File(".");
        }
        DefaultCompositeInputAdapter defaultCompositeInputAdapter = (DefaultCompositeInputAdapter)this._adapter;
        DefaultFileSelectionInputAdapter defaultFileSelectionInputAdapter = (DefaultFileSelectionInputAdapter)defaultCompositeInputAdapter.getInputAdapter("FileSelectionIA");
        defaultFileSelectionInputAdapter.setSelectionMode(1);
        defaultFileSelectionInputAdapter.setMultipleSelection(false);
        defaultFileSelectionInputAdapter.setSelectedFileNames(new String[]{file.getPath()});
        String string = (String)this._context.get((Object)DomainPlugInConstants.DOMAIN_BACKUP_FILE_KEY);
        if (string == null) {
            object = (DomainMBean)this._context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
            String string2 = object.getName();
            string2 = string2 == null ? "" : "-" + string2;
            File file2 = new File((File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY), "config.xml");
            File file3 = null;
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                file3 = i == 0 ? new File("weblogic-domain-backup" + string2 + ".zip") : new File("weblogic-domain-backup" + string2 + "-" + i + ".zip");
                if (file3.exists() && file3.lastModified() <= file2.lastModified()) continue;
                string = file3.getName();
                break;
            }
        }
        object = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("TextIA");
        object.setValue(string);
        object.setPrompt(UpgradeHelper.i18n(this.getName() + "." + object.getName() + ".input.prompt.text"));
    }

    public ValidationStatus validateInputAdapter(InputAdapter inputAdapter) {
        ValidationStatus validationStatus = super.validateInputAdapter(inputAdapter);
        DefaultCompositeInputAdapter defaultCompositeInputAdapter = (DefaultCompositeInputAdapter)this._adapter;
        DefaultTextInputAdapter defaultTextInputAdapter = (DefaultTextInputAdapter)defaultCompositeInputAdapter.getInputAdapter("TextIA");
        DefaultFileSelectionInputAdapter defaultFileSelectionInputAdapter = (DefaultFileSelectionInputAdapter)defaultCompositeInputAdapter.getInputAdapter("FileSelectionIA");
        DefaultChoiceInputAdapter defaultChoiceInputAdapter = (DefaultChoiceInputAdapter)defaultCompositeInputAdapter.getInputAdapter("ChoiceIA");
        if (validationStatus.isValid()) {
            if (defaultTextInputAdapter.getValue() == null || "".equals(defaultTextInputAdapter.getValue())) {
                validationStatus.setErrorMessage(UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.TextIA.input.filemissing.text"));
                validationStatus.setValid(false);
            } else {
                File file = new File((File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY), "config.xml");
                File file2 = new File(defaultFileSelectionInputAdapter.getSelectedFile(), defaultTextInputAdapter.getValue());
                if (file2.exists() && file2.lastModified() < file.lastModified()) {
                    validationStatus.setErrorMessage(UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.TextIA.input.fileexists.text"));
                    validationStatus.setValid(false);
                }
            }
            if (validationStatus.isValid()) {
                this._context.put((Object)DomainPlugInConstants.DOMAIN_BACKUP_DIRECTORY_KEY, (Object)defaultFileSelectionInputAdapter.getSelectedFile());
                this._context.put((Object)DomainPlugInConstants.DOMAIN_BACKUP_FILE_KEY, (Object)defaultTextInputAdapter.getValue());
            }
        }
        return validationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws PlugInException {
        PlugInProgressObservation plugInProgressObservation = new PlugInProgressObservation(this.getName());
        this.updateObservers((PlugInObservation)plugInProgressObservation.setProgress(0));
        PlugInMessageObservation plugInMessageObservation = new PlugInMessageObservation(this.getName());
        this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.execute.message.start.text") + ""));
        ZipOutputStream zipOutputStream = null;
        File file = new File((File)this._context.get((Object)DomainPlugInConstants.DOMAIN_BACKUP_DIRECTORY_KEY), (String)this._context.get((Object)DomainPlugInConstants.DOMAIN_BACKUP_FILE_KEY));
        try {
            File file2 = new File((File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY), "config.xml");
            if (file.exists() && file.lastModified() > file2.lastModified()) {
                this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.execute.backup_file_already_created.text", file.getAbsoluteFile().getCanonicalFile().getPath())));
                this.updateObservers((PlugInObservation)plugInProgressObservation.setProgress(100));
                return;
            }
            file.createNewFile();
            file = file.getAbsoluteFile().getCanonicalFile();
            if (this.skipLogFiles()) {
                this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.execute.including_log_files.false.text")));
            } else {
                this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.execute.including_log_files.true.text")));
            }
            this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.execute.now_adding_message.text", file)));
            File file3 = (File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
            file3 = file3.getCanonicalFile();
            String string = file3.getPath().replace(File.separatorChar, '/');
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            this.replaceMigratedConfigWithOriginal(file3);
            int n = string.length();
            FileFilter fileFilter = this.getFileFilter();
            ArrayList arrayList = new ArrayList();
            UpgradeHelper.listFiles(file3, true, fileFilter, arrayList);
            this.updateObservers((PlugInObservation)plugInProgressObservation.setProgress(5));
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            File file4 = null;
            byte[] byArray = new byte[1024];
            int n2 = arrayList.size();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                file4 = (File)arrayList.get(i);
                FileInputStream fileInputStream = null;
                String string2 = file4.getPath().replace(File.separatorChar, '/').substring(n);
                try {
                    fileInputStream = new FileInputStream(file4);
                    ZipEntry zipEntry = new ZipEntry(string2);
                    zipOutputStream.putNextEntry(zipEntry);
                    int n4 = 0;
                    while ((n4 = fileInputStream.read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n4);
                    }
                    zipOutputStream.closeEntry();
                    fileInputStream.close();
                    int n5 = Math.round(100.0f * (float)(i + 1) / (float)n2);
                    if (n5 <= n3) continue;
                    this.updateObservers((PlugInObservation)plugInProgressObservation.setProgress(n5));
                    n3 = n5;
                    continue;
                }
                catch (IOException iOException) {
                    this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), UpgradeHelper.i18n("plugin.exception_adding_file_to_zip", iOException, string2)));
                    continue;
                }
                finally {
                    this.close(fileInputStream);
                }
            }
            this.updateObservers((PlugInObservation)new PlugInMessageObservation(this.getName(), UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.execute.message.end.text", (File)this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY), (String)this._context.get((Object)DomainPlugInConstants.DOMAIN_BACKUP_FILE_KEY))));
            UpgradeHelper.addSummaryMessage(this._context, this.getName(), UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.execute.domain_dir_backed_up_to", file.getAbsoluteFile().getCanonicalFile().getPath()));
            this.close(zipOutputStream);
        }
        catch (IOException iOException) {
            throw new PlugInException(this.getName(), UpgradeHelper.i18n("DomainDirectoryBackupPlugIn.execute.failure.text"), (Throwable)iOException);
        }
        finally {
            this.close(zipOutputStream);
        }
    }

    private void replaceMigratedConfigWithOriginal(File file) {
        try {
            File file2 = new File(file.getAbsolutePath(), "config.xml.beforeMigration");
            if (file2.exists()) {
                File file3 = new File(file.getAbsolutePath(), "config.xml");
                FileUtils.copy((File)file2, (File)file3);
                FileUtils.remove((File)file2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String makeAddMessage(StringBuffer stringBuffer, ZipEntry zipEntry) {
        stringBuffer.append(zipEntry.getName());
        if (zipEntry.getMethod() == 8) {
            long l = zipEntry.getSize();
            if (l > 0L) {
                long l2 = zipEntry.getCompressedSize();
                long l3 = (l - l2) * 100L / l;
                stringBuffer.append(" (deflated " + l3 + "%)");
            } else {
                stringBuffer.append(" (deflated 0%)");
            }
        } else {
            stringBuffer.append(" (stored 0%)");
        }
        return stringBuffer.toString();
    }

    private void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private FileFilter getFileFilter() {
        DDBPFileFilter dDBPFileFilter = null;
        try {
            dDBPFileFilter = new DDBPFileFilter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dDBPFileFilter;
    }

    private boolean skipLogFiles() {
        boolean bl = false;
        String[] stringArray = (String[])this._context.get((Object)DomainPlugInConstants.OPTIONAL_GROUPS_KEY);
        bl = !Arrays.asList(stringArray).contains("DOMAIN_DIRECTORY_BACKUP_LOG_FILES_INCLUDED_SELECTED_VALUE");
        return bl;
    }

    private class DDBPFileFilter
    implements FileFilter {
        private File dir;
        private long domainDirSelectionTime;
        private Set logfiles = new HashSet();

        public DDBPFileFilter() {
            this.dir = (File)DomainDirectoryBackupPlugIn.this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
            this.domainDirSelectionTime = ((Date)DomainDirectoryBackupPlugIn.this._context.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_SELECTION_DATE_KEY)).getTime();
            if (DomainDirectoryBackupPlugIn.this.skipLogFiles()) {
                String[] stringArray = (String[])DomainDirectoryBackupPlugIn.this._context.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
                DomainMBean domainMBean = (DomainMBean)DomainDirectoryBackupPlugIn.this._context.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
                String string = domainMBean.getConfigurationVersion();
                LogMBean logMBean = domainMBean.getLog();
                File file = new File(logMBean.getFileName());
                if (!file.isAbsolute()) {
                    if (string.startsWith("6") || string.startsWith("7")) {
                        String string2 = logMBean.getFileName();
                        if (string2.startsWith("./")) {
                            string2 = string2.substring(2);
                        }
                        file = new File(this.dir, string2);
                    } else {
                        file = new File(this.dir, file.getName());
                    }
                }
                if (file.exists()) {
                    this.logfiles.add(file);
                }
                if (file.getParentFile().exists()) {
                    this.logfiles.addAll(Arrays.asList(file.getParentFile().listFiles(new WeblogicLogfileFilter(new File(file.getName())))));
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object;
                    ServerMBean serverMBean = null;
                    try {
                        serverMBean = domainMBean.lookupServer(stringArray[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (serverMBean == null) continue;
                    LogMBean logMBean2 = serverMBean.getLog();
                    File file2 = new File(logMBean2.getFileName());
                    if (!file2.isAbsolute()) {
                        if (string.startsWith("6") || string.startsWith("7")) {
                            object = logMBean2.getFileName();
                            if (((String)object).startsWith("./")) {
                                object = ((String)object).substring(2);
                            }
                            file2 = new File(this.dir, (String)object);
                        } else {
                            object = new File(this.dir, stringArray[i]);
                            file2 = new File((File)object, file2.getName());
                        }
                    }
                    object = new File(file2.getParentFile(), "access.log");
                    if (file2.exists()) {
                        this.logfiles.add(file2);
                    }
                    if (((File)object).exists()) {
                        this.logfiles.add(object);
                    }
                    WeblogicLogfileFilter weblogicLogfileFilter = new WeblogicLogfileFilter(new File(file2.getName()));
                    if (!file2.getParentFile().exists()) continue;
                    this.logfiles.addAll(Arrays.asList(file2.getParentFile().listFiles(weblogicLogfileFilter)));
                }
                DomainDirectoryBackupPlugIn.this.updateObservers((PlugInObservation)new PlugInMessageObservation(DomainDirectoryBackupPlugIn.this.getName(), "Will skip adding " + this.logfiles.size() + " log files to zip archive"));
            }
        }

        public boolean accept(File file) {
            if (!file.isDirectory() && file.lastModified() > this.domainDirSelectionTime) {
                return false;
            }
            if (file.getName().startsWith("weblogic-domain-backup") && file.getParentFile().equals(this.dir) || file.getName().equals(".wlnotdelete")) {
                return false;
            }
            if (DomainDirectoryBackupPlugIn.this.skipLogFiles()) {
                return !this.logfiles.contains(file);
            }
            return true;
        }
    }
}

