/*
 * Decompiled with CFR 0.152.
 */
package weblogic.upgrade.domain.directoryrestructure;

import com.bea.plateng.plugin.PlugInContext;
import com.bea.plateng.plugin.PlugInException;
import java.io.File;
import java.io.IOException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.upgrade.domain.DomainPlugInConstants;
import weblogic.upgrade.domain.directoryrestructure.BaseFileRestructurePlugin;

public class DirectoryRestructureCleanupPlugin
extends BaseFileRestructurePlugin {
    private File upgradeDir;
    private File upgradeAbsDir;
    private String upgradeDirPath;
    private File parentDir;
    private DomainMBean domainBean;
    private String[] serverNames;

    public void prepare(PlugInContext plugInContext) throws PlugInException {
        try {
            super.prepare(plugInContext);
        }
        catch (PlugInException plugInException) {
            throw plugInException;
        }
        catch (Exception exception) {
            throw new PlugInException(this.getName(), "Prepare Exception", (Throwable)exception);
        }
        this.domainBean = (DomainMBean)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_BEAN_TREE_KEY);
        if (this.domainBean == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoBeanTree");
        }
        this.upgradeDir = (File)plugInContext.get((Object)DomainPlugInConstants.DOMAIN_DIRECTORY_KEY);
        if (this.upgradeDir == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoDomainDir");
        }
        try {
            this.upgradeAbsDir = this.upgradeDir.getCanonicalFile();
            this.parentDir = this.upgradeAbsDir.getParentFile();
            this.upgradeDirPath = this.upgradeDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.DirectoryProcessingException", iOException);
        }
        this.serverNames = (String[])plugInContext.get((Object)DomainPlugInConstants.SERVER_NAMES_KEY);
        if (this.serverNames == null) {
            throw this.createException("DomainDirectoryFileReorgPlugIn.exc.NoServerNames");
        }
    }

    public void execute() throws PlugInException {
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.InExecuteMethod", "DirectoryRestructureCleanup");
        for (int i = 0; i < this.serverNames.length; ++i) {
            String string = this.serverNames[i];
            ServerMBean serverMBean = this.domainBean.lookupServer(string);
        }
        this.updateStatus("DomainDirectoryFileReorgPlugIn.msg.OutExecuteMethod", "DirectoryRestructureCleanup");
    }
}

